/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.v1;

import com.google.common.io.BaseEncoding;
import java.nio.charset.StandardCharsets;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import org.cryptomator.cryptolib.api.AuthenticationFailedException;
import org.cryptomator.cryptolib.api.FileNameCryptor;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.cryptolib.common.DestroyableSecretKey;
import org.cryptomator.cryptolib.common.MessageDigestSupplier;
import org.cryptomator.siv.SivMode;
import org.cryptomator.siv.UnauthenticCiphertextException;

class FileNameCryptorImpl
implements FileNameCryptor {
    private static final BaseEncoding BASE32 = BaseEncoding.base32();
    private static final ThreadLocal<SivMode> AES_SIV = new ThreadLocal<SivMode>(){

        @Override
        protected SivMode initialValue() {
            return new SivMode();
        }
    };
    private final Masterkey masterkey;

    FileNameCryptorImpl(Masterkey masterkey) {
        this.masterkey = masterkey;
    }

    @Override
    public String hashDirectoryId(String cleartextDirectoryId) {
        try (DestroyableSecretKey ek = this.masterkey.getEncKey();){
            DestroyableSecretKey mk = this.masterkey.getMacKey();
            try {
                byte[] cleartextBytes = cleartextDirectoryId.getBytes(StandardCharsets.UTF_8);
                byte[] encryptedBytes = AES_SIV.get().encrypt((SecretKey)ek, (SecretKey)mk, cleartextBytes, (byte[][])new byte[0][]);
                byte[] hashedBytes = MessageDigestSupplier.SHA1.get().digest(encryptedBytes);
                String string = BASE32.encode(hashedBytes);
                if (mk != null) {
                    mk.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                if (mk != null) {
                    try {
                        mk.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    @Override
    public String encryptFilename(BaseEncoding encoding, String cleartextName, byte[] ... associatedData) {
        try (DestroyableSecretKey ek = this.masterkey.getEncKey();){
            DestroyableSecretKey mk = this.masterkey.getMacKey();
            try {
                byte[] cleartextBytes = cleartextName.getBytes(StandardCharsets.UTF_8);
                byte[] encryptedBytes = AES_SIV.get().encrypt((SecretKey)ek, (SecretKey)mk, cleartextBytes, associatedData);
                String string = encoding.encode(encryptedBytes);
                if (mk != null) {
                    mk.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                if (mk != null) {
                    try {
                        mk.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String decryptFilename(BaseEncoding encoding, String ciphertextName, byte[] ... associatedData) throws AuthenticationFailedException {
        try (DestroyableSecretKey ek = this.masterkey.getEncKey();){
            DestroyableSecretKey mk = this.masterkey.getMacKey();
            try {
                byte[] encryptedBytes = encoding.decode((CharSequence)ciphertextName);
                byte[] cleartextBytes = AES_SIV.get().decrypt((SecretKey)ek, (SecretKey)mk, encryptedBytes, associatedData);
                String string = new String(cleartextBytes, StandardCharsets.UTF_8);
                if (mk != null) {
                    mk.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                if (mk != null) {
                    try {
                        mk.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IllegalArgumentException | IllegalBlockSizeException | UnauthenticCiphertextException e) {
            throw new AuthenticationFailedException("Invalid Ciphertext.", e);
        }
    }
}

