/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common;

import java.util.Comparator;
import org.apache.commons.lang3.StringUtils;

public class SemVerComparator
implements Comparator<String> {
    private static final char VERSION_SEP = '.';
    private static final String PRE_RELEASE_SEP = "-";
    private static final String BUILD_SEP = "+";

    @Override
    public int compare(String version1, String version2) {
        String v2WithoutBuildMetadata;
        String v1WithoutBuildMetadata = StringUtils.substringBefore((String)version1, (String)BUILD_SEP);
        if (v1WithoutBuildMetadata.equals(v2WithoutBuildMetadata = StringUtils.substringBefore((String)version2, (String)BUILD_SEP))) {
            return 0;
        }
        String v1MajorMinorPatch = StringUtils.substringBefore((String)v1WithoutBuildMetadata, (String)PRE_RELEASE_SEP);
        String v2MajorMinorPatch = StringUtils.substringBefore((String)v2WithoutBuildMetadata, (String)PRE_RELEASE_SEP);
        String v1PreReleaseVersion = StringUtils.substringAfter((String)v1WithoutBuildMetadata, (String)PRE_RELEASE_SEP);
        String v2PreReleaseVersion = StringUtils.substringAfter((String)v2WithoutBuildMetadata, (String)PRE_RELEASE_SEP);
        return this.compare(v1MajorMinorPatch, v1PreReleaseVersion, v2MajorMinorPatch, v2PreReleaseVersion);
    }

    private int compare(String v1MajorMinorPatch, String v1PreReleaseVersion, String v2MajorMinorPatch, String v2PreReleaseVersion) {
        int comparisonResult = this.compareNumericallyThenLexicographically(v1MajorMinorPatch, v2MajorMinorPatch);
        if (comparisonResult == 0) {
            if (v1PreReleaseVersion.isEmpty()) {
                return 1;
            }
            if (v2PreReleaseVersion.isEmpty()) {
                return -1;
            }
            return this.compareNumericallyThenLexicographically(v1PreReleaseVersion, v2PreReleaseVersion);
        }
        return comparisonResult;
    }

    private int compareNumericallyThenLexicographically(String version1, String version2) {
        String[] vComps1 = StringUtils.split((String)version1, (char)'.');
        String[] vComps2 = StringUtils.split((String)version2, (char)'.');
        int commonCompCount = Math.min(vComps1.length, vComps2.length);
        for (int i = 0; i < commonCompCount; ++i) {
            int subversionComparisonResult = 0;
            try {
                int v1 = Integer.parseInt(vComps1[i]);
                int v2 = Integer.parseInt(vComps2[i]);
                subversionComparisonResult = v1 - v2;
            }
            catch (NumberFormatException ex) {
                subversionComparisonResult = vComps1[i].compareTo(vComps2[i]);
            }
            if (subversionComparisonResult == 0) continue;
            return subversionComparisonResult;
        }
        return vComps1.length - vComps2.length;
    }
}

