/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.mountpoint;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.common.mountpoint.MountPointChooser;
import org.cryptomator.common.settings.VaultSettings;
import org.cryptomator.common.vaults.Volume;

class CustomDriveLetterChooser
implements MountPointChooser {
    private final VaultSettings vaultSettings;

    @Inject
    public CustomDriveLetterChooser(VaultSettings vaultSettings) {
        this.vaultSettings = vaultSettings;
    }

    @Override
    public boolean isApplicable(Volume caller) {
        return SystemUtils.IS_OS_WINDOWS;
    }

    @Override
    public Optional<Path> chooseMountPoint(Volume caller) {
        return this.vaultSettings.getWinDriveLetter().map(letter -> letter.charAt(0) + ":\\").map(x$0 -> Paths.get(x$0, new String[0]));
    }
}

