/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.settings;

import java.util.function.Consumer;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.NodeOrientation;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.common.Environment;
import org.cryptomator.common.settings.UiTheme;
import org.cryptomator.common.settings.VaultSettings;
import org.cryptomator.common.settings.VolumeImpl;
import org.cryptomator.common.settings.WebDavUrlScheme;

public class Settings {
    public static final int MIN_PORT = 1024;
    public static final int MAX_PORT = 65535;
    public static final boolean DEFAULT_ASKED_FOR_UPDATE_CHECK = false;
    public static final boolean DEFAULT_CHECK_FOR_UPDATES = false;
    public static final boolean DEFAULT_START_HIDDEN = false;
    public static final int DEFAULT_PORT = 42427;
    public static final int DEFAULT_NUM_TRAY_NOTIFICATIONS = 3;
    public static final WebDavUrlScheme DEFAULT_GVFS_SCHEME = WebDavUrlScheme.DAV;
    public static final boolean DEFAULT_DEBUG_MODE = false;
    public static final VolumeImpl DEFAULT_PREFERRED_VOLUME_IMPL = SystemUtils.IS_OS_WINDOWS ? VolumeImpl.DOKANY : VolumeImpl.FUSE;
    public static final UiTheme DEFAULT_THEME = UiTheme.LIGHT;
    @Deprecated
    public static final String DEFAULT_KEYCHAIN_PROVIDER = SystemUtils.IS_OS_WINDOWS ? "org.cryptomator.windows.keychain.WindowsProtectedKeychainAccess" : (SystemUtils.IS_OS_MAC ? "org.cryptomator.macos.keychain.MacSystemKeychainAccess" : "org.cryptomator.linux.keychain.SecretServiceKeychainAccess");
    public static final NodeOrientation DEFAULT_USER_INTERFACE_ORIENTATION = NodeOrientation.LEFT_TO_RIGHT;
    public static final String DEFAULT_LICENSE_KEY = "";
    public static final boolean DEFAULT_SHOW_MINIMIZE_BUTTON = false;
    public static final String DEFAULT_DISPLAY_CONFIGURATION = "";
    private final ObservableList<VaultSettings> directories = FXCollections.observableArrayList(VaultSettings::observables);
    private final BooleanProperty askedForUpdateCheck = new SimpleBooleanProperty(false);
    private final BooleanProperty checkForUpdates = new SimpleBooleanProperty(false);
    private final BooleanProperty startHidden = new SimpleBooleanProperty(false);
    private final IntegerProperty port = new SimpleIntegerProperty(42427);
    private final IntegerProperty numTrayNotifications = new SimpleIntegerProperty(3);
    private final ObjectProperty<WebDavUrlScheme> preferredGvfsScheme = new SimpleObjectProperty((Object)DEFAULT_GVFS_SCHEME);
    private final BooleanProperty debugMode = new SimpleBooleanProperty(false);
    private final ObjectProperty<VolumeImpl> preferredVolumeImpl = new SimpleObjectProperty((Object)DEFAULT_PREFERRED_VOLUME_IMPL);
    private final ObjectProperty<UiTheme> theme = new SimpleObjectProperty((Object)DEFAULT_THEME);
    private final ObjectProperty<String> keychainProvider = new SimpleObjectProperty((Object)DEFAULT_KEYCHAIN_PROVIDER);
    private final ObjectProperty<NodeOrientation> userInterfaceOrientation = new SimpleObjectProperty((Object)DEFAULT_USER_INTERFACE_ORIENTATION);
    private final StringProperty licenseKey = new SimpleStringProperty("");
    private final BooleanProperty showMinimizeButton = new SimpleBooleanProperty(false);
    private final BooleanProperty showTrayIcon;
    private final IntegerProperty windowXPosition = new SimpleIntegerProperty();
    private final IntegerProperty windowYPosition = new SimpleIntegerProperty();
    private final IntegerProperty windowWidth = new SimpleIntegerProperty();
    private final IntegerProperty windowHeight = new SimpleIntegerProperty();
    private final ObjectProperty<String> displayConfiguration = new SimpleObjectProperty((Object)"");
    private Consumer<Settings> saveCmd;

    Settings(Environment env) {
        this.showTrayIcon = new SimpleBooleanProperty(env.showTrayIcon());
        this.directories.addListener(this::somethingChanged);
        this.askedForUpdateCheck.addListener(this::somethingChanged);
        this.checkForUpdates.addListener(this::somethingChanged);
        this.startHidden.addListener(this::somethingChanged);
        this.port.addListener(this::somethingChanged);
        this.numTrayNotifications.addListener(this::somethingChanged);
        this.preferredGvfsScheme.addListener(this::somethingChanged);
        this.debugMode.addListener(this::somethingChanged);
        this.preferredVolumeImpl.addListener(this::somethingChanged);
        this.theme.addListener(this::somethingChanged);
        this.keychainProvider.addListener(this::somethingChanged);
        this.userInterfaceOrientation.addListener(this::somethingChanged);
        this.licenseKey.addListener(this::somethingChanged);
        this.showMinimizeButton.addListener(this::somethingChanged);
        this.showTrayIcon.addListener(this::somethingChanged);
        this.windowXPosition.addListener(this::somethingChanged);
        this.windowYPosition.addListener(this::somethingChanged);
        this.windowWidth.addListener(this::somethingChanged);
        this.windowHeight.addListener(this::somethingChanged);
        this.displayConfiguration.addListener(this::somethingChanged);
    }

    void setSaveCmd(Consumer<Settings> saveCmd) {
        this.saveCmd = saveCmd;
    }

    private void somethingChanged(Observable observable) {
        this.save();
    }

    void save() {
        if (this.saveCmd != null) {
            this.saveCmd.accept(this);
        }
    }

    public ObservableList<VaultSettings> getDirectories() {
        return this.directories;
    }

    public BooleanProperty askedForUpdateCheck() {
        return this.askedForUpdateCheck;
    }

    public BooleanProperty checkForUpdates() {
        return this.checkForUpdates;
    }

    public BooleanProperty startHidden() {
        return this.startHidden;
    }

    public IntegerProperty port() {
        return this.port;
    }

    public IntegerProperty numTrayNotifications() {
        return this.numTrayNotifications;
    }

    public ObjectProperty<WebDavUrlScheme> preferredGvfsScheme() {
        return this.preferredGvfsScheme;
    }

    public BooleanProperty debugMode() {
        return this.debugMode;
    }

    public ObjectProperty<VolumeImpl> preferredVolumeImpl() {
        return this.preferredVolumeImpl;
    }

    public ObjectProperty<UiTheme> theme() {
        return this.theme;
    }

    public ObjectProperty<String> keychainProvider() {
        return this.keychainProvider;
    }

    public ObjectProperty<NodeOrientation> userInterfaceOrientation() {
        return this.userInterfaceOrientation;
    }

    public StringProperty licenseKey() {
        return this.licenseKey;
    }

    public BooleanProperty showMinimizeButton() {
        return this.showMinimizeButton;
    }

    public BooleanProperty showTrayIcon() {
        return this.showTrayIcon;
    }

    public IntegerProperty windowXPositionProperty() {
        return this.windowXPosition;
    }

    public IntegerProperty windowYPositionProperty() {
        return this.windowYPosition;
    }

    public IntegerProperty windowWidthProperty() {
        return this.windowWidth;
    }

    public IntegerProperty windowHeightProperty() {
        return this.windowHeight;
    }

    public ObjectProperty<String> displayConfigurationProperty() {
        return this.displayConfiguration;
    }
}

