/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.settings;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.cryptomator.common.settings.WhenUnlocked;

public class VaultSettings {
    public static final boolean DEFAULT_UNLOCK_AFTER_STARTUP = false;
    public static final boolean DEFAULT_REVEAL_AFTER_MOUNT = true;
    public static final boolean DEFAULT_USES_INDIVIDUAL_MOUNTPATH = false;
    public static final boolean DEFAULT_USES_READONLY_MODE = false;
    public static final String DEFAULT_MOUNT_FLAGS = "";
    public static final int DEFAULT_MAX_CLEARTEXT_FILENAME_LENGTH = -1;
    public static final WhenUnlocked DEFAULT_ACTION_AFTER_UNLOCK = WhenUnlocked.ASK;
    public static final boolean DEFAULT_AUTOLOCK_WHEN_IDLE = false;
    public static final int DEFAULT_AUTOLOCK_IDLE_SECONDS = 1800;
    private static final Random RNG = new Random();
    private final String id;
    private final ObjectProperty<Path> path = new SimpleObjectProperty();
    private final StringProperty displayName = new SimpleStringProperty();
    private final StringProperty winDriveLetter = new SimpleStringProperty();
    private final BooleanProperty unlockAfterStartup = new SimpleBooleanProperty(false);
    private final BooleanProperty revealAfterMount = new SimpleBooleanProperty(true);
    private final BooleanProperty useCustomMountPath = new SimpleBooleanProperty(false);
    private final StringProperty customMountPath = new SimpleStringProperty();
    private final BooleanProperty usesReadOnlyMode = new SimpleBooleanProperty(false);
    private final StringProperty mountFlags = new SimpleStringProperty("");
    private final IntegerProperty maxCleartextFilenameLength = new SimpleIntegerProperty(-1);
    private final ObjectProperty<WhenUnlocked> actionAfterUnlock = new SimpleObjectProperty((Object)DEFAULT_ACTION_AFTER_UNLOCK);
    private final BooleanProperty autoLockWhenIdle = new SimpleBooleanProperty(false);
    private final IntegerProperty autoLockIdleSeconds = new SimpleIntegerProperty(1800);
    private final StringBinding mountName;

    public VaultSettings(String id) {
        this.id = Objects.requireNonNull(id);
        this.mountName = Bindings.createStringBinding(this::normalizeDisplayName, (Observable[])new Observable[]{this.displayName});
    }

    Observable[] observables() {
        return new Observable[]{this.path, this.displayName, this.winDriveLetter, this.unlockAfterStartup, this.revealAfterMount, this.useCustomMountPath, this.customMountPath, this.usesReadOnlyMode, this.mountFlags, this.maxCleartextFilenameLength, this.actionAfterUnlock, this.autoLockWhenIdle, this.autoLockIdleSeconds};
    }

    public static VaultSettings withRandomId() {
        return new VaultSettings(VaultSettings.generateId());
    }

    private static String generateId() {
        byte[] randomBytes = new byte[9];
        RNG.nextBytes(randomBytes);
        return BaseEncoding.base64Url().encode(randomBytes);
    }

    String normalizeDisplayName() {
        String original = this.displayName.getValueSafe();
        if (original.isBlank() || ".".equals(original) || "..".equals(original)) {
            return "_";
        }
        String withoutFancyWhitespaces = CharMatcher.whitespace().collapseFrom((CharSequence)original, ' ');
        return CharMatcher.anyOf((CharSequence)"<>:\"/\\|?*").or(CharMatcher.javaIsoControl()).collapseFrom((CharSequence)withoutFancyWhitespaces, '_');
    }

    public String getId() {
        return this.id;
    }

    public ObjectProperty<Path> path() {
        return this.path;
    }

    public StringProperty displayName() {
        return this.displayName;
    }

    public StringBinding mountName() {
        return this.mountName;
    }

    public StringProperty winDriveLetter() {
        return this.winDriveLetter;
    }

    public Optional<String> getWinDriveLetter() {
        String current = (String)this.winDriveLetter.get();
        if (!Strings.isNullOrEmpty((String)current)) {
            return Optional.of(current);
        }
        return Optional.empty();
    }

    public BooleanProperty unlockAfterStartup() {
        return this.unlockAfterStartup;
    }

    public BooleanProperty revealAfterMount() {
        return this.revealAfterMount;
    }

    public BooleanProperty useCustomMountPath() {
        return this.useCustomMountPath;
    }

    public StringProperty customMountPath() {
        return this.customMountPath;
    }

    public Optional<String> getCustomMountPath() {
        if (this.useCustomMountPath.get()) {
            return Optional.ofNullable(Strings.emptyToNull((String)((String)this.customMountPath.get())));
        }
        return Optional.empty();
    }

    public BooleanProperty usesReadOnlyMode() {
        return this.usesReadOnlyMode;
    }

    public StringProperty mountFlags() {
        return this.mountFlags;
    }

    public IntegerProperty maxCleartextFilenameLength() {
        return this.maxCleartextFilenameLength;
    }

    public ObjectProperty<WhenUnlocked> actionAfterUnlock() {
        return this.actionAfterUnlock;
    }

    public WhenUnlocked getActionAfterUnlock() {
        return (WhenUnlocked)((Object)this.actionAfterUnlock.get());
    }

    public BooleanProperty autoLockWhenIdle() {
        return this.autoLockWhenIdle;
    }

    public IntegerProperty autoLockIdleSeconds() {
        return this.autoLockIdleSeconds;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (obj instanceof VaultSettings) {
            VaultSettings other = (VaultSettings)obj;
            if (obj.getClass().equals(this.getClass())) {
                return Objects.equals(this.id, other.id);
            }
        }
        return false;
    }
}

