/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.vaults;

import java.nio.file.Path;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import org.cryptomator.common.mountpoint.InvalidMountPointException;
import org.cryptomator.common.mountpoint.MountPointChooser;
import org.cryptomator.common.settings.VaultSettings;
import org.cryptomator.common.settings.VolumeImpl;
import org.cryptomator.common.vaults.AbstractVolume;
import org.cryptomator.common.vaults.MountPointRequirement;
import org.cryptomator.common.vaults.Volume;
import org.cryptomator.cryptofs.CryptoFileSystem;
import org.cryptomator.frontend.dokany.DokanyMountFailedException;
import org.cryptomator.frontend.dokany.Mount;
import org.cryptomator.frontend.dokany.MountFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DokanyVolume
extends AbstractVolume {
    private static final Logger LOG = LoggerFactory.getLogger(DokanyVolume.class);
    private static final String FS_TYPE_NAME = "CryptomatorFS";
    private final VaultSettings vaultSettings;
    private Mount mount;

    @Inject
    public DokanyVolume(VaultSettings vaultSettings, @Named(value="orderedMountPointChoosers") Iterable<MountPointChooser> choosers) {
        super(choosers);
        this.vaultSettings = vaultSettings;
    }

    @Override
    public VolumeImpl getImplementationType() {
        return VolumeImpl.DOKANY;
    }

    @Override
    public void mount(CryptoFileSystem fs, String mountFlags, Consumer<Throwable> onExitAction) throws InvalidMountPointException, Volume.VolumeException {
        this.mountPoint = this.determineMountPoint();
        try {
            this.mount = MountFactory.mount((Path)fs.getPath("/", new String[0]), (Path)this.mountPoint, (String)this.vaultSettings.mountName().get(), (String)FS_TYPE_NAME, (String)mountFlags.strip(), onExitAction);
        }
        catch (DokanyMountFailedException e) {
            if (this.vaultSettings.getCustomMountPath().isPresent()) {
                LOG.warn("Failed to mount vault into {}. Is this directory currently accessed by another process (e.g. Windows Explorer)?", (Object)this.mountPoint);
            }
            throw new Volume.VolumeException("Unable to mount Filesystem", e);
        }
    }

    @Override
    public void reveal(Volume.Revealer revealer) throws Volume.VolumeException {
        try {
            this.mount.reveal(revealer::reveal);
        }
        catch (Exception e) {
            throw new Volume.VolumeException(e);
        }
    }

    @Override
    public void unmount() throws Volume.VolumeException {
        try {
            this.mount.unmount();
        }
        catch (IllegalStateException e) {
            throw new Volume.VolumeException("Unmount Failed.", e);
        }
        this.cleanupMountPoint();
    }

    @Override
    public void unmountForced() {
        this.mount.unmountForced();
        this.cleanupMountPoint();
    }

    @Override
    public boolean supportsForcedUnmount() {
        return true;
    }

    @Override
    public boolean isSupported() {
        return DokanyVolume.isSupportedStatic();
    }

    @Override
    public MountPointRequirement getMountPointRequirement() {
        return MountPointRequirement.EMPTY_MOUNT_POINT;
    }

    public static boolean isSupportedStatic() {
        return MountFactory.isApplicable();
    }
}

