/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.vaults;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.cryptomator.common.mountpoint.InvalidMountPointException;
import org.cryptomator.common.settings.VolumeImpl;
import org.cryptomator.common.vaults.DokanyVolume;
import org.cryptomator.common.vaults.FuseVolume;
import org.cryptomator.common.vaults.MountPointRequirement;
import org.cryptomator.common.vaults.WebDavVolume;
import org.cryptomator.cryptofs.CryptoFileSystem;

public interface Volume {
    public boolean isSupported();

    public VolumeImpl getImplementationType();

    public void mount(CryptoFileSystem var1, String var2, Consumer<Throwable> var3) throws IOException, VolumeException, InvalidMountPointException;

    public void reveal(Revealer var1) throws VolumeException;

    public void unmount() throws VolumeException;

    public Optional<Path> getMountPoint();

    public MountPointRequirement getMountPointRequirement();

    default public boolean supportsForcedUnmount() {
        return false;
    }

    default public void unmountForced() throws VolumeException {
        throw new VolumeException("Operation not supported.");
    }

    public static VolumeImpl[] getCurrentSupportedAdapters() {
        return (VolumeImpl[])Stream.of(VolumeImpl.values()).filter(impl -> switch (impl) {
            default -> throw new IncompatibleClassChangeError();
            case VolumeImpl.WEBDAV -> WebDavVolume.isSupportedStatic();
            case VolumeImpl.DOKANY -> DokanyVolume.isSupportedStatic();
            case VolumeImpl.FUSE -> FuseVolume.isSupportedStatic();
        }).toArray(VolumeImpl[]::new);
    }

    public static class VolumeException
    extends Exception {
        public VolumeException(String message) {
            super(message);
        }

        public VolumeException(Throwable cause) {
            super(cause);
        }

        public VolumeException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @FunctionalInterface
    public static interface Revealer {
        public void reveal(Path var1) throws VolumeException;
    }
}

