/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.addvaultwizard;

import dagger.Lazy;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.stage.Stage;
import javax.inject.Inject;
import javax.inject.Named;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultListManager;
import org.cryptomator.cryptofs.CryptoFileSystem;
import org.cryptomator.cryptofs.CryptoFileSystemProperties;
import org.cryptomator.cryptofs.CryptoFileSystemProvider;
import org.cryptomator.cryptolib.api.CryptoException;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.cryptolib.api.MasterkeyLoader;
import org.cryptomator.cryptolib.common.MasterkeyFileAccess;
import org.cryptomator.ui.addvaultwizard.AddVaultWizardScoped;
import org.cryptomator.ui.addvaultwizard.AddVaultWizardWindow;
import org.cryptomator.ui.addvaultwizard.ReadmeGenerator;
import org.cryptomator.ui.common.ErrorComponent;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.common.NewPasswordController;
import org.cryptomator.ui.common.Tasks;
import org.cryptomator.ui.recoverykey.RecoveryKeyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AddVaultWizardScoped
public class CreateNewVaultPasswordController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(CreateNewVaultPasswordController.class);
    private static final URI DEFAULT_KEY_ID = URI.create("masterkeyfile:masterkey.cryptomator");
    private final Stage window;
    private final Lazy<Scene> chooseLocationScene;
    private final Lazy<Scene> recoveryKeyScene;
    private final Lazy<Scene> successScene;
    private final ErrorComponent.Builder errorComponent;
    private final ExecutorService executor;
    private final RecoveryKeyFactory recoveryKeyFactory;
    private final StringProperty vaultNameProperty;
    private final ObjectProperty<Path> vaultPathProperty;
    private final ObjectProperty<Vault> vaultProperty;
    private final StringProperty recoveryKeyProperty;
    private final VaultListManager vaultListManager;
    private final ResourceBundle resourceBundle;
    private final ReadmeGenerator readmeGenerator;
    private final SecureRandom csprng;
    private final MasterkeyFileAccess masterkeyFileAccess;
    private final BooleanProperty processing;
    private final BooleanProperty readyToCreateVault;
    private final ObjectBinding<ContentDisplay> createVaultButtonState;
    public ToggleGroup recoveryKeyChoice;
    public Toggle showRecoveryKey;
    public Toggle skipRecoveryKey;
    public NewPasswordController newPasswordSceneController;

    @Inject
    CreateNewVaultPasswordController(@AddVaultWizardWindow Stage window, @FxmlScene(value=FxmlFile.ADDVAULT_NEW_LOCATION) Lazy<Scene> chooseLocationScene, @FxmlScene(value=FxmlFile.ADDVAULT_NEW_RECOVERYKEY) Lazy<Scene> recoveryKeyScene, @FxmlScene(value=FxmlFile.ADDVAULT_SUCCESS) Lazy<Scene> successScene, ErrorComponent.Builder errorComponent, ExecutorService executor, RecoveryKeyFactory recoveryKeyFactory, @Named(value="vaultName") StringProperty vaultName, ObjectProperty<Path> vaultPath, @AddVaultWizardWindow ObjectProperty<Vault> vault, @Named(value="recoveryKey") StringProperty recoveryKey, VaultListManager vaultListManager, ResourceBundle resourceBundle, ReadmeGenerator readmeGenerator, SecureRandom csprng, MasterkeyFileAccess masterkeyFileAccess) {
        this.window = window;
        this.chooseLocationScene = chooseLocationScene;
        this.recoveryKeyScene = recoveryKeyScene;
        this.successScene = successScene;
        this.errorComponent = errorComponent;
        this.executor = executor;
        this.recoveryKeyFactory = recoveryKeyFactory;
        this.vaultNameProperty = vaultName;
        this.vaultPathProperty = vaultPath;
        this.vaultProperty = vault;
        this.recoveryKeyProperty = recoveryKey;
        this.vaultListManager = vaultListManager;
        this.resourceBundle = resourceBundle;
        this.readmeGenerator = readmeGenerator;
        this.csprng = csprng;
        this.masterkeyFileAccess = masterkeyFileAccess;
        this.processing = new SimpleBooleanProperty();
        this.readyToCreateVault = new SimpleBooleanProperty();
        this.createVaultButtonState = Bindings.createObjectBinding(this::getCreateVaultButtonState, (Observable[])new Observable[]{this.processing});
    }

    @FXML
    public void initialize() {
        this.readyToCreateVault.bind((ObservableValue)this.newPasswordSceneController.goodPasswordProperty().and((ObservableBooleanValue)this.recoveryKeyChoice.selectedToggleProperty().isNotNull()).and((ObservableBooleanValue)this.processing.not()));
        this.window.setOnHiding(event -> {
            this.newPasswordSceneController.passwordField.wipe();
            this.newPasswordSceneController.reenterField.wipe();
        });
    }

    @FXML
    public void back() {
        this.window.setScene((Scene)this.chooseLocationScene.get());
    }

    @FXML
    public void next() {
        Path pathToVault = (Path)this.vaultPathProperty.get();
        try {
            Files.createDirectory(pathToVault, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.error("Failed to create vault directory.", (Throwable)e);
            this.errorComponent.cause(e).window(this.window).returnToScene(this.window.getScene()).build().showErrorScene();
            return;
        }
        if (this.showRecoveryKey.equals(this.recoveryKeyChoice.getSelectedToggle())) {
            this.showRecoveryKeyScene();
        } else if (this.skipRecoveryKey.equals(this.recoveryKeyChoice.getSelectedToggle())) {
            this.showSuccessScene();
        } else {
            throw new IllegalStateException("Unexpected toggle state");
        }
    }

    private void showRecoveryKeyScene() {
        Path pathToVault = (Path)this.vaultPathProperty.get();
        this.processing.set(true);
        Tasks.create(() -> {
            this.initializeVault(pathToVault);
            return this.recoveryKeyFactory.createRecoveryKey(pathToVault, this.newPasswordSceneController.passwordField.getCharacters());
        }).onSuccess(recoveryKey -> {
            this.initializationSucceeded(pathToVault);
            this.recoveryKeyProperty.set(recoveryKey);
            this.window.setScene((Scene)this.recoveryKeyScene.get());
        }).onError(IOException.class, e -> {
            LOG.error("Failed to initialize vault.", (Throwable)e);
            this.errorComponent.cause((Throwable)e).window(this.window).returnToScene(this.window.getScene()).build().showErrorScene();
        }).andFinally(() -> this.processing.set(false)).runOnce(this.executor);
    }

    private void showSuccessScene() {
        Path pathToVault = (Path)this.vaultPathProperty.get();
        this.processing.set(true);
        Tasks.create(() -> this.initializeVault(pathToVault)).onSuccess(() -> {
            this.initializationSucceeded(pathToVault);
            this.window.setScene((Scene)this.successScene.get());
        }).onError(IOException.class, e -> {
            LOG.error("Failed to initialize vault.", (Throwable)e);
            this.errorComponent.cause((Throwable)e).window(this.window).returnToScene(this.window.getScene()).build().showErrorScene();
        }).andFinally(() -> this.processing.set(false)).runOnce(this.executor);
    }

    private void initializeVault(Path path) throws IOException {
        Path masterkeyFilePath = path.resolve("masterkey.cryptomator");
        try (Masterkey masterkey = Masterkey.generate((SecureRandom)this.csprng);){
            this.masterkeyFileAccess.persist(masterkey, masterkeyFilePath, this.newPasswordSceneController.passwordField.getCharacters());
            try {
                MasterkeyLoader loader = ignored -> masterkey.copy();
                CryptoFileSystemProperties fsProps = CryptoFileSystemProperties.cryptoFileSystemProperties().withCipherCombo(CryptorProvider.Scheme.SIV_CTRMAC).withKeyLoader(loader).build();
                CryptoFileSystemProvider.initialize((Path)path, (CryptoFileSystemProperties)fsProps, (URI)DEFAULT_KEY_ID);
                String vaultReadmeFileName = this.resourceBundle.getString("addvault.new.readme.accessLocation.fileName");
                try (CryptoFileSystem fs = CryptoFileSystemProvider.newFileSystem((Path)path, (CryptoFileSystemProperties)fsProps);
                     SeekableByteChannel ch = Files.newByteChannel(fs.getPath("/", vaultReadmeFileName), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                    ch.write(StandardCharsets.US_ASCII.encode(this.readmeGenerator.createVaultAccessLocationReadmeRtf()));
                }
            }
            catch (CryptoException e) {
                throw new IOException("Failed initialize vault.", e);
            }
        }
        String storagePathReadmeFileName = this.resourceBundle.getString("addvault.new.readme.storageLocation.fileName");
        try (SeekableByteChannel ch = Files.newByteChannel(path.resolve(storagePathReadmeFileName), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
            ch.write(StandardCharsets.US_ASCII.encode(this.readmeGenerator.createVaultStorageLocationReadmeRtf()));
        }
        LOG.info("Created vault at {}", (Object)path);
    }

    private void initializationSucceeded(Path pathToVault) {
        try {
            Vault newVault = this.vaultListManager.add(pathToVault);
            this.vaultProperty.set((Object)newVault);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String getVaultName() {
        return (String)this.vaultNameProperty.get();
    }

    public StringProperty vaultNameProperty() {
        return this.vaultNameProperty;
    }

    public BooleanProperty readyToCreateVaultProperty() {
        return this.readyToCreateVault;
    }

    public boolean isReadyToCreateVault() {
        return this.readyToCreateVault.get();
    }

    public ObjectBinding<ContentDisplay> createVaultButtonStateProperty() {
        return this.createVaultButtonState;
    }

    public ContentDisplay getCreateVaultButtonState() {
        return this.processing.get() ? ContentDisplay.LEFT : ContentDisplay.TEXT_ONLY;
    }
}

