/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.launcher;

import java.awt.Desktop;
import java.awt.desktop.AboutEvent;
import java.awt.desktop.QuitResponse;
import java.awt.desktop.QuitStrategy;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.collections.ObservableList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.cryptomator.common.ShutdownHook;
import org.cryptomator.common.vaults.LockNotCompletedException;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultState;
import org.cryptomator.common.vaults.Volume;
import org.cryptomator.ui.launcher.FxApplicationStarter;
import org.cryptomator.ui.preferences.SelectedPreferencesTab;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AppLifecycleListener {
    private static final Logger LOG = LoggerFactory.getLogger(AppLifecycleListener.class);
    public static final Set<VaultState.Value> STATES_ALLOWING_TERMINATION = EnumSet.of(VaultState.Value.LOCKED, VaultState.Value.NEEDS_MIGRATION, VaultState.Value.MISSING, VaultState.Value.ERROR);
    private final FxApplicationStarter fxApplicationStarter;
    private final CountDownLatch shutdownLatch;
    private final ObservableList<Vault> vaults;
    private final AtomicBoolean allowQuitWithoutPrompt;

    @Inject
    AppLifecycleListener(FxApplicationStarter fxApplicationStarter, @Named(value="shutdownLatch") CountDownLatch shutdownLatch, ShutdownHook shutdownHook, ObservableList<Vault> vaults) {
        this.fxApplicationStarter = fxApplicationStarter;
        this.shutdownLatch = shutdownLatch;
        this.vaults = vaults;
        this.allowQuitWithoutPrompt = new AtomicBoolean(true);
        vaults.addListener(this::vaultListChanged);
        if (Desktop.getDesktop().isSupported(Desktop.Action.APP_PREFERENCES)) {
            Desktop.getDesktop().setPreferencesHandler(this::showPreferencesWindow);
        }
        if (Desktop.getDesktop().isSupported(Desktop.Action.APP_ABOUT)) {
            Desktop.getDesktop().setAboutHandler(this::showAboutWindow);
        }
        if (Desktop.getDesktop().isSupported(Desktop.Action.APP_QUIT_HANDLER)) {
            Desktop.getDesktop().setQuitHandler(this::handleQuitRequest);
        }
        if (Desktop.getDesktop().isSupported(Desktop.Action.APP_QUIT_STRATEGY)) {
            Desktop.getDesktop().setQuitStrategy(QuitStrategy.CLOSE_ALL_WINDOWS);
        }
        shutdownHook.runOnShutdown(this::forceUnmountRemainingVaults);
    }

    public void quit() {
        this.handleQuitRequest(null, new QuitResponse(){

            @Override
            public void performQuit() {
            }

            @Override
            public void cancelQuit() {
            }
        });
    }

    private void handleQuitRequest(EventObject e, QuitResponse response) {
        QuitResponse decoratedQuitResponse = this.decorateQuitResponse(response);
        if (this.allowQuitWithoutPrompt.get()) {
            decoratedQuitResponse.performQuit();
        } else {
            this.fxApplicationStarter.get().thenAccept(app -> app.showQuitWindow(decoratedQuitResponse));
        }
    }

    private QuitResponse decorateQuitResponse(final QuitResponse originalQuitResponse) {
        return new QuitResponse(){

            @Override
            public void performQuit() {
                Platform.exit();
                AppLifecycleListener.this.shutdownLatch.countDown();
                originalQuitResponse.performQuit();
            }

            @Override
            public void cancelQuit() {
                originalQuitResponse.cancelQuit();
            }
        };
    }

    private void vaultListChanged(Observable observable) {
        assert (Platform.isFxApplicationThread());
        boolean allVaultsAllowTermination = this.vaults.stream().map(Vault::getState).allMatch(STATES_ALLOWING_TERMINATION::contains);
        boolean suddenTerminationChanged = this.allowQuitWithoutPrompt.compareAndSet(!allVaultsAllowTermination, allVaultsAllowTermination);
        if (suddenTerminationChanged) {
            LOG.debug("Allow quitting without prompt: {}", (Object)allVaultsAllowTermination);
        }
    }

    private void showPreferencesWindow(EventObject actionEvent) {
        this.fxApplicationStarter.get().thenAccept(app -> app.showPreferencesWindow(SelectedPreferencesTab.ANY));
    }

    private void showAboutWindow(AboutEvent aboutEvent) {
        this.fxApplicationStarter.get().thenAccept(app -> app.showPreferencesWindow(SelectedPreferencesTab.ABOUT));
    }

    private void forceUnmountRemainingVaults() {
        for (Vault vault : this.vaults) {
            if (!vault.isUnlocked()) continue;
            try {
                vault.lock(true);
            }
            catch (Volume.VolumeException e) {
                LOG.error("Failed to unmount vault " + vault.getPath(), (Throwable)e);
            }
            catch (LockNotCompletedException e) {
                LOG.error("Failed to lock vault " + vault.getPath(), (Throwable)e);
            }
        }
    }
}

