/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.traymenu;

import com.google.common.base.Preconditions;
import java.awt.AWTException;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import javax.inject.Inject;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.ui.traymenu.TrayImageFactory;
import org.cryptomator.ui.traymenu.TrayMenuController;
import org.cryptomator.ui.traymenu.TrayMenuScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TrayMenuScoped
public class TrayIconController {
    private static final Logger LOG = LoggerFactory.getLogger(TrayIconController.class);
    private final TrayMenuController trayMenuController;
    private final TrayIcon trayIcon;
    private volatile boolean initialized;

    @Inject
    TrayIconController(TrayImageFactory imageFactory, TrayMenuController trayMenuController) {
        this.trayMenuController = trayMenuController;
        this.trayIcon = new TrayIcon(imageFactory.loadImage(), "Cryptomator", trayMenuController.getMenu());
    }

    public synchronized void initializeTrayIcon() throws IllegalStateException {
        Preconditions.checkState((!this.initialized ? 1 : 0) != 0);
        this.trayIcon.setImageAutoSize(true);
        if (SystemUtils.IS_OS_WINDOWS) {
            this.trayIcon.addActionListener(this.trayMenuController::showMainWindow);
        }
        try {
            SystemTray.getSystemTray().add(this.trayIcon);
            LOG.debug("initialized tray icon");
        }
        catch (AWTException e) {
            LOG.error("Error adding tray icon", (Throwable)e);
        }
        this.trayMenuController.initTrayMenu();
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

