/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.unlock;

import javafx.fxml.FXML;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.cryptomator.common.vaults.MountPointRequirement;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.unlock.UnlockScoped;
import org.cryptomator.ui.unlock.UnlockWindow;

@UnlockScoped
public class UnlockInvalidMountPointController
implements FxController {
    private final Stage window;
    private final Vault vault;

    @Inject
    UnlockInvalidMountPointController(@UnlockWindow Stage window, @UnlockWindow Vault vault) {
        this.window = window;
        this.vault = vault;
    }

    @FXML
    public void close() {
        this.window.close();
    }

    public String getMountPoint() {
        return this.vault.getVaultSettings().getCustomMountPath().orElse("AUTO");
    }

    public boolean getMustExist() {
        MountPointRequirement requirement = this.vault.getVolume().orElseThrow(() -> new IllegalStateException("Invalid Mountpoint without a Volume?!")).getMountPointRequirement();
        assert (requirement != MountPointRequirement.NONE);
        assert (requirement != MountPointRequirement.PARENT_OPT_MOUNT_POINT);
        return requirement == MountPointRequirement.EMPTY_MOUNT_POINT;
    }
}

