/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn.matchers;

import com.nulabinc.zxcvbn.Scoring;
import com.nulabinc.zxcvbn.WipeableString;
import com.nulabinc.zxcvbn.matchers.BaseMatcher;
import com.nulabinc.zxcvbn.matchers.Match;
import com.nulabinc.zxcvbn.matchers.MatchFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateMatcher
extends BaseMatcher {
    private static final int DATE_MAX_YEAR = 2050;
    private static final int DATE_MIN_YEAR = 1000;
    private static final Map<Integer, ArrayList<Integer[]>> DATE_SPLITS = new HashMap<Integer, ArrayList<Integer[]>>();
    private final Pattern maybe_date_no_separator = Pattern.compile("^\\d{4,8}$");
    private final Pattern maybe_date_with_separator = Pattern.compile("^(\\d{1,4})([\\s/\\\\_.-])(\\d{1,2})\\2(\\d{1,4})$");

    @Override
    public List<Match> execute(CharSequence password) {
        WipeableString token;
        int j;
        int i;
        ArrayList<Match> matches = new ArrayList<Match>();
        for (i = 0; i <= password.length() - 4; ++i) {
            for (j = i + 3; j <= i + 7 && j < password.length(); ++j) {
                token = WipeableString.copy(password, i, j + 1);
                if (!this.maybe_date_no_separator.matcher(token).find()) {
                    token.wipe();
                    continue;
                }
                ArrayList<Dmy> candidates = new ArrayList<Dmy>();
                for (Integer[] date : DATE_SPLITS.get(token.length())) {
                    int k = date[0];
                    int l = date[1];
                    ArrayList<Integer> ints = new ArrayList<Integer>();
                    try {
                        ints.add(WipeableString.parseInt(token.subSequence(0, k)));
                        ints.add(WipeableString.parseInt(token.subSequence(k, l)));
                        ints.add(WipeableString.parseInt(token.subSequence(l, token.length())));
                    }
                    catch (NumberFormatException e) {
                        System.out.println(e.getStackTrace());
                        continue;
                    }
                    Dmy dmy = this.mapIntsToDmy(ints);
                    if (dmy == null) continue;
                    candidates.add(dmy);
                }
                if (candidates.isEmpty()) {
                    token.wipe();
                    continue;
                }
                Dmy bestCandidate = (Dmy)candidates.get(0);
                int minDistance = this.metric((Dmy)candidates.get(0));
                for (Dmy candidate : candidates.subList(1, candidates.size())) {
                    int distance = this.metric(candidate);
                    if (distance >= minDistance) continue;
                    bestCandidate = candidate;
                    minDistance = distance;
                }
                matches.add(MatchFactory.createDateMatch(i, j, token, "", bestCandidate.year, bestCandidate.month, bestCandidate.day));
            }
        }
        for (i = 0; i <= password.length() - 6; ++i) {
            for (j = i + 5; j <= i + 9 && j < password.length(); ++j) {
                token = WipeableString.copy(password, i, j + 1);
                Matcher rxMatch = this.maybe_date_with_separator.matcher(token);
                if (!rxMatch.find()) {
                    token.wipe();
                    continue;
                }
                ArrayList<Integer> ints = new ArrayList<Integer>();
                try {
                    ints.add(WipeableString.parseInt(rxMatch.group(1)));
                    ints.add(WipeableString.parseInt(rxMatch.group(3)));
                    ints.add(WipeableString.parseInt(rxMatch.group(4)));
                }
                catch (NumberFormatException e) {
                    System.out.println(e.getStackTrace());
                    token.wipe();
                    continue;
                }
                Dmy dmy = this.mapIntsToDmy(ints);
                if (dmy == null) {
                    token.wipe();
                    continue;
                }
                matches.add(MatchFactory.createDateMatch(i, j, token, rxMatch.group(2), dmy.year, dmy.month, dmy.day));
            }
        }
        ArrayList<Match> targetMatches = new ArrayList<Match>();
        for (Match match : matches) {
            boolean isSubmatch = false;
            for (Match otherMatch : matches) {
                if (match.equals(otherMatch) || otherMatch.i > match.i || otherMatch.j < match.j) continue;
                isSubmatch = true;
                break;
            }
            if (isSubmatch) continue;
            targetMatches.add(match);
        }
        return this.sorted(targetMatches);
    }

    private int metric(Dmy candidate) {
        return Math.abs(candidate.year - Scoring.REFERENCE_YEAR);
    }

    private Dmy mapIntsToDmy(List<Integer> ints) {
        List rest;
        int y;
        if (ints.get(1) > 31 || ints.get(1) <= 0) {
            return null;
        }
        int over12 = 0;
        int over31 = 0;
        int under1 = 0;
        for (int i : ints) {
            if (99 < i && i < 1000 || i > 2050) {
                return null;
            }
            if (i > 31) {
                ++over31;
            }
            if (i > 12) {
                ++over12;
            }
            if (i > 0) continue;
            ++under1;
        }
        if (over31 >= 2 || over12 == 3 || under1 >= 2) {
            return null;
        }
        HashMap<Integer, List<Integer>> possibleYearSplits = new HashMap<Integer, List<Integer>>();
        possibleYearSplits.put(ints.get(2), ints.subList(0, 2));
        possibleYearSplits.put(ints.get(0), ints.subList(1, 3));
        for (Map.Entry possibleYearSplitRef : possibleYearSplits.entrySet()) {
            y = (Integer)possibleYearSplitRef.getKey();
            rest = (List)possibleYearSplitRef.getValue();
            if (1000 > y || y > 2050) continue;
            Dm dm = this.mapIntsToDm(rest);
            if (dm != null) {
                return new Dmy(dm.day, dm.month, y);
            }
            return null;
        }
        for (Map.Entry possibleYearSplitRef : possibleYearSplits.entrySet()) {
            y = (Integer)possibleYearSplitRef.getKey();
            rest = (List)possibleYearSplitRef.getValue();
            Dm dm = this.mapIntsToDm(rest);
            if (dm == null) continue;
            y = this.twoToFourDigitYear(y);
            return new Dmy(dm.day, dm.month, y);
        }
        return null;
    }

    private Dm mapIntsToDm(List<Integer> ints) {
        ArrayList<Integer> copy = new ArrayList<Integer>(ints);
        Collections.reverse(copy);
        ArrayList<List<Integer>> refs = new ArrayList<List<Integer>>();
        refs.add(ints);
        refs.add(copy);
        for (List list : refs) {
            int d = (Integer)list.get(0);
            int m = (Integer)list.get(1);
            if (1 > d || d > 31 || 1 > m || m > 12) continue;
            return new Dm(d, m);
        }
        return null;
    }

    private int twoToFourDigitYear(int year) {
        if (year > 99) {
            return year;
        }
        if (year > 50) {
            return year + 1900;
        }
        return year + 2000;
    }

    static {
        DATE_SPLITS.put(4, new ArrayList<Integer[]>(){
            {
                this.add(new Integer[]{1, 2});
                this.add(new Integer[]{2, 3});
            }
        });
        DATE_SPLITS.put(5, new ArrayList<Integer[]>(){
            {
                this.add(new Integer[]{1, 3});
                this.add(new Integer[]{2, 3});
            }
        });
        DATE_SPLITS.put(6, new ArrayList<Integer[]>(){
            {
                this.add(new Integer[]{1, 2});
                this.add(new Integer[]{2, 4});
                this.add(new Integer[]{4, 5});
            }
        });
        DATE_SPLITS.put(7, new ArrayList<Integer[]>(){
            {
                this.add(new Integer[]{1, 3});
                this.add(new Integer[]{2, 3});
                this.add(new Integer[]{4, 5});
                this.add(new Integer[]{4, 6});
            }
        });
        DATE_SPLITS.put(8, new ArrayList<Integer[]>(){
            {
                this.add(new Integer[]{2, 4});
                this.add(new Integer[]{4, 6});
            }
        });
    }

    private static class Dmy
    extends Dm {
        final int year;

        public Dmy(int day, int month, int year) {
            super(day, month);
            this.year = year;
        }
    }

    private static class Dm {
        final int day;
        final int month;

        public Dm(int day, int month) {
            this.day = day;
            this.month = month;
        }
    }
}

