/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.catalina.util.RateLimiterBase;
import org.apache.catalina.util.TimeBucketCounterBase;

public class ExactRateLimiter
extends RateLimiterBase {
    @Override
    protected String getDefaultPolicyName() {
        return "exact";
    }

    @Override
    protected TimeBucketCounterBase newCounterInstance(int duration, ScheduledExecutorService executorService) {
        return new ExactTimeBucketCounter(duration, executorService);
    }

    static class ExactTimeBucketCounter
    extends TimeBucketCounterBase {
        ExactTimeBucketCounter(int bucketDuration, ScheduledExecutorService executorService) {
            super(bucketDuration, executorService);
        }

        @Override
        public long getBucketIndex(long timestamp) {
            return timestamp / 1000L / (long)this.getBucketDuration();
        }

        @Override
        public double getRatio() {
            return 1.0;
        }

        @Override
        public long getMillisUntilNextBucket() {
            long millis = System.currentTimeMillis();
            long nextTimeBucketMillis = (this.getBucketIndex(millis) + 1L) * (long)this.getBucketDuration() * 1000L;
            return nextTimeBucketMillis - millis;
        }
    }
}

