/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.Options;

public class DeleteVpcEndpoints
extends BaseCmd {
    public DeleteVpcEndpoints(String[] args) {
        super("ec2delvpce", "ec2-delete-vpc-endpoints");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "VPC_ENDPOINT [, VPC_ENDPOINT]";
    }

    private Options getOptions() {
        return new Options();
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Deletes one or more specified VPC endpoints. Deleting the endpoint also deletes the endpoint routes in the route tables that were associated with the endpoint.");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        String[] vpcEndpointIds = this.getNonOptions();
        RequestResultPair rsp = jec2.deleteVpcEndpoints(vpcEndpointIds);
        out.outputUnsuccessfulItems(System.out, (List)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    protected void validateParameters() {
        this.assertNonOptionSet("VPC_ENDPOINT");
    }

    public static void main(String[] args) {
        new DeleteVpcEndpoints(args).invoke();
    }
}

