/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.ExportTaskDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.Options;

public class DescribeExportTasks
extends BaseCmd {
    public DescribeExportTasks(String[] args) {
        super("ec2dxt", "ec2-describe-export-tasks");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected Options getOptions() {
        return new Options();
    }

    @Override
    protected String getOptionString() {
        return "[EXPORT-TASK [EXPORT-TASK [...]]]";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     List and describe your export tasks.");
        System.out.println("     The EXPORT-TASK parameter list identifies the export task(s)");
        System.out.println("     to describe.");
        System.out.println("     If unspecified, all of your export tasks will be returned.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String[] exportTaskIds = this.getNonOptions();
        RequestResultPair tasks = jec2.describeExportTasks(exportTaskIds);
        List rsp = (List)tasks.getResponse();
        if (rsp == null) {
            return true;
        }
        for (ExportTaskDescription cur : rsp) {
            out.output(System.out, cur, false);
        }
        return true;
    }

    public static void main(String[] args) {
        new DescribeExportTasks(args).invoke();
    }
}

