/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd.util;

import com.amazon.aes.webservices.client.NetworkInterfaceAttachmentRequestDescription;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.util.ParameterUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class LaunchUtil {
    public static List<NetworkInterfaceAttachmentRequestDescription> getNetworkInterfaceAttachments(String[] attachmentDefinitions) {
        ArrayList<NetworkInterfaceAttachmentRequestDescription> attachments = null;
        if (null != attachmentDefinitions && attachmentDefinitions.length > 0) {
            attachments = new ArrayList<NetworkInterfaceAttachmentRequestDescription>();
            for (String attachmentDefinition : attachmentDefinitions) {
                int deviceIndex;
                String[] attachmentDef = attachmentDefinition.split(":");
                if (attachmentDef.length < 2) {
                    throw new InvalidArgument("network-attachment", attachmentDefinition);
                }
                String networkInterfaceId = ParameterUtil.getArgumentIfDefined(attachmentDef, 0);
                try {
                    deviceIndex = Integer.parseInt(attachmentDef[1], 10);
                }
                catch (NumberFormatException e) {
                    throw new InvalidArgument("network-attachment", attachmentDefinition);
                }
                String networkSubnetId = ParameterUtil.getArgumentIfDefined(attachmentDef, 2);
                String description = ParameterUtil.getArgumentIfDefined(attachmentDef, 3);
                String networkPrivateIpAddress = ParameterUtil.getArgumentIfDefined(attachmentDef, 4);
                String networkSecurityGroupIdsStr = ParameterUtil.getArgumentIfDefined(attachmentDef, 5);
                List<String> networkSecurityGroupIds = null;
                if (null != networkSecurityGroupIdsStr) {
                    networkSecurityGroupIds = Arrays.asList(networkSecurityGroupIdsStr.split(","));
                }
                String networkDeleteOnTerminationStr = ParameterUtil.getArgumentIfDefined(attachmentDef, 6);
                Boolean networkDeleteOnTermination = null;
                if (null != networkDeleteOnTerminationStr) {
                    if (!"false".equals(networkDeleteOnTerminationStr = networkDeleteOnTerminationStr.toLowerCase()) && !"true".equals(networkDeleteOnTerminationStr)) {
                        throw new InvalidArgument("network-attachment", attachmentDefinition);
                    }
                    networkDeleteOnTermination = "true".equals(networkDeleteOnTerminationStr);
                }
                String secondaryPrivateIpAddressesCount = ParameterUtil.getArgumentIfDefined(attachmentDef, 7);
                String secondaryPrivateIpAddressesStr = ParameterUtil.getArgumentIfDefined(attachmentDef, 8);
                Integer addressCount = null;
                if (null != secondaryPrivateIpAddressesStr && null != secondaryPrivateIpAddressesCount) {
                    throw new InvalidArgument("network-attachment", attachmentDefinition);
                }
                List<String> secondaryPrivateIpAddresses = null;
                if (null != secondaryPrivateIpAddressesStr) {
                    secondaryPrivateIpAddressesStr = secondaryPrivateIpAddressesStr.toLowerCase();
                    secondaryPrivateIpAddresses = Arrays.asList(secondaryPrivateIpAddressesStr.split(","));
                }
                if (null != secondaryPrivateIpAddressesCount && !"".equals(secondaryPrivateIpAddressesCount)) {
                    addressCount = Integer.parseInt(secondaryPrivateIpAddressesCount);
                }
                NetworkInterfaceAttachmentRequestDescription netDescription = new NetworkInterfaceAttachmentRequestDescription(networkInterfaceId, Integer.valueOf(deviceIndex), networkSubnetId, description, networkPrivateIpAddress, networkSecurityGroupIds, networkDeleteOnTermination, secondaryPrivateIpAddresses, addressCount, null);
                attachments.add(netDescription);
            }
        }
        return attachments;
    }
}

