/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.rrd4j;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.i2p.rrd4j.SimpleSVGMaker;

public class SimpleSVGGraphics2D
extends Graphics2D {
    public static final RenderingHints.Key KEY_SVG_ID = new RHKey(1);
    public static final RenderingHints.Key KEY_SVG_CLASS = new RHKey(2);
    public static final RenderingHints.Key KEY_SVG_TITLE = new RHKey(3);
    public static final RenderingHints.Key KEY_ELEMENT_ID = new RHKey(4);
    public static final RenderingHints.Key KEY_ELEMENT_CLASS = new RHKey(5);
    public static final RenderingHints.Key KEY_ELEMENT_ATTMAP = new RHKey(6);
    public static final RenderingHints.Key KEY_ELEMENT_TITLE = new RHKey(7);
    public static final RenderingHints.Key KEY_ELEMENT_INNERSVG = new RHKey(8);
    private final StringBuilder buf;
    private final SimpleSVGMaker svg;
    private final Map<Object, Object> hints = new HashMap<Object, Object>();
    private AffineTransform transform = new AffineTransform();
    private final FontRenderContext frctx = new FontRenderContext(this.transform, true, true);
    private final int width;
    private final int height;
    private final Rectangle origclip;
    private Rectangle clip;
    private String clipID;
    private Color bgcolor = Color.WHITE;
    private Paint paint = Color.BLACK;
    private Stroke stroke = new BasicStroke(1.0f);
    private Font font = new Font("SansSerif", 0, 12);
    private boolean started;

    public SimpleSVGGraphics2D(int width, int height) {
        this.width = width;
        this.height = height;
        this.origclip = new Rectangle(0, 0, width, height);
        this.buf = new StringBuilder(16384);
        this.svg = new SimpleSVGMaker(this.buf);
    }

    public String getSVG() {
        this.stop();
        String rv = this.buf.toString();
        this.dispose();
        return rv;
    }

    private void start() {
        if (!this.started) {
            String id = (String)this.hints.remove(KEY_SVG_ID);
            String cl = (String)this.hints.remove(KEY_SVG_CLASS);
            this.svg.startSVG(this.width, this.height, this.bgcolor, id, cl);
            this.started = true;
        }
    }

    private void stop() {
        if (this.started) {
            if (!this.transform.isIdentity()) {
                this.svg.endGroup();
                this.transform = this.frctx.getTransform();
            }
            this.svg.endSVG();
            this.clip = null;
            this.clipID = null;
            this.started = false;
        }
    }

    @Override
    public void dispose() {
        this.buf.setLength(0);
    }

    public SimpleSVGMaker getMaker() {
        this.start();
        return this.svg;
    }

    public void append(String s) {
        this.start();
        this.buf.append(s).append('\n');
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.start();
        this.svg.drawLine(x1, y1, x2, y2, (Color)this.paint, (BasicStroke)this.stroke, this.clipID, this.hints);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.start();
        this.svg.drawPolyline(xPoints, yPoints, nPoints, (Color)this.paint, (BasicStroke)this.stroke, this.clipID, this.hints);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.start();
        String id = (String)this.hints.remove(KEY_ELEMENT_ID);
        String cl = (String)this.hints.remove(KEY_ELEMENT_CLASS);
        this.svg.fillPolygon(xPoints, yPoints, nPoints, (Color)this.paint, this.clipID, this.hints);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        if (!this.started) {
            if (x == 0 && y == 0 && width == this.width && height == this.height) {
                this.bgcolor = null;
            }
            this.start();
        }
        this.svg.drawRect(x, y, width, height, null, (Color)this.paint, null, this.clipID, this.hints);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.start();
        this.svg.drawText(str, x, y, (Color)this.paint, this.font, this.clipID, this.hints);
    }

    @Override
    public void drawString(String str, float x, float y) {
        this.drawString(str, (int)x, (int)y);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.frctx;
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (width != height || arcAngle != 360) {
            throw new UnsupportedOperationException("circles only!");
        }
        this.start();
        int r = width / 2;
        this.svg.drawCircle(x + r, y + r, r, (Color)this.paint, null, (BasicStroke)this.stroke, this.clipID, this.hints);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (width != height || arcAngle != 360) {
            throw new UnsupportedOperationException("circles only!");
        }
        this.start();
        int r = width / 2;
        this.svg.drawCircle(x + r, y + r, r, null, (Color)this.paint, (BasicStroke)this.stroke, this.clipID, this.hints);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        boolean wasStarted = this.started;
        if (!wasStarted) {
            this.start();
        } else {
            String id = (String)this.hints.remove(KEY_ELEMENT_ID);
            String cl = (String)this.hints.remove(KEY_ELEMENT_CLASS);
            this.svg.drawRect(x, y, width, height, null, this.bgcolor, null, this.clipID, this.hints);
        }
    }

    @Override
    public void draw(Shape s) {
        this.drawOrFill(s, true, false);
    }

    @Override
    public void fill(Shape s) {
        this.drawOrFill(s, false, true);
    }

    private void drawOrFill(Shape s, boolean draw, boolean fill) {
        int[] x = new int[16];
        int[] y = new int[16];
        int i = 0;
        float[] coords = new float[6];
        PathIterator it = s.getPathIterator(this.frctx.getTransform());
        while (!it.isDone()) {
            int type = it.currentSegment(coords);
            switch (type) {
                case 0: 
                case 1: {
                    if (i >= x.length) {
                        x = Arrays.copyOf(x, x.length * 2);
                        y = Arrays.copyOf(y, y.length * 2);
                    }
                    x[i] = (int)coords[0];
                    y[i++] = (int)coords[1];
                    break;
                }
                case 4: {
                    break;
                }
                case 2: 
                case 3: {
                    throw new UnsupportedOperationException("Unsupported curved shape");
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported type " + type);
                }
            }
            it.next();
        }
        if (draw) {
            this.drawPolyline(x, y, i);
        } else {
            this.fillPolygon(x, y, i);
        }
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle(x, y, width, height));
    }

    @Override
    public void setClip(Shape clip) {
        if (clip.equals(this.clip)) {
            return;
        }
        if (this.clip == null && clip.equals(this.origclip)) {
            return;
        }
        Rectangle newclip = clip instanceof Rectangle ? (Rectangle)clip : clip.getBounds();
        if (clip.equals(this.origclip)) {
            this.clip = null;
            this.clipID = null;
            return;
        }
        this.clipID = this.svg.defineClipPath(newclip);
        this.clip = newclip;
    }

    @Override
    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    @Override
    public void translate(double tx, double ty) {
        AffineTransform ntx = (AffineTransform)this.transform.clone();
        ntx.translate(tx, ty);
        this.setTransform(ntx);
    }

    @Override
    public void rotate(double theta) {
        AffineTransform ntx = (AffineTransform)this.transform.clone();
        ntx.rotate(theta);
        this.setTransform(ntx);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        AffineTransform ntx = (AffineTransform)this.transform.clone();
        ntx.rotate(theta, x, y);
        this.setTransform(ntx);
    }

    @Override
    public void scale(double sx, double sy) {
        AffineTransform ntx = (AffineTransform)this.transform.clone();
        ntx.scale(sx, sy);
        this.setTransform(ntx);
    }

    @Override
    public void shear(double shx, double shy) {
        AffineTransform ntx = (AffineTransform)this.transform.clone();
        ntx.shear(shx, shy);
        this.setTransform(ntx);
    }

    @Override
    public void setTransform(AffineTransform tx) {
        if (this.transform.equals(tx)) {
            return;
        }
        if (!this.transform.isIdentity()) {
            this.svg.endGroup();
        }
        if (!tx.isIdentity()) {
            String matrix = String.format(Locale.US, "matrix(%.3f %.3f %.3f %.3f %.3f %.3f)", tx.getScaleX(), tx.getShearY(), tx.getShearX(), tx.getScaleY(), tx.getTranslateX(), tx.getTranslateY());
            this.svg.startGroup(null, null, "transform", matrix);
        }
        this.transform = tx;
    }

    @Override
    public AffineTransform getTransform() {
        return this.transform;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    @Override
    public void setBackground(Color color) {
        this.bgcolor = color;
    }

    @Override
    public Color getBackground() {
        return this.bgcolor;
    }

    @Override
    public Shape getClip() {
        return this.clip;
    }

    @Override
    public Rectangle getClipBounds() {
        return this.clip;
    }

    @Override
    public void setColor(Color color) {
        this.paint = color;
    }

    @Override
    public Color getColor() {
        return (Color)this.paint;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.hints.putAll(hints);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.hints.get(hintKey);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.hints.put(hintKey, hintValue);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.hints.clear();
        this.addRenderingHints(hints);
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clip(Shape s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Graphics create() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver obs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver obs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver obs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver obs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver obs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver obs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        throw new UnsupportedOperationException();
    }

    public void fillPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Composite getComposite() {
        return null;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return null;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return false;
    }

    @Override
    public void setComposite(Composite comp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color color) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void transform(AffineTransform tx) {
    }

    private static class RHKey
    extends RenderingHints.Key {
        public RHKey(int k) {
            super(k);
        }

        @Override
        public boolean isCompatibleValue(Object o) {
            if (this.intKey() == 6) {
                return o instanceof Map;
            }
            return o instanceof String;
        }
    }
}

