/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.m40.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.api.model.Model;
import org.apache.maven.internal.impl.resolver.MavenWorkspaceReader;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.model.MavenWorkspaceMapWrapper;

public class Maven40WorkspaceMapReader
implements WorkspaceReader,
MavenWorkspaceReader {
    private final WorkspaceRepository myRepository = new WorkspaceRepository();
    private final MavenWorkspaceMapWrapper myWorkspaceMap;
    private final ConcurrentHashMap<MavenId, Model> myMavenModelMap;

    public Maven40WorkspaceMapReader(MavenWorkspaceMap workspaceMap) {
        this.myWorkspaceMap = new MavenWorkspaceMapWrapper(workspaceMap);
        this.myMavenModelMap = new ConcurrentHashMap();
    }

    public WorkspaceRepository getRepository() {
        return this.myRepository;
    }

    public File findArtifact(Artifact artifact) {
        MavenWorkspaceMap.Data resolved = this.myWorkspaceMap.findFileAndOriginalId(new MavenId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
        if (resolved == null) {
            return null;
        }
        return resolved.getFile(artifact.getExtension());
    }

    public List<String> findVersions(Artifact artifact) {
        ArrayList<String> res = new ArrayList<String>();
        Set ids = this.myWorkspaceMap.getAvailableIdsForArtifactId(artifact.getArtifactId());
        for (MavenId id : ids) {
            String version;
            if (!Objects.equals(id.getGroupId(), artifact.getGroupId()) || (version = id.getVersion()) == null) continue;
            res.add(version);
        }
        return res;
    }

    public Model findModel(Artifact artifact) {
        return this.myMavenModelMap.get(new MavenId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
    }

    void setCacheModelMap(Map<MavenId, Model> map) {
        this.myMavenModelMap.clear();
        this.myMavenModelMap.putAll(map);
    }
}

