/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.swagger;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\b\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0012\u0010\u000e\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\u0012\u0010\u0010\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\u0012\u0010\u0011\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u001a\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"OPENAPI_PLUGIN_ID", "", "OPENAPI_PLUGIN_NAME", "OPENAPI_FILES", "OPENAPI_SUGGESTION_DISMISSED_KEY", "dismissPluginSuggestion", "", "isPluginSuggestionDismissed", "", "detectOpenApiSpecification", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isOpenApiYaml", "Lcom/intellij/psi/PsiFile;", "computeOpenApiYaml", "isOpenApiDocument", "document", "Lorg/jetbrains/yaml/psi/YAMLDocument;", "getKeyValueByKeyIgnoreSpaces", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "Lorg/jetbrains/yaml/psi/YAMLMapping;", "keyText", "intellij.yaml"})
@SourceDebugExtension(value={"SMAP\nOpenApiSuggestionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenApiSuggestionProvider.kt\norg/jetbrains/yaml/swagger/OpenApiSuggestionProviderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n295#2,2:125\n*S KotlinDebug\n*F\n+ 1 OpenApiSuggestionProvider.kt\norg/jetbrains/yaml/swagger/OpenApiSuggestionProviderKt\n*L\n123#1:125,2\n*E\n"})
public final class OpenApiSuggestionProviderKt {
    @NotNull
    private static final String OPENAPI_PLUGIN_ID = "com.intellij.swagger";
    @NotNull
    private static final String OPENAPI_PLUGIN_NAME = "OpenAPI Specifications";
    @NotNull
    private static final String OPENAPI_FILES = "OpenAPI";
    @NotNull
    private static final String OPENAPI_SUGGESTION_DISMISSED_KEY = "swagger.suggestion.dismissed";

    private static final void dismissPluginSuggestion() {
        PropertiesComponent.getInstance().setValue(OPENAPI_SUGGESTION_DISMISSED_KEY, true);
    }

    private static final boolean isPluginSuggestionDismissed() {
        return PropertiesComponent.getInstance().isTrueValue(OPENAPI_SUGGESTION_DISMISSED_KEY);
    }

    private static final boolean detectOpenApiSpecification(Project project, VirtualFile file) {
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        return OpenApiSuggestionProviderKt.isOpenApiYaml(psiFile);
    }

    private static final boolean isOpenApiYaml(PsiFile file) {
        if (!(file instanceof YAMLFile)) {
            return false;
        }
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file), () -> OpenApiSuggestionProviderKt.isOpenApiYaml$lambda$0(file));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Boolean)object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean computeOpenApiYaml(PsiFile file) {
        if (!(file instanceof YAMLFile)) return false;
        List list = ((YAMLFile)file).getDocuments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDocuments(...)");
        if (!OpenApiSuggestionProviderKt.isOpenApiDocument((YAMLDocument)CollectionsKt.firstOrNull((List)list))) return false;
        return true;
    }

    private static final boolean isOpenApiDocument(YAMLDocument document) {
        YAMLDocument yAMLDocument = document;
        YAMLValue yAMLValue = yAMLDocument != null ? yAMLDocument.getTopLevelValue() : null;
        YAMLMapping yAMLMapping = yAMLValue instanceof YAMLMapping ? (YAMLMapping)yAMLValue : null;
        if (yAMLMapping == null) {
            return false;
        }
        YAMLMapping topMapping = yAMLMapping;
        return OpenApiSuggestionProviderKt.getKeyValueByKeyIgnoreSpaces(topMapping, "openapi") != null || OpenApiSuggestionProviderKt.getKeyValueByKeyIgnoreSpaces(topMapping, "swagger") != null;
    }

    private static final YAMLKeyValue getKeyValueByKeyIgnoreSpaces(YAMLMapping $this$getKeyValueByKeyIgnoreSpaces, String keyText) {
        Object v2;
        block1: {
            Collection collection = $this$getKeyValueByKeyIgnoreSpaces.getKeyValues();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getKeyValues(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                YAMLKeyValue it = (YAMLKeyValue)element$iv;
                boolean bl = false;
                String string = it.getKeyText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKeyText(...)");
                if (!(keyText.compareTo(((Object)StringsKt.trim((CharSequence)string)).toString()) == 0)) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    private static final CachedValueProvider.Result isOpenApiYaml$lambda$0(PsiFile $file) {
        Object[] objectArray = new Object[]{$file};
        return new CachedValueProvider.Result((Object)OpenApiSuggestionProviderKt.computeOpenApiYaml($file), objectArray);
    }

    public static final /* synthetic */ boolean access$isPluginSuggestionDismissed() {
        return OpenApiSuggestionProviderKt.isPluginSuggestionDismissed();
    }

    public static final /* synthetic */ boolean access$detectOpenApiSpecification(Project project, VirtualFile file) {
        return OpenApiSuggestionProviderKt.detectOpenApiSpecification(project, file);
    }

    public static final /* synthetic */ void access$dismissPluginSuggestion() {
        OpenApiSuggestionProviderKt.dismissPluginSuggestion();
    }
}

