/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineScopeResolver;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.InterfaceLowering;
import org.jetbrains.kotlin.backend.jvm.lower.ObjectClassLowering;
import org.jetbrains.kotlin.backend.jvm.lower.StaticDefaultFunctionLowering;
import org.jetbrains.kotlin.backend.jvm.lower.SyntheticAccessorLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.SyntheticAccessorTransformer;
import org.jetbrains.kotlin.backend.jvm.lower.ToArrayLoweringKt;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@PhaseDescription(name="SyntheticAccessor", prerequisite={ObjectClassLowering.class, StaticDefaultFunctionLowering.class, InterfaceLowering.class})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/SyntheticAccessorLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Companion", "backend.jvm.lower"})
public final class SyntheticAccessorLowering
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JvmBackendContext context;

    public SyntheticAccessorLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Set pendingAccessorsToAdd = new LinkedHashSet();
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irFile), (IrElementTransformerVoid)((IrElementTransformerVoid)new SyntheticAccessorTransformer(this.context, irFile, pendingAccessorsToAdd)));
        for (IrFunction accessor : pendingAccessorsToAdd) {
            IrDeclarationParent irDeclarationParent = accessor.getParent();
            Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer");
            ((IrDeclarationContainer)irDeclarationParent).getDeclarations().add(accessor);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0005\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/SyntheticAccessorLowering$Companion;", "", "<init>", "()V", "isAccessible", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "currentScope", "Lorg/jetbrains/kotlin/backend/common/ScopeWithIr;", "inlineScopeResolver", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;", "withSuper", "thisObjReference", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "fromOtherClassLoader", "backend.jvm.lower"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isAccessible(@NotNull IrSymbol $this$isAccessible, @NotNull JvmBackendContext context, @Nullable ScopeWithIr currentScope, @NotNull IrInlineScopeResolver inlineScopeResolver, boolean withSuper, @Nullable IrClassSymbol thisObjReference, boolean fromOtherClassLoader) {
            IrDeclarationWithVisibility irDeclarationWithVisibility;
            Integer jvmVisibility;
            Intrinsics.checkNotNullParameter((Object)$this$isAccessible, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)inlineScopeResolver, (String)"inlineScopeResolver");
            IrSymbolOwner irSymbolOwner = $this$isAccessible.getOwner();
            Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility");
            IrDeclarationWithVisibility declarationRaw = (IrDeclarationWithVisibility)irSymbolOwner;
            if (declarationRaw instanceof IrConstructor && IrUtilsKt.isEnumEntry((IrClass)AdditionalIrUtilsKt.getConstructedClass((IrConstructor)((IrConstructor)declarationRaw)))) {
                return true;
            }
            Integer n = jvmVisibility = AsmUtil.getVisibilityAccessFlag(declarationRaw.getVisibility().getDelegate());
            int n2 = 1;
            if (n != null && n == n2 && !withSuper) {
                return true;
            }
            if (declarationRaw instanceof IrSimpleFunction && (ToArrayLoweringKt.isNonGenericToArray((IrSimpleFunction)declarationRaw) || ToArrayLoweringKt.isGenericToArray((IrSimpleFunction)declarationRaw, context)) && ToArrayLoweringKt.isCollectionSubClass(IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)declarationRaw)))) {
                return true;
            }
            if (declarationRaw instanceof IrField && JvmIrUtilsKt.isAssertionsDisabledField((IrField)declarationRaw, context)) {
                return true;
            }
            if (declarationRaw instanceof IrFunction) {
                if (((IrFunction)declarationRaw).isInline()) return true;
                if (context.getGetIntrinsic().invoke((Object)((IrFunction)declarationRaw).getSymbol()) != null) {
                    return true;
                }
            }
            IrDeclarationWithVisibility declaration = (irDeclarationWithVisibility = declarationRaw) instanceof IrSimpleFunction ? (IrDeclarationWithVisibility)IrFakeOverrideUtilsKt.resolveFakeOverrideMaybeAbstractOrFail((IrOverridableDeclaration)((IrOverridableDeclaration)declarationRaw)) : (irDeclarationWithVisibility instanceof IrField ? (IrDeclarationWithVisibility)SyntheticAccessorLoweringKt.access$resolveFieldFakeOverride((IrField)declarationRaw) : declarationRaw);
            IrDeclarationParent irDeclarationParent = declaration.getParent();
            if (!(irDeclarationParent instanceof IrClass)) return true;
            IrClass irClass = (IrClass)irDeclarationParent;
            if (irClass == null) {
                return true;
            }
            IrClass ownerClass = irClass;
            ScopeWithIr scopeWithIr = currentScope;
            Intrinsics.checkNotNull((Object)scopeWithIr);
            IrDeclarationContainer irDeclarationContainer = inlineScopeResolver.findContainer(scopeWithIr.getIrElement());
            if (irDeclarationContainer == null) {
                return false;
            }
            IrDeclarationContainer scopeClassOrPackage = irDeclarationContainer;
            IrPackageFragment irPackageFragment = IrUtilsKt.getPackageFragment((IrElement)((IrElement)scopeClassOrPackage));
            boolean samePackage = Intrinsics.areEqual((Object)IrUtilsKt.getPackageFragment((IrDeclaration)((IrDeclaration)ownerClass)).getPackageFqName(), (Object)(irPackageFragment != null ? irPackageFragment.getPackageFqName() : null));
            Integer n3 = jvmVisibility;
            int n4 = 2;
            if (n3 == null || n3 != n4) {
                if (!withSuper && samePackage) {
                    Integer n5 = jvmVisibility;
                    if (n5 != null && n5 == 0) {
                        return true;
                    }
                }
                if (!withSuper && samePackage && !fromOtherClassLoader) {
                    return true;
                }
                if (!(scopeClassOrPackage instanceof IrClass)) return false;
                if (!IrUtilsKt.isSubclassOf((IrClass)((IrClass)scopeClassOrPackage), (IrClass)ownerClass)) return false;
                if (thisObjReference == null) return true;
                if (!IrUtilsKt.isSubclassOf((IrClass)((IrClass)thisObjReference.getOwner()), (IrClass)((IrClass)scopeClassOrPackage))) return false;
                return true;
            }
            boolean bl = Intrinsics.areEqual((Object)ownerClass, (Object)scopeClassOrPackage);
            return bl;
        }

        public static /* synthetic */ boolean isAccessible$default(Companion companion, IrSymbol irSymbol, JvmBackendContext jvmBackendContext, ScopeWithIr scopeWithIr, IrInlineScopeResolver irInlineScopeResolver, boolean bl, IrClassSymbol irClassSymbol, boolean bl2, int n, Object object) {
            if ((n & 0x20) != 0) {
                bl2 = false;
            }
            return companion.isAccessible(irSymbol, jvmBackendContext, scopeWithIr, irInlineScopeResolver, bl, irClassSymbol, bl2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

