/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.coroutine;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.metadata.CoroutineMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.coroutine.CoroutineBlock;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0018\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001d\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u001c\u001a\u0004\b\u001e\u0010\u001aR\u001b\u0010 \u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u001c\u001a\u0004\b!\u0010\u001a\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/js/coroutine/CoroutineTransformationContext;", "", "scope", "Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsScope;Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;)V", "localVariableNameCache", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "usedLocalVariableIds", "", "", "entryBlock", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineBlock;", "getEntryBlock", "()Lorg/jetbrains/kotlin/js/coroutine/CoroutineBlock;", "globalCatchBlock", "getGlobalCatchBlock", "metadata", "Lorg/jetbrains/kotlin/js/backend/ast/metadata/CoroutineMetadata;", "getMetadata", "()Lorg/jetbrains/kotlin/js/backend/ast/metadata/CoroutineMetadata;", "controllerFieldName", "getControllerFieldName", "()Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "controllerFieldName$delegate", "Lkotlin/Lazy;", "returnValueFieldName", "getReturnValueFieldName", "returnValueFieldName$delegate", "receiverFieldName", "getReceiverFieldName", "receiverFieldName$delegate", "getFieldName", "variableName", "js.translator"})
@SourceDebugExtension(value={"SMAP\nCoroutineTransformationContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineTransformationContext.kt\norg/jetbrains/kotlin/js/coroutine/CoroutineTransformationContext\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,44:1\n381#2,7:45\n*S KotlinDebug\n*F\n+ 1 CoroutineTransformationContext.kt\norg/jetbrains/kotlin/js/coroutine/CoroutineTransformationContext\n*L\n35#1:45,7\n*E\n"})
public final class CoroutineTransformationContext {
    @NotNull
    private final JsScope scope;
    @NotNull
    private final Map<JsName, JsName> localVariableNameCache;
    @NotNull
    private final Set<String> usedLocalVariableIds;
    @NotNull
    private final CoroutineBlock entryBlock;
    @NotNull
    private final CoroutineBlock globalCatchBlock;
    @NotNull
    private final CoroutineMetadata metadata;
    @NotNull
    private final Lazy controllerFieldName$delegate;
    @NotNull
    private final Lazy returnValueFieldName$delegate;
    @NotNull
    private final Lazy receiverFieldName$delegate;

    public CoroutineTransformationContext(@NotNull JsScope scope, @NotNull JsFunction function2) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        this.scope = scope;
        this.localVariableNameCache = new LinkedHashMap();
        this.usedLocalVariableIds = new LinkedHashSet();
        this.entryBlock = new CoroutineBlock();
        this.globalCatchBlock = new CoroutineBlock();
        CoroutineMetadata coroutineMetadata = MetadataProperties.getCoroutineMetadata(function2);
        Intrinsics.checkNotNull((Object)coroutineMetadata);
        this.metadata = coroutineMetadata;
        this.controllerFieldName$delegate = LazyKt.lazy(() -> CoroutineTransformationContext.controllerFieldName_delegate$lambda$0(this));
        this.returnValueFieldName$delegate = LazyKt.lazy(() -> CoroutineTransformationContext.returnValueFieldName_delegate$lambda$1(this));
        this.receiverFieldName$delegate = LazyKt.lazy(() -> CoroutineTransformationContext.receiverFieldName_delegate$lambda$2(this));
    }

    @NotNull
    public final CoroutineBlock getEntryBlock() {
        return this.entryBlock;
    }

    @NotNull
    public final CoroutineBlock getGlobalCatchBlock() {
        return this.globalCatchBlock;
    }

    @NotNull
    public final CoroutineMetadata getMetadata() {
        return this.metadata;
    }

    @NotNull
    public final JsName getControllerFieldName() {
        Lazy lazy = this.controllerFieldName$delegate;
        return (JsName)lazy.getValue();
    }

    @NotNull
    public final JsName getReturnValueFieldName() {
        Lazy lazy = this.returnValueFieldName$delegate;
        return (JsName)lazy.getValue();
    }

    @NotNull
    public final JsName getReceiverFieldName() {
        Lazy lazy = this.receiverFieldName$delegate;
        return (JsName)lazy.getValue();
    }

    @NotNull
    public final JsName getFieldName(@NotNull JsName variableName) {
        JsName jsName;
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        Map<JsName, JsName> $this$getOrPut$iv = this.localVariableNameCache;
        boolean $i$f$getOrPut = false;
        JsName value$iv = $this$getOrPut$iv.get(variableName);
        if (value$iv == null) {
            String baseId;
            boolean bl = false;
            String suggestedId = baseId = "local$" + variableName.getIdent();
            int suffix = 0;
            while (!this.usedLocalVariableIds.add(suggestedId)) {
                suggestedId = baseId + '_' + suffix++;
            }
            JsName jsName2 = this.scope.declareName(suggestedId);
            Intrinsics.checkNotNullExpressionValue((Object)jsName2, (String)"declareName(...)");
            JsName answer$iv = jsName2;
            $this$getOrPut$iv.put(variableName, answer$iv);
            jsName = answer$iv;
        } else {
            jsName = value$iv;
        }
        return jsName;
    }

    private static final JsName controllerFieldName_delegate$lambda$0(CoroutineTransformationContext this$0) {
        return this$0.scope.declareName("$controller");
    }

    private static final JsName returnValueFieldName_delegate$lambda$1(CoroutineTransformationContext this$0) {
        return this$0.scope.declareName("$returnValue");
    }

    private static final JsName receiverFieldName_delegate$lambda$2(CoroutineTransformationContext this$0) {
        return this$0.scope.declareName("$this");
    }
}

