/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin.analysis;

import androidx.compose.compiler.plugins.kotlin.analysis.FqNameMatcher;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\nJ\u0010\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/compose/compiler/plugins/kotlin/analysis/MutableMatcherTree;", "", "<init>", "()V", "root", "Landroidx/compose/compiler/plugins/kotlin/analysis/MutableMatcherTree$Node;", "putAll", "", "matchers", "", "Landroidx/compose/compiler/plugins/kotlin/analysis/FqNameMatcher;", "put", "matcher", "findFirstPositiveMatcher", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "Node", "compiler-hosted"})
@SourceDebugExtension(value={"SMAP\nStabilityExternalClassNameMatching.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StabilityExternalClassNameMatching.kt\nandroidx/compose/compiler/plugins/kotlin/analysis/MutableMatcherTree\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,237:1\n1863#2,2:238\n381#3,7:240\n*S KotlinDebug\n*F\n+ 1 StabilityExternalClassNameMatching.kt\nandroidx/compose/compiler/plugins/kotlin/analysis/MutableMatcherTree\n*L\n78#1:238,2\n85#1:240,7\n*E\n"})
final class MutableMatcherTree {
    @NotNull
    private final Node root = new Node();

    public final void putAll(@NotNull Iterable<FqNameMatcher> matchers) {
        Intrinsics.checkNotNullParameter(matchers, (String)"matchers");
        Iterable<FqNameMatcher> $this$forEach$iv = matchers;
        boolean $i$f$forEach = false;
        Iterator<FqNameMatcher> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            FqNameMatcher element$iv;
            FqNameMatcher it = element$iv = iterator.next();
            boolean bl = false;
            this.put(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void put(@NotNull FqNameMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Node node = this.root;
        String string = matcher.getKey();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            Object object;
            void $this$getOrPut$iv;
            char c = string.charAt(i);
            Map<Character, Node> map = node.getChildren();
            Character key$iv = Character.valueOf(c);
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Node answer$iv = new Node();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            node = (Node)object;
        }
        node.getValues().add(matcher);
    }

    @Nullable
    public final FqNameMatcher findFirstPositiveMatcher(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        String segments = fqName.asString();
        int currSegmentIndex = 0;
        Node currNode = this.root;
        while (currNode != null) {
            Character segment = StringsKt.getOrNull((CharSequence)segments, (int)currSegmentIndex);
            int n = currNode.getValues().size();
            for (int i = 0; i < n; ++i) {
                FqNameMatcher matcher = currNode.getValues().get(i);
                if (!matcher.matches(fqName)) continue;
                return matcher;
            }
            if (segment != null) {
                currNode = currNode.getChildren().get(segment);
                ++currSegmentIndex;
                continue;
            }
            currNode = null;
        }
        return null;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Landroidx/compose/compiler/plugins/kotlin/analysis/MutableMatcherTree$Node;", "", "<init>", "()V", "children", "", "", "getChildren", "()Ljava/util/Map;", "values", "", "Landroidx/compose/compiler/plugins/kotlin/analysis/FqNameMatcher;", "getValues", "()Ljava/util/List;", "compiler-hosted"})
    private static final class Node {
        @NotNull
        private final Map<Character, Node> children = new LinkedHashMap();
        @NotNull
        private final List<FqNameMatcher> values = new ArrayList();

        @NotNull
        public final Map<Character, Node> getChildren() {
            return this.children;
        }

        @NotNull
        public final List<FqNameMatcher> getValues() {
            return this.values;
        }
    }
}

