/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.editorActions.CodeDocumentationUtil;
import com.intellij.codeInsight.javadoc.JavaDocExternalFilter;
import com.intellij.codeInsight.javadoc.JavaDocHighlightingManager;
import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.codeInsight.javadoc.JavaDocInfoGeneratorFactory;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.java.JavaBundle;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.documentation.CodeDocumentationProvider;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.DocumentationSettings;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.lang.documentation.QuickDocHighlightingHelper;
import com.intellij.lang.java.JavaDocumentationProvider;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.richcopy.HtmlSyntaxInfoUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.dsl.GdslNamedParameter;
import org.jetbrains.plugins.groovy.dsl.holders.NonCodeMembersHolder;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.completion.GrPropertyForCompletion;
import org.jetbrains.plugins.groovy.lang.documentation.GroovyDocHighlightingManager;
import org.jetbrains.plugins.groovy.lang.documentation.GroovyDocInfoGenerator;
import org.jetbrains.plugins.groovy.lang.documentation.GroovyPresentationUtil;
import org.jetbrains.plugins.groovy.lang.documentation.TypePresentation;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTraitType;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrImplicitVariable;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMapProperty;

public final class GroovyDocumentationProvider
implements CodeDocumentationProvider,
ExternalDocumentationProvider {
    private static final String LINE_SEPARATOR = "\n";
    @NonNls
    private static final String RETURN_TAG = "@return";
    @NonNls
    private static final String THROWS_TAG = "@throws";
    private static final String BODY_HTML = "</body></html>";

    private static void appendStyledSpan(@NotNull StringBuilder buffer, @Nullable String value, String ... properties) {
        if (buffer == null) {
            GroovyDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (properties == null) {
            GroovyDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (DocumentationSettings.isHighlightingOfQuickDocSignaturesEnabled()) {
            HtmlSyntaxInfoUtil.appendStyledSpan((StringBuilder)buffer, (String)value, (String[])properties);
        } else {
            buffer.append(value);
        }
    }

    private static PsiSubstitutor calcSubstitutor(PsiElement originalElement) {
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        if (originalElement instanceof GrReferenceExpression) {
            substitutor = ((GrReferenceExpression)originalElement).advancedResolve().getSubstitutor();
        }
        return substitutor;
    }

    @Nullable
    @Nls
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element instanceof GrVariable || element instanceof GrImplicitVariable) {
            @Nls StringBuilder buffer = new StringBuilder();
            PsiVariable variable = (PsiVariable)element;
            if (originalElement instanceof GrVariableDeclaration && ((GrVariableDeclaration)originalElement).getVariables().length > 1) {
                for (GrVariable var : ((GrVariableDeclaration)originalElement).getVariables()) {
                    GroovyDocumentationProvider.generateVariableInfo(originalElement, buffer, var);
                    buffer.append("\n\n");
                }
            } else {
                GroovyDocumentationProvider.generateVariableInfo(originalElement, buffer, variable);
            }
            return buffer.toString();
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            @Nls StringBuilder buffer = new StringBuilder();
            if (method instanceof GrGdkMethod) {
                GroovyDocumentationProvider.appendStyledSpan(buffer, "[" + GroovyBundle.message("documentation.gdk.label", new Object[0]) + "]", "color: #909090");
            } else {
                String qName;
                PsiClass hisClass = method.getContainingClass();
                if (hisClass != null && (qName = hisClass.getQualifiedName()) != null) {
                    QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)qName, (TextAttributes)GroovyDocHighlightingManager.getInstance().getClassDeclarationAttributes(hisClass));
                    buffer.append(LINE_SEPARATOR);
                }
            }
            PsiSubstitutor substitutor = GroovyDocumentationProvider.calcSubstitutor(originalElement);
            if (!method.isConstructor()) {
                PsiType substituted = substitutor.substitute(PsiUtil.getSmartReturnType(method));
                GroovyDocumentationProvider.appendTypeString(buffer, substituted, originalElement, false);
                buffer.append(" ");
            }
            QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)method.getName(), (TextAttributes)GroovyDocHighlightingManager.getInstance().getMethodDeclarationAttributes(method));
            QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)"(", (TextAttributes)GroovyDocHighlightingManager.getInstance().getParenthesesAttributes());
            PsiParameter[] parameters = method.getParameterList().getParameters();
            for (int i2 = 0; i2 < parameters.length; ++i2) {
                PsiParameter parameter = parameters[i2];
                if (i2 > 0) {
                    QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)", ", (TextAttributes)GroovyDocHighlightingManager.getInstance().getCommaAttributes());
                }
                if (parameter instanceof GrParameter) {
                    GroovyPresentationUtil.appendParameterPresentation((GrParameter)parameter, substitutor, TypePresentation.LINK, buffer, DocumentationSettings.isHighlightingOfQuickDocSignaturesEnabled());
                    continue;
                }
                PsiType type = parameter.getType();
                GroovyDocumentationProvider.appendTypeString(buffer, substitutor.substitute(type), originalElement, false);
                buffer.append(" ");
                QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)parameter.getName(), (TextAttributes)GroovyDocHighlightingManager.getInstance().getParameterAttributes());
            }
            QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)")", (TextAttributes)GroovyDocHighlightingManager.getInstance().getParenthesesAttributes());
            PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
            if (referencedTypes.length > 0) {
                QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)"\nthrows ", (TextAttributes)GroovyDocHighlightingManager.getInstance().getKeywordAttributes());
                for (int i3 = 0; i3 < referencedTypes.length; ++i3) {
                    PsiClassType referencedType = referencedTypes[i3];
                    GroovyDocumentationProvider.appendTypeString(buffer, (PsiType)referencedType, originalElement, false);
                    if (i3 == referencedTypes.length - 1) continue;
                    QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)", ", (TextAttributes)GroovyDocHighlightingManager.getInstance().getCommaAttributes());
                }
            }
            return buffer.toString();
        }
        if (element instanceof GrTypeDefinition) {
            return GroovyDocumentationProvider.generateClassInfo((GrTypeDefinition)element);
        }
        if (element instanceof GroovyMapProperty) {
            GroovyMapProperty mapProperty = (GroovyMapProperty)element;
            @Nls StringBuilder buffer = new StringBuilder();
            GroovyDocumentationProvider.appendStyledSpan(buffer, "Map property\n", new String[0]);
            PsiType inferredType = mapProperty.getPropertyType();
            String typeLabel = inferredType != null ? GroovyBundle.message("documentation.inferred.type.label", new Object[0]) : GroovyBundle.message("documentation.cannot.infer.type.label", new Object[0]);
            GroovyDocumentationProvider.appendStyledSpan(buffer, "[" + typeLabel + "]", "color: #909090");
            if (inferredType != null) {
                buffer.append(" ");
                GroovyDocumentationProvider.appendTypeString(buffer, inferredType, originalElement, false);
            }
            buffer.append(" ");
            QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)mapProperty.getName(), (TextAttributes)GroovyDocHighlightingManager.getInstance().getClassNameAttributes());
            return buffer.toString();
        }
        return null;
    }

    private static void generateVariableInfo(PsiElement originalElement, @Nls StringBuilder buffer, PsiVariable variable) {
        if (variable instanceof PsiField) {
            PsiClass parentClass = ((PsiField)variable).getContainingClass();
            if (parentClass != null) {
                GroovyDocumentationProvider.appendElementLink(buffer, (PsiElement)parentClass, JavaDocUtil.getShortestClassName((PsiClass)parentClass, (PsiElement)variable));
                GroovyDocumentationProvider.newLine(buffer);
            }
            GroovyDocumentationProvider.generateModifiers(buffer, (PsiModifierListOwner)variable);
        }
        PsiType type = variable instanceof GrVariable ? ((GrVariable)variable).getDeclaredType() : variable.getType();
        GroovyDocumentationProvider.appendTypeString(buffer, GroovyDocumentationProvider.calcSubstitutor(originalElement).substitute(type), originalElement, false);
        buffer.append(" ");
        TextAttributes varAttributes = variable instanceof PsiField ? GroovyDocHighlightingManager.getInstance().getFieldDeclarationAttributes((PsiField)variable) : GroovyDocHighlightingManager.getInstance().getLocalVariableAttributes();
        QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)variable.getName(), (TextAttributes)varAttributes);
        if (variable instanceof GrVariable) {
            PsiReference ref2;
            GroovyDocumentationProvider.newLine(buffer);
            while (originalElement != null && ((ref2 = originalElement.getReference()) == null || ref2.resolve() == null)) {
                originalElement = originalElement.getParent();
            }
            if (originalElement != null) {
                GroovyDocumentationProvider.appendInferredType(originalElement, (GrVariable)variable, buffer, false);
            }
        }
    }

    private static void appendInferredType(PsiElement originalElement, GrVariable variable, @Nls StringBuilder buffer, boolean isRendered) {
        PsiType inferredType = null;
        if (PsiImplUtil.isWhiteSpaceOrNls(originalElement)) {
            originalElement = PsiTreeUtil.prevLeaf((PsiElement)originalElement);
        }
        if (originalElement != null && originalElement.getNode().getElementType() == GroovyTokenTypes.mIDENT) {
            originalElement = originalElement.getParent();
        }
        if (originalElement instanceof GrReferenceExpression) {
            inferredType = ((GrReferenceExpression)originalElement).getType();
        } else if (originalElement instanceof GrVariableDeclaration) {
            inferredType = variable.getTypeGroovy();
        } else if (originalElement instanceof GrVariable) {
            inferredType = ((GrVariable)originalElement).getTypeGroovy();
        }
        String typeLabel = inferredType != null ? GroovyBundle.message("documentation.inferred.type.label", new Object[0]) : GroovyBundle.message("documentation.cannot.infer.type.label", new Object[0]);
        GroovyDocumentationProvider.appendStyledSpan(buffer, "[" + typeLabel + "]", "color: #909090");
        if (inferredType != null) {
            buffer.append(" ");
            GroovyDocumentationProvider.appendTypeString(buffer, inferredType, originalElement, isRendered);
        }
    }

    private static void generateModifiers(@Nls StringBuilder buffer, PsiModifierListOwner element) {
        String modifiers = PsiFormatUtil.formatModifiers((PsiModifierListOwner)element, (int)16384);
        if (!modifiers.isEmpty()) {
            QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)modifiers, (TextAttributes)GroovyDocHighlightingManager.getInstance().getKeywordAttributes());
            buffer.append(" ");
        }
    }

    private static void newLine(StringBuilder buffer) {
        buffer.append(LINE_SEPARATOR);
    }

    @Nls
    @NotNull
    private static String generateClassInfo(@NotNull PsiClass aClass) {
        if (aClass == null) {
            GroovyDocumentationProvider.$$$reportNull$$$0(2);
        }
        @Nls StringBuilder buffer = new StringBuilder();
        GroovyFile file = (GroovyFile)aClass.getContainingFile();
        GroovyDocHighlightingManager highlightingManager = GroovyDocHighlightingManager.getInstance();
        String packageName = file.getPackageName();
        if (!packageName.isEmpty()) {
            QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)packageName, (TextAttributes)highlightingManager.getClassNameAttributes());
            buffer.append(LINE_SEPARATOR);
        }
        String classString = aClass.isInterface() ? GroovyBundle.message("groovy.term.interface", new Object[0]) : (aClass instanceof PsiTypeParameter ? GroovyBundle.message("groovy.term.type.parameter", new Object[0]) : (aClass.isEnum() ? GroovyBundle.message("groovy.term.enum", new Object[0]) : GroovyBundle.message("groovy.term.class", new Object[0])));
        QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)classString, (TextAttributes)highlightingManager.getKeywordAttributes());
        buffer.append(" ");
        QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)aClass.getName(), (TextAttributes)highlightingManager.getClassDeclarationAttributes(aClass));
        JavaDocumentationProvider.generateTypeParameters((PsiTypeParameterListOwner)aClass, (StringBuilder)buffer, (JavaDocHighlightingManager)highlightingManager);
        JavaDocumentationProvider.writeExtends((PsiClass)aClass, (StringBuilder)buffer, (PsiClassType[])aClass.getExtendsListTypes(), (JavaDocHighlightingManager)highlightingManager);
        JavaDocumentationProvider.writeImplements((PsiClass)aClass, (StringBuilder)buffer, (PsiClassType[])aClass.getImplementsListTypes(), (JavaDocHighlightingManager)highlightingManager);
        String string = buffer.toString();
        if (string == null) {
            GroovyDocumentationProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static void appendTypeString(@Nls @NotNull StringBuilder buffer, @Nullable PsiType type, PsiElement context, boolean isRendered) {
        if (buffer == null) {
            GroovyDocumentationProvider.$$$reportNull$$$0(4);
        }
        if (type instanceof GrTraitType) {
            GroovyDocumentationProvider.generateTraitType(buffer, (GrTraitType)type, context, isRendered);
        } else if (type != null) {
            JavaDocInfoGeneratorFactory.getBuilder((Project)context.getProject()).setHighlightingManager((JavaDocHighlightingManager)GroovyDocHighlightingManager.getInstance()).setIsGenerationForRenderedDoc(isRendered).create().generateType(buffer, type, context);
        } else {
            QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)"def", (TextAttributes)GroovyDocHighlightingManager.getInstance().getKeywordAttributes());
        }
    }

    private static void generateTraitType(@NotNull StringBuilder buffer, @NotNull GrTraitType type, PsiElement context, boolean isRendered) {
        if (buffer == null) {
            GroovyDocumentationProvider.$$$reportNull$$$0(5);
        }
        if (type == null) {
            GroovyDocumentationProvider.$$$reportNull$$$0(6);
        }
        GroovyDocumentationProvider.appendTypeString(buffer, type.getExprType(), context, isRendered);
        QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)" as ", (TextAttributes)GroovyDocHighlightingManager.getInstance().getKeywordAttributes());
        @NotNull List<PsiType> types = type.getTraitTypes();
        for (int i2 = 0; i2 < types.size(); ++i2) {
            PsiType traitType = types.get(i2);
            GroovyDocumentationProvider.appendTypeString(buffer, traitType, context, isRendered);
            if (i2 == types.size() - 1) continue;
            QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)", ", (TextAttributes)GroovyDocHighlightingManager.getInstance().getCommaAttributes());
        }
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        List list;
        ArrayList<String> result2 = new ArrayList<String>();
        PsiElement docElement = GroovyDocumentationProvider.getDocumentationElement(element, originalElement);
        if (docElement != null) {
            ContainerUtil.addIfNotNull(result2, (Object)((String)docElement.getUserData(NonCodeMembersHolder.DOCUMENTATION_URL)));
        }
        if ((list = JavaDocumentationProvider.getExternalJavaDocUrl((PsiElement)element)) != null) {
            result2.addAll(list);
        }
        return result2.isEmpty() ? null : result2;
    }

    @Nullable
    @Nls
    public String generateDoc(PsiElement element, PsiElement originalElement) {
        String gdslDoc;
        GroovyDocHighlightingManager highlightingManager = GroovyDocHighlightingManager.getInstance();
        if (element instanceof GdslNamedParameter) {
            String name = ((GdslNamedParameter)element).getName();
            if (name == null) {
                return null;
            }
            StringBuilder buffer = new StringBuilder("<pre>");
            String parameterTypeText = ((GdslNamedParameter)element).myParameterTypeText;
            QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)name, (TextAttributes)highlightingManager.getParameterAttributes());
            if (parameterTypeText != null) {
                QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)":", (TextAttributes)highlightingManager.getOperationSignAttributes());
                buffer.append(" ");
                QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)parameterTypeText, (TextAttributes)highlightingManager.getClassNameAttributes());
            }
            buffer.append("</pre>");
            String docString = ((GdslNamedParameter)element).docString;
            if (docString != null) {
                buffer.append("<p>").append(HtmlChunk.text((String)docString)).append("</p>");
            }
            return buffer.toString();
        }
        if (element instanceof GrReferenceExpression) {
            return GroovyDocumentationProvider.getMethodCandidateInfo((GrReferenceExpression)element);
        }
        if ((element = GroovyDocumentationProvider.getDocumentationElement(element, originalElement)) == null) {
            return null;
        }
        String standard = GroovyDocumentationProvider.generateExternalJavaDoc(element);
        if (element instanceof GrVariable && ((GrVariable)element).getDeclaredType() == null && standard != null) {
            String truncated = StringUtil.trimEnd((String)standard, (String)BODY_HTML);
            @Nls StringBuilder buffer = new StringBuilder(truncated);
            buffer.append("<p style='padding-left:8px;'>");
            if (originalElement != null) {
                GroovyDocumentationProvider.appendInferredType(originalElement, (GrVariable)element, buffer, false);
            } else if (element.getParent() instanceof GrVariableDeclaration) {
                GroovyDocumentationProvider.appendInferredType(element.getParent(), (GrVariable)element, buffer, false);
            }
            if (!truncated.equals(standard)) {
                buffer.append(BODY_HTML);
            }
            standard = buffer.toString();
        }
        if ((gdslDoc = (String)element.getUserData(NonCodeMembersHolder.DOCUMENTATION)) != null) {
            if (standard != null) {
                String truncated = StringUtil.trimEnd((String)standard, (String)BODY_HTML);
                String appended = truncated + "<p>" + gdslDoc;
                if (truncated.equals(standard)) {
                    return appended;
                }
                return appended + BODY_HTML;
            }
            return gdslDoc;
        }
        return standard;
    }

    private static GroovyDocInfoGenerator getDocInfoGenerator(@NotNull PsiElement element, boolean isGenerationForRenderedDoc) {
        if (element == null) {
            GroovyDocumentationProvider.$$$reportNull$$$0(7);
        }
        return new GroovyDocInfoGenerator(element, isGenerationForRenderedDoc, DocumentationSettings.isHighlightingOfQuickDocSignaturesEnabled(), DocumentationSettings.isHighlightingOfCodeBlocksEnabled(), DocumentationSettings.getInlineCodeHighlightingMode(), DocumentationSettings.isSemanticHighlightingOfLinksEnabled(), DocumentationSettings.getHighlightingSaturation((boolean)isGenerationForRenderedDoc));
    }

    @Nls
    @Nullable
    private static String generateExternalJavaDoc(@NotNull PsiElement element) {
        if (element == null) {
            GroovyDocumentationProvider.$$$reportNull$$$0(8);
        }
        GroovyDocInfoGenerator generator = GroovyDocumentationProvider.getDocInfoGenerator(element, false);
        return JavaDocumentationProvider.generateExternalJavadoc((PsiElement)element, (JavaDocInfoGenerator)generator);
    }

    private static PsiElement getDocumentationElement(PsiElement element, PsiElement originalElement) {
        GrDocComment doc;
        if (element instanceof GrGdkMethod) {
            GrGdkMethod method = (GrGdkMethod)element;
            element = method.getStaticMethod();
        }
        if ((doc = (GrDocComment)PsiTreeUtil.getParentOfType((PsiElement)originalElement, GrDocComment.class)) != null) {
            element = GrDocCommentUtil.findDocOwner(doc);
        }
        if (element instanceof GrLightVariable) {
            GrLightVariable var = (GrLightVariable)element;
            PsiElement navigationElement = var.getNavigationElement();
            if ((element = navigationElement).getContainingFile() instanceof PsiCompiledFile && (navigationElement = element.getNavigationElement()) != null) {
                element = navigationElement;
            }
            if (element instanceof GrAccessorMethod) {
                GrAccessorMethod method = (GrAccessorMethod)element;
                element = method.getProperty();
            }
        }
        if (element instanceof GrPropertyForCompletion) {
            GrPropertyForCompletion property = (GrPropertyForCompletion)element;
            element = property.getOriginalAccessor();
        }
        return element;
    }

    @Nls
    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls, boolean onHover) {
        return JavaDocumentationProvider.fetchExternalJavadoc((PsiElement)element, (Project)project, docUrls);
    }

    public boolean hasDocumentationFor(PsiElement element, PsiElement originalElement) {
        return CompositeDocumentationProvider.hasUrlsFor((DocumentationProvider)this, (PsiElement)element, (PsiElement)originalElement);
    }

    public boolean canPromptToConfigureDocumentation(PsiElement element) {
        return false;
    }

    public void promptToConfigureDocumentation(PsiElement element) {
    }

    @Nls
    private static String getMethodCandidateInfo(GrReferenceExpression expr) {
        GroovyResolveResult[] candidates = expr.multiResolve(false);
        String text = expr.getText();
        if (candidates.length > 0) {
            @NonNls StringBuilder sb = new StringBuilder();
            for (GroovyResolveResult candidate : candidates) {
                PsiElement element = candidate.getElement();
                if (!(element instanceof PsiMethod)) continue;
                String str = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)element), (PsiSubstitutor)candidate.getSubstitutor(), (int)259, (int)2);
                sb.append("&nbsp;&nbsp;");
                GroovyDocumentationProvider.appendElementLink(sb, element, str);
                sb.append("<br>");
            }
            return CodeInsightBundle.message((String)"javadoc.candidates", (Object[])new Object[]{text, sb});
        }
        return JavaBundle.message((String)"javadoc.candidates.not.found", (Object[])new Object[]{text});
    }

    private static void appendElementLink(@NonNls StringBuilder sb, PsiElement element, String label) {
        GroovyDocumentationProvider.getDocInfoGenerator(element, false).appendMaybeUnresolvedLink(sb, element, label, element.getProject(), false);
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (object instanceof GroovyResolveResult) {
            return ((GroovyResolveResult)object).getElement();
        }
        if (object instanceof NamedArgumentDescriptor) {
            return ((NamedArgumentDescriptor)object).getNavigationElement();
        }
        if (object instanceof GrPropertyForCompletion) {
            return ((GrPropertyForCompletion)((Object)object)).getOriginalAccessor();
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return JavaDocUtil.findReferenceTarget((PsiManager)psiManager, (String)link, (PsiElement)context);
    }

    public PsiComment findExistingDocComment(PsiComment contextElement) {
        GrDocCommentOwner owner;
        if (contextElement instanceof GrDocComment && (owner = GrDocCommentUtil.findDocOwner((GrDocComment)contextElement)) != null) {
            return owner.getDocComment();
        }
        return null;
    }

    @Nullable
    public Pair<PsiElement, PsiComment> parseContext(@NotNull PsiElement startPoint) {
        if (startPoint == null) {
            GroovyDocumentationProvider.$$$reportNull$$$0(9);
        }
        for (PsiElement e = startPoint; e != null; e = e.getParent()) {
            if (!(e instanceof GrDocCommentOwner)) continue;
            return Pair.create((Object)e, (Object)((GrDocCommentOwner)e).getDocComment());
        }
        return null;
    }

    public String generateDocumentationContentStub(PsiComment contextComment) {
        PsiTypeParameterList typeParameterList;
        if (!(contextComment instanceof GrDocComment)) {
            return null;
        }
        GrDocCommentOwner owner = GrDocCommentUtil.findDocOwner((GrDocComment)contextComment);
        if (owner == null) {
            return null;
        }
        CodeDocumentationAwareCommenter commenter = (CodeDocumentationAwareCommenter)LanguageCommenters.INSTANCE.forLanguage(owner.getLanguage());
        StringBuilder builder = new StringBuilder();
        if (owner instanceof GrMethod) {
            PsiClassType[] references;
            GrMethod method = (GrMethod)owner;
            JavaDocumentationProvider.generateParametersTakingDocFromSuperMethods((StringBuilder)builder, (CodeDocumentationAwareCommenter)commenter, (PsiMethod)method);
            PsiType returnType = method.getInferredReturnType();
            if ((returnType != null || method.getModifierList().hasModifierProperty("def")) && !PsiTypes.voidType().equals((Object)returnType)) {
                builder.append(CodeDocumentationUtil.createDocCommentLine((String)RETURN_TAG, (PsiFile)contextComment.getContainingFile(), (CodeDocumentationAwareCommenter)commenter));
                builder.append(LINE_SEPARATOR);
            }
            for (PsiClassType reference : references = method.getThrowsList().getReferencedTypes()) {
                builder.append(CodeDocumentationUtil.createDocCommentLine((String)THROWS_TAG, (PsiFile)contextComment.getContainingFile(), (CodeDocumentationAwareCommenter)commenter));
                builder.append(reference.getClassName());
                builder.append(LINE_SEPARATOR);
            }
        } else if (owner instanceof GrTypeDefinition && (typeParameterList = ((PsiClass)owner).getTypeParameterList()) != null) {
            JavaDocumentationProvider.createTypeParamsListComment((StringBuilder)builder, (CodeDocumentationAwareCommenter)commenter, (PsiTypeParameterList)typeParameterList);
        }
        return builder.length() > 0 ? builder.toString() : null;
    }

    public void collectDocComments(@NotNull PsiFile file, @NotNull @NotNull Consumer<? super @NotNull PsiDocCommentBase> sink) {
        if (file == null) {
            GroovyDocumentationProvider.$$$reportNull$$$0(10);
        }
        if (sink == null) {
            GroovyDocumentationProvider.$$$reportNull$$$0(11);
        }
        if (!(file instanceof GroovyFile)) {
            return;
        }
        GroovyFile groovyFile = (GroovyFile)file;
        List owners = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)groovyFile, GrDocCommentOwner.class);
        List comments = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)groovyFile, GrDocComment.class);
        GroovyDocumentationProvider.processDocComments(owners, comments, sink);
    }

    private static void processDocComments(@NotNull List<GrDocCommentOwner> owners, @NonNls List<GrDocComment> danglingDocComments, @NotNull @NotNull Consumer<? super @NotNull PsiDocCommentBase> sink) {
        if (owners == null) {
            GroovyDocumentationProvider.$$$reportNull$$$0(12);
        }
        if (sink == null) {
            GroovyDocumentationProvider.$$$reportNull$$$0(13);
        }
        for (GrDocComment docComment : danglingDocComments) {
            if (docComment == null) continue;
            sink.accept((PsiDocCommentBase)docComment);
        }
        for (GrDocCommentOwner owner : owners) {
            if (owner == null) continue;
            GrDocComment comment = owner.getDocComment();
            if (comment != null) {
                sink.accept((PsiDocCommentBase)comment);
            }
            if (!(owner instanceof GrTypeDefinition)) continue;
            List nestedComments = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)((GrTypeDefinition)owner).getBody(), GrDocComment.class);
            List nestedOwners = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)((GrTypeDefinition)owner).getBody(), GrDocCommentOwner.class);
            GroovyDocumentationProvider.processDocComments(nestedOwners, nestedComments, sink);
        }
    }

    @Nls
    @Nullable
    public String generateRenderedDoc(@NotNull PsiDocCommentBase comment) {
        PsiElement owner;
        if (comment == null) {
            GroovyDocumentationProvider.$$$reportNull$$$0(14);
        }
        String html = GroovyDocumentationProvider.getDocInfoGenerator((PsiElement)((owner = comment.getOwner()) == null ? comment : owner), true).generateRenderedDocInfo();
        return JavaDocExternalFilter.filterInternalDocInfo((String)html);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/documentation/GroovyDocumentationProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPoint";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owners";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/documentation/GroovyDocumentationProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "generateClassInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendStyledSpan";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generateClassInfo";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendTypeString";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateTraitType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDocInfoGenerator";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateExternalJavaDoc";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseContext";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectDocComments";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processDocComments";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generateRenderedDoc";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

