/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.comms.common.utils;

import java.net.UnixDomainSocketAddress;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0012\u001a\u00020\u0013J\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0015R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/station/comms/common/utils/StationConstants;", "", "<init>", "()V", "ideIdHeader", "", "getIdeIdHeader", "()Ljava/lang/String;", "idePidHeader", "getIdePidHeader", "ideInstallPathHeader", "getIdeInstallPathHeader", "ideFullVersionHeader", "getIdeFullVersionHeader", "stationFailureHeader", "getStationFailureHeader", "unknownEndpointValue", "getUnknownEndpointValue", "getStationAddress", "Ljava/net/UnixDomainSocketAddress;", "getBaseDirectoryAndUserName", "Lkotlin/Pair;", "intellij.station.comms.common"})
@SourceDebugExtension(value={"SMAP\nStationConstants.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StationConstants.kt\ncom/intellij/station/comms/common/utils/StationConstants\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,28:1\n1#2:29\n*E\n"})
public final class StationConstants {
    @NotNull
    public static final StationConstants INSTANCE = new StationConstants();
    @NotNull
    private static final String ideIdHeader = "X-Ide-Id";
    @NotNull
    private static final String idePidHeader = "X-Ide-Pid";
    @NotNull
    private static final String ideInstallPathHeader = "X-Ide-Install-Path";
    @NotNull
    private static final String ideFullVersionHeader = "X-Ide-Full-Version";
    @NotNull
    private static final String stationFailureHeader = "X-Station-Failure";
    @NotNull
    private static final String unknownEndpointValue = "no-endpoint";

    private StationConstants() {
    }

    @NotNull
    public final String getIdeIdHeader() {
        return ideIdHeader;
    }

    @NotNull
    public final String getIdePidHeader() {
        return idePidHeader;
    }

    @NotNull
    public final String getIdeInstallPathHeader() {
        return ideInstallPathHeader;
    }

    @NotNull
    public final String getIdeFullVersionHeader() {
        return ideFullVersionHeader;
    }

    @NotNull
    public final String getStationFailureHeader() {
        return stationFailureHeader;
    }

    @NotNull
    public final String getUnknownEndpointValue() {
        return unknownEndpointValue;
    }

    @NotNull
    public final UnixDomainSocketAddress getStationAddress() {
        Pair<String, String> pair = this.getBaseDirectoryAndUserName();
        String tempDirectory = (String)pair.component1();
        String userName = (String)pair.component2();
        String[] stringArray = new String[]{"jb.station." + userName + ".sock"};
        UnixDomainSocketAddress unixDomainSocketAddress = UnixDomainSocketAddress.of(Path.of(tempDirectory, stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)unixDomainSocketAddress, (String)"of(...)");
        return unixDomainSocketAddress;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<String, String> getBaseDirectoryAndUserName() {
        String string;
        String it = System.getProperty("user.name");
        boolean bl = false;
        CharSequence charSequence = it;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || Intrinsics.areEqual((Object)it, (Object)"?")) {
            string = System.getenv("USER");
            if (string == null) {
                string = "user";
            }
        } else {
            void var3_1;
            string = var3_1;
        }
        String userName = string;
        String tempDirectory = System.getProperty("java.io.tmpdir");
        return TuplesKt.to((Object)tempDirectory, (Object)userName);
    }
}

