/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.inline;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.inline.InlineCallableReferenceToLambdaPhase;
import org.jetbrains.kotlin.ir.inline.InlineFunctionResolver;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrInlineUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u001a\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/inline/CommonInlineCallableReferenceToLambdaPhase;", "Lorg/jetbrains/kotlin/ir/inline/InlineCallableReferenceToLambdaPhase;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "inlineFunctionResolver", "Lorg/jetbrains/kotlin/ir/inline/InlineFunctionResolver;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/ir/inline/InlineFunctionResolver;)V", "lower", "Lorg/jetbrains/kotlin/ir/IrElement;", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "data", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "visitFunctionReference", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "ir.inline"})
public abstract class CommonInlineCallableReferenceToLambdaPhase
extends InlineCallableReferenceToLambdaPhase {
    public CommonInlineCallableReferenceToLambdaPhase(@NotNull CommonBackendContext context, @NotNull InlineFunctionResolver inlineFunctionResolver) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)inlineFunctionResolver, (String)"inlineFunctionResolver");
        super(context, inlineFunctionResolver);
    }

    @NotNull
    public final IrElement lower(@NotNull IrFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        return (IrElement)function.accept(this, function.getParent());
    }

    @Override
    @NotNull
    public IrStatement visitFunction(@NotNull IrFunction declaration, @Nullable IrDeclarationParent data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        super.visitFunction(declaration, data);
        if (this.getInlineFunctionResolver().needsInlining(declaration)) {
            for (IrValueParameter parameter : declaration.getValueParameters()) {
                IrElementBase irElementBase;
                if (!IrInlineUtilsKt.isInlineParameter$default(parameter, null, 1, null) || (irElementBase = parameter.getDefaultValue()) == null || (irElementBase = irElementBase.getExpression()) == null) continue;
                IrElementBase defaultExpression = irElementBase;
                IrExpressionBody irExpressionBody = parameter.getDefaultValue();
                if (irExpressionBody != null) {
                    irExpressionBody.setExpression(this.transformToLambda((IrExpression)defaultExpression, declaration));
                }
            }
        }
        return declaration;
    }

    @Override
    @NotNull
    public IrElement visitFunctionReference(@NotNull IrFunctionReference expression, @Nullable IrDeclarationParent data) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitFunctionReference(expression, data);
        IrFunction owner = ((IrFunctionSymbol)expression.getSymbol()).getOwner();
        if (!AdditionalIrUtilsKt.isInlineArrayConstructor(owner, this.getContext().getIrBuiltIns())) {
            return expression;
        }
        return this.transformToLambda(expression, data);
    }
}

