/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.qodana.sarif.baseline;

import com.jetbrains.qodana.sarif.baseline.BaselineKt;
import com.jetbrains.qodana.sarif.baseline.DiffState;
import com.jetbrains.qodana.sarif.model.Result;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.SarifReport;
import com.jetbrains.qodana.sarif.model.Tool;
import com.jetbrains.qodana.sarif.model.ToolComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class BaselineCalculation {
    public static final String EQUAL_INDICATOR = "equalIndicator";
    private int newResults = 0;
    private int absentResults = 0;
    private int unchangedResults = 0;
    private final Options options;

    private BaselineCalculation(Options options) {
        this.options = options;
    }

    public static BaselineCalculation compare(SarifReport report2, SarifReport baseline, Options options) {
        BaselineCalculation result2 = new BaselineCalculation(options);
        result2.fillBaselineState(report2, baseline);
        return result2;
    }

    public static BaselineCalculation compare(SarifReport report2, SarifReport baseline) {
        return BaselineCalculation.compare(report2, baseline, Options.DEFAULT);
    }

    public int getNewResults() {
        return this.newResults;
    }

    public int getAbsentResults() {
        return this.absentResults;
    }

    public int getUnchangedResults() {
        return this.unchangedResults;
    }

    public void fillBaselineState(SarifReport report2, SarifReport baseline) {
        List<Run> baselineRunsField = baseline.getRuns();
        ArrayList<Run> baselineRuns = baselineRunsField != null ? new ArrayList<Run>(baselineRunsField) : Collections.emptyList();
        ArrayList<Run> unmatched = new ArrayList<Run>();
        for (Run run2 : report2.getRuns()) {
            Optional<Run> first = baselineRuns.stream().filter(it -> Objects.equals(this.getToolName((Run)it), this.getToolName(run2))).findFirst();
            if (first.isPresent()) {
                Run baselineRun = first.get();
                this.applyBaseline(run2, baselineRun);
                baselineRuns.remove(baselineRun);
                continue;
            }
            unmatched.add(run2);
        }
        for (int i = 0; i < unmatched.size(); ++i) {
            Run baselineRun;
            Run run2;
            run2 = (Run)unmatched.get(i);
            Run run3 = baselineRun = i < baselineRuns.size() ? (Run)baselineRuns.get(i) : null;
            if (baselineRun == null) {
                this.markRunAsNew(run2);
                continue;
            }
            this.applyBaseline(run2, baselineRun);
        }
    }

    private void applyBaseline(Run run2, Run baseline) {
        DiffState state = BaselineKt.applyBaseline(run2, baseline, this.options);
        this.unchangedResults += state.getUnchanged();
        this.newResults += state.getNew();
        this.absentResults += state.getAbsent();
    }

    private void markRunAsNew(Run run2) {
        for (Result result2 : run2.getResults()) {
            result2.setBaselineState(Result.BaselineState.NEW);
            ++this.newResults;
        }
    }

    private String getToolName(Run run2) {
        Tool tool = run2.getTool();
        if (tool == null) {
            return null;
        }
        ToolComponent driver = tool.getDriver();
        if (driver == null) {
            return null;
        }
        return driver.getName();
    }

    public static class Options {
        final boolean includeAbsent;
        final boolean includeUnchanged;
        final boolean fillBaselineState;
        private static final Function<Result, Boolean> ALL_CHECKED = result2 -> true;
        final Function<Result, Boolean> wasChecked;
        public static final Options DEFAULT = new Options();

        public Options() {
            this.includeAbsent = false;
            this.includeUnchanged = true;
            this.fillBaselineState = true;
            this.wasChecked = ALL_CHECKED;
        }

        public Options(boolean includeAbsent) {
            this(includeAbsent, true, true);
        }

        public Options(boolean includeAbsent, boolean includeUnchanged, boolean fillBaselineState) {
            this.includeAbsent = includeAbsent;
            this.includeUnchanged = includeUnchanged;
            this.fillBaselineState = fillBaselineState;
            this.wasChecked = ALL_CHECKED;
        }

        public Options(boolean includeAbsent, boolean includeUnchanged, boolean fillBaselineState, Function<Result, Boolean> wasChecked) {
            this.includeAbsent = includeAbsent;
            this.includeUnchanged = includeUnchanged;
            this.fillBaselineState = fillBaselineState;
            this.wasChecked = wasChecked;
        }

        public boolean isIncludeAbsent() {
            return this.includeAbsent;
        }

        public boolean isIncludeUnchanged() {
            return this.includeUnchanged;
        }

        public boolean isFillBaselineState() {
            return this.fillBaselineState;
        }
    }
}

