/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin;

import androidx.compose.compiler.plugins.kotlin.ComposeConfiguration;
import androidx.compose.compiler.plugins.kotlin.ComposePluginKt;
import androidx.compose.compiler.plugins.kotlin.FeatureFlag;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compiler.plugin.AbstractCliOption;
import org.jetbrains.kotlin.compiler.plugin.CliOption;
import org.jetbrains.kotlin.compiler.plugin.CliOptionProcessingException;
import org.jetbrains.kotlin.compiler.plugin.CommandLineProcessor;
import org.jetbrains.kotlin.config.CompilerConfiguration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Landroidx/compose/compiler/plugins/kotlin/ComposeCommandLineProcessor;", "Lorg/jetbrains/kotlin/compiler/plugin/CommandLineProcessor;", "<init>", "()V", "pluginId", "", "getPluginId", "()Ljava/lang/String;", "pluginOptions", "", "Lorg/jetbrains/kotlin/compiler/plugin/CliOption;", "getPluginOptions", "()Ljava/util/List;", "processOption", "", "option", "Lorg/jetbrains/kotlin/compiler/plugin/AbstractCliOption;", "value", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "Companion", "compiler-hosted"})
public final class ComposeCommandLineProcessor
implements CommandLineProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pluginId = PLUGIN_ID;
    @NotNull
    private final List<CliOption> pluginOptions;
    @NotNull
    private static final String PLUGIN_ID = "androidx.compose.compiler.plugins.kotlin";
    @NotNull
    private static final CliOption LIVE_LITERALS_ENABLED_OPTION = new CliOption("liveLiterals", "<true|false>", "Enable Live Literals code generation", false, false);
    @NotNull
    private static final CliOption LIVE_LITERALS_V2_ENABLED_OPTION = new CliOption("liveLiteralsEnabled", "<true|false>", "Enable Live Literals code generation (with per-file enabled flags)", false, false);
    @NotNull
    private static final CliOption GENERATE_FUNCTION_KEY_META_CLASSES_OPTION = new CliOption("generateFunctionKeyMetaClasses", "<true|false>", "Generate function key meta classes with annotations indicating the functions and their group keys. Generally used for tooling.", false, false);
    @NotNull
    private static final CliOption SOURCE_INFORMATION_ENABLED_OPTION = new CliOption("sourceInformation", "<true|false>", "Include source information in generated code", false, false);
    @NotNull
    private static final CliOption METRICS_DESTINATION_OPTION = new CliOption("metricsDestination", "<path>", "Save compose build metrics to this folder", false, false);
    @NotNull
    private static final CliOption REPORTS_DESTINATION_OPTION = new CliOption("reportsDestination", "<path>", "Save compose build reports to this folder", false, false);
    @NotNull
    private static final CliOption FEATURE_FLAG_OPTION = new CliOption("featureFlag", "<feature name>", "The name of the feature to enable", false, true);
    @NotNull
    private static final CliOption INTRINSIC_REMEMBER_OPTIMIZATION_ENABLED_OPTION = new CliOption("intrinsicRemember", "<true|false>", "Include source information in generated code. Deprecated. Use " + ComposePluginKt.useFeatureFlagInsteadMessage(FeatureFlag.IntrinsicRemember), false, false);
    @NotNull
    private static final CliOption NON_SKIPPING_GROUP_OPTIMIZATION_ENABLED_OPTION = new CliOption("nonSkippingGroupOptimization", "<true|false>", "Remove groups around non-skipping composable functions. Deprecated. " + ComposePluginKt.useFeatureFlagInsteadMessage(FeatureFlag.OptimizeNonSkippingGroups), false, false);
    @NotNull
    private static final CliOption SUPPRESS_KOTLIN_VERSION_CHECK_ENABLED_OPTION = new CliOption("suppressKotlinVersionCompatibilityCheck", "<kotlin_version>", "Deprecated. Suppress Kotlin version compatibility check", false, false);
    @NotNull
    private static final CliOption DECOYS_ENABLED_OPTION = new CliOption("generateDecoys", "<true|false>", "Generate decoy methods in IR transform", false, false);
    @NotNull
    private static final CliOption STRONG_SKIPPING_OPTION = new CliOption("strongSkipping", "<true|false>", "Enable strong skipping mode. Deprecated. " + ComposePluginKt.useFeatureFlagInsteadMessage(FeatureFlag.StrongSkipping), false, false);
    @NotNull
    private static final CliOption EXPERIMENTAL_STRONG_SKIPPING_OPTION = new CliOption("experimentalStrongSkipping", "<true|false>", "Deprecated. " + ComposePluginKt.useFeatureFlagInsteadMessage(FeatureFlag.StrongSkipping), false, false);
    @NotNull
    private static final CliOption STABLE_CONFIG_PATH_OPTION = new CliOption("stabilityConfigurationPath", "<path>", "Path to stability configuration file", false, true);
    @NotNull
    private static final CliOption TRACE_MARKERS_OPTION = new CliOption("traceMarkersEnabled", "<true|false>", "Include composition trace markers in generate code", false, false);
    @NotNull
    private static final CliOption SKIP_IR_LOWERING_IF_RUNTIME_NOT_FOUND_OPTION = new CliOption("skipIrLoweringIfRuntimeNotFound", "<true|false>", "Skip IR lowering transformation when finding Compose runtime fails", false, false);

    public ComposeCommandLineProcessor() {
        Object[] objectArray = new CliOption[]{LIVE_LITERALS_ENABLED_OPTION, LIVE_LITERALS_V2_ENABLED_OPTION, GENERATE_FUNCTION_KEY_META_CLASSES_OPTION, SOURCE_INFORMATION_ENABLED_OPTION, METRICS_DESTINATION_OPTION, REPORTS_DESTINATION_OPTION, INTRINSIC_REMEMBER_OPTIMIZATION_ENABLED_OPTION, NON_SKIPPING_GROUP_OPTIMIZATION_ENABLED_OPTION, SUPPRESS_KOTLIN_VERSION_CHECK_ENABLED_OPTION, DECOYS_ENABLED_OPTION, EXPERIMENTAL_STRONG_SKIPPING_OPTION, STRONG_SKIPPING_OPTION, STABLE_CONFIG_PATH_OPTION, TRACE_MARKERS_OPTION, FEATURE_FLAG_OPTION, SKIP_IR_LOWERING_IF_RUNTIME_NOT_FOUND_OPTION};
        this.pluginOptions = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public String getPluginId() {
        return this.pluginId;
    }

    @NotNull
    public List<CliOption> getPluginOptions() {
        return this.pluginOptions;
    }

    public void processOption(@NotNull AbstractCliOption option, @NotNull String value, @NotNull CompilerConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        AbstractCliOption abstractCliOption = option;
        if (Intrinsics.areEqual((Object)abstractCliOption, (Object)LIVE_LITERALS_ENABLED_OPTION)) {
            configuration.put(ComposeConfiguration.INSTANCE.getLIVE_LITERALS_ENABLED_KEY(), (Object)Intrinsics.areEqual((Object)value, (Object)"true"));
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)LIVE_LITERALS_V2_ENABLED_OPTION)) {
            configuration.put(ComposeConfiguration.INSTANCE.getLIVE_LITERALS_V2_ENABLED_KEY(), (Object)Intrinsics.areEqual((Object)value, (Object)"true"));
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)GENERATE_FUNCTION_KEY_META_CLASSES_OPTION)) {
            configuration.put(ComposeConfiguration.INSTANCE.getGENERATE_FUNCTION_KEY_META_CLASSES_KEY(), (Object)Intrinsics.areEqual((Object)value, (Object)"true"));
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)SOURCE_INFORMATION_ENABLED_OPTION)) {
            configuration.put(ComposeConfiguration.INSTANCE.getSOURCE_INFORMATION_ENABLED_KEY(), (Object)Intrinsics.areEqual((Object)value, (Object)"true"));
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)METRICS_DESTINATION_OPTION)) {
            configuration.put(ComposeConfiguration.INSTANCE.getMETRICS_DESTINATION_KEY(), (Object)value);
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)REPORTS_DESTINATION_OPTION)) {
            configuration.put(ComposeConfiguration.INSTANCE.getREPORTS_DESTINATION_KEY(), (Object)value);
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)INTRINSIC_REMEMBER_OPTIMIZATION_ENABLED_OPTION)) {
            ComposePluginKt.oldOptionDeprecationWarning(configuration, (AbstractCliOption)INTRINSIC_REMEMBER_OPTIMIZATION_ENABLED_OPTION, FeatureFlag.IntrinsicRemember);
            configuration.put(ComposeConfiguration.INSTANCE.getINTRINSIC_REMEMBER_OPTIMIZATION_ENABLED_KEY(), (Object)Intrinsics.areEqual((Object)value, (Object)"true"));
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)NON_SKIPPING_GROUP_OPTIMIZATION_ENABLED_OPTION)) {
            ComposePluginKt.oldOptionDeprecationWarning(configuration, (AbstractCliOption)NON_SKIPPING_GROUP_OPTIMIZATION_ENABLED_OPTION, FeatureFlag.OptimizeNonSkippingGroups);
            configuration.put(ComposeConfiguration.INSTANCE.getNON_SKIPPING_GROUP_OPTIMIZATION_ENABLED_KEY(), (Object)Intrinsics.areEqual((Object)value, (Object)"true"));
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)SUPPRESS_KOTLIN_VERSION_CHECK_ENABLED_OPTION)) {
            configuration.put(ComposeConfiguration.INSTANCE.getSUPPRESS_KOTLIN_VERSION_COMPATIBILITY_CHECK(), (Object)value);
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)DECOYS_ENABLED_OPTION)) {
            configuration.put(ComposeConfiguration.INSTANCE.getDECOYS_ENABLED_KEY(), (Object)Intrinsics.areEqual((Object)value, (Object)"true"));
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)EXPERIMENTAL_STRONG_SKIPPING_OPTION)) {
            ComposePluginKt.oldOptionDeprecationWarning(configuration, (AbstractCliOption)EXPERIMENTAL_STRONG_SKIPPING_OPTION, FeatureFlag.StrongSkipping);
            configuration.put(ComposeConfiguration.INSTANCE.getSTRONG_SKIPPING_ENABLED_KEY(), (Object)Intrinsics.areEqual((Object)value, (Object)"true"));
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)STRONG_SKIPPING_OPTION)) {
            ComposePluginKt.oldOptionDeprecationWarning(configuration, (AbstractCliOption)EXPERIMENTAL_STRONG_SKIPPING_OPTION, FeatureFlag.StrongSkipping);
            configuration.put(ComposeConfiguration.INSTANCE.getSTRONG_SKIPPING_ENABLED_KEY(), (Object)Intrinsics.areEqual((Object)value, (Object)"true"));
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)STABLE_CONFIG_PATH_OPTION)) {
            this.appendList(configuration, ComposeConfiguration.INSTANCE.getSTABILITY_CONFIG_PATH_KEY(), value);
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)TRACE_MARKERS_OPTION)) {
            configuration.put(ComposeConfiguration.INSTANCE.getTRACE_MARKERS_ENABLED_KEY(), (Object)Intrinsics.areEqual((Object)value, (Object)"true"));
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)FEATURE_FLAG_OPTION)) {
            ComposePluginKt.validateFeatureFlag(configuration, value);
            this.appendList(configuration, ComposeConfiguration.INSTANCE.getFEATURE_FLAGS(), value);
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)SKIP_IR_LOWERING_IF_RUNTIME_NOT_FOUND_OPTION)) {
            configuration.put(ComposeConfiguration.INSTANCE.getSKIP_IR_LOWERING_IF_RUNTIME_NOT_FOUND_KEY(), (Object)Intrinsics.areEqual((Object)value, (Object)"true"));
        } else {
            throw new CliOptionProcessingException("Unknown option: " + option.getOptionName(), null, 2, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b!\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0012\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0011\u0010\u0014\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR\u0011\u0010\u0016\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000bR\u0011\u0010\u0018\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000bR\u0011\u0010\u001a\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000bR\u0011\u0010\u001c\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000bR\u0011\u0010\u001e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000bR\u0011\u0010 \u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000bR\u0011\u0010\"\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000bR\u0011\u0010$\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u000bR\u0011\u0010&\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u000bR\u0011\u0010(\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u000b\u00a8\u0006*"}, d2={"Landroidx/compose/compiler/plugins/kotlin/ComposeCommandLineProcessor$Companion;", "", "<init>", "()V", "PLUGIN_ID", "", "getPLUGIN_ID", "()Ljava/lang/String;", "LIVE_LITERALS_ENABLED_OPTION", "Lorg/jetbrains/kotlin/compiler/plugin/CliOption;", "getLIVE_LITERALS_ENABLED_OPTION", "()Lorg/jetbrains/kotlin/compiler/plugin/CliOption;", "LIVE_LITERALS_V2_ENABLED_OPTION", "getLIVE_LITERALS_V2_ENABLED_OPTION", "GENERATE_FUNCTION_KEY_META_CLASSES_OPTION", "getGENERATE_FUNCTION_KEY_META_CLASSES_OPTION", "SOURCE_INFORMATION_ENABLED_OPTION", "getSOURCE_INFORMATION_ENABLED_OPTION", "METRICS_DESTINATION_OPTION", "getMETRICS_DESTINATION_OPTION", "REPORTS_DESTINATION_OPTION", "getREPORTS_DESTINATION_OPTION", "FEATURE_FLAG_OPTION", "getFEATURE_FLAG_OPTION", "INTRINSIC_REMEMBER_OPTIMIZATION_ENABLED_OPTION", "getINTRINSIC_REMEMBER_OPTIMIZATION_ENABLED_OPTION", "NON_SKIPPING_GROUP_OPTIMIZATION_ENABLED_OPTION", "getNON_SKIPPING_GROUP_OPTIMIZATION_ENABLED_OPTION", "SUPPRESS_KOTLIN_VERSION_CHECK_ENABLED_OPTION", "getSUPPRESS_KOTLIN_VERSION_CHECK_ENABLED_OPTION", "DECOYS_ENABLED_OPTION", "getDECOYS_ENABLED_OPTION", "STRONG_SKIPPING_OPTION", "getSTRONG_SKIPPING_OPTION", "EXPERIMENTAL_STRONG_SKIPPING_OPTION", "getEXPERIMENTAL_STRONG_SKIPPING_OPTION", "STABLE_CONFIG_PATH_OPTION", "getSTABLE_CONFIG_PATH_OPTION", "TRACE_MARKERS_OPTION", "getTRACE_MARKERS_OPTION", "SKIP_IR_LOWERING_IF_RUNTIME_NOT_FOUND_OPTION", "getSKIP_IR_LOWERING_IF_RUNTIME_NOT_FOUND_OPTION", "compiler-hosted"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getPLUGIN_ID() {
            return PLUGIN_ID;
        }

        @NotNull
        public final CliOption getLIVE_LITERALS_ENABLED_OPTION() {
            return LIVE_LITERALS_ENABLED_OPTION;
        }

        @NotNull
        public final CliOption getLIVE_LITERALS_V2_ENABLED_OPTION() {
            return LIVE_LITERALS_V2_ENABLED_OPTION;
        }

        @NotNull
        public final CliOption getGENERATE_FUNCTION_KEY_META_CLASSES_OPTION() {
            return GENERATE_FUNCTION_KEY_META_CLASSES_OPTION;
        }

        @NotNull
        public final CliOption getSOURCE_INFORMATION_ENABLED_OPTION() {
            return SOURCE_INFORMATION_ENABLED_OPTION;
        }

        @NotNull
        public final CliOption getMETRICS_DESTINATION_OPTION() {
            return METRICS_DESTINATION_OPTION;
        }

        @NotNull
        public final CliOption getREPORTS_DESTINATION_OPTION() {
            return REPORTS_DESTINATION_OPTION;
        }

        @NotNull
        public final CliOption getFEATURE_FLAG_OPTION() {
            return FEATURE_FLAG_OPTION;
        }

        @NotNull
        public final CliOption getINTRINSIC_REMEMBER_OPTIMIZATION_ENABLED_OPTION() {
            return INTRINSIC_REMEMBER_OPTIMIZATION_ENABLED_OPTION;
        }

        @NotNull
        public final CliOption getNON_SKIPPING_GROUP_OPTIMIZATION_ENABLED_OPTION() {
            return NON_SKIPPING_GROUP_OPTIMIZATION_ENABLED_OPTION;
        }

        @NotNull
        public final CliOption getSUPPRESS_KOTLIN_VERSION_CHECK_ENABLED_OPTION() {
            return SUPPRESS_KOTLIN_VERSION_CHECK_ENABLED_OPTION;
        }

        @NotNull
        public final CliOption getDECOYS_ENABLED_OPTION() {
            return DECOYS_ENABLED_OPTION;
        }

        @NotNull
        public final CliOption getSTRONG_SKIPPING_OPTION() {
            return STRONG_SKIPPING_OPTION;
        }

        @NotNull
        public final CliOption getEXPERIMENTAL_STRONG_SKIPPING_OPTION() {
            return EXPERIMENTAL_STRONG_SKIPPING_OPTION;
        }

        @NotNull
        public final CliOption getSTABLE_CONFIG_PATH_OPTION() {
            return STABLE_CONFIG_PATH_OPTION;
        }

        @NotNull
        public final CliOption getTRACE_MARKERS_OPTION() {
            return TRACE_MARKERS_OPTION;
        }

        @NotNull
        public final CliOption getSKIP_IR_LOWERING_IF_RUNTIME_NOT_FOUND_OPTION() {
            return SKIP_IR_LOWERING_IF_RUNTIME_NOT_FOUND_OPTION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

