/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.ui.table.JBTable;
import javax.swing.DefaultCellEditor;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.core.formatter.KotlinPackageEntry;
import org.jetbrains.kotlin.idea.core.formatter.KotlinPackageEntryTable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"createTableForPackageEntries", "Lcom/intellij/ui/table/JBTable;", "packageTable", "Lorg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntryTable;", "kotlin.formatter.minimal"})
public final class BaseKotlinImportLayoutPanelKt {
    @NotNull
    public static final JBTable createTableForPackageEntries(@NotNull KotlinPackageEntryTable packageTable) {
        Intrinsics.checkNotNullParameter((Object)packageTable, (String)"packageTable");
        String[] stringArray = new String[]{KotlinBundle.message("listbox.import.package", new Object[0]), KotlinBundle.message("listbox.import.with.subpackages", new Object[0])};
        String[] names = stringArray;
        int packageNameColumnIndex = 0;
        int withSubpackagesColumnIndex = 1;
        AbstractTableModel dataModel2 = new AbstractTableModel(names, packageTable, packageNameColumnIndex, withSubpackagesColumnIndex){
            final /* synthetic */ String[] $names;
            final /* synthetic */ KotlinPackageEntryTable $packageTable;
            final /* synthetic */ int $packageNameColumnIndex;
            final /* synthetic */ int $withSubpackagesColumnIndex;
            {
                this.$names = $names;
                this.$packageTable = $packageTable;
                this.$packageNameColumnIndex = $packageNameColumnIndex;
                this.$withSubpackagesColumnIndex = $withSubpackagesColumnIndex;
            }

            public int getColumnCount() {
                return this.$names.length;
            }

            public int getRowCount() {
                return this.$packageTable.getEntryCount();
            }

            public Object getValueAt(int rowIndex, int columnIndex) {
                Object object;
                KotlinPackageEntry entry = this.$packageTable.getEntryAt(rowIndex);
                if (!this.isCellEditable(rowIndex, columnIndex)) {
                    return null;
                }
                int n = columnIndex;
                if (n == this.$packageNameColumnIndex) {
                    object = entry.getPackageName();
                } else if (n == this.$withSubpackagesColumnIndex) {
                    object = entry.getWithSubpackages();
                } else {
                    throw new IllegalArgumentException(String.valueOf(columnIndex));
                }
                return object;
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                KotlinPackageEntry entry = this.$packageTable.getEntryAt(rowIndex);
                return !entry.isSpecial();
            }

            public String getColumnName(int column) {
                return this.$names[column];
            }

            public Class<?> getColumnClass(int columnIndex) {
                Class clazz;
                int n = columnIndex;
                if (n == this.$packageNameColumnIndex) {
                    clazz = String.class;
                } else if (n == this.$withSubpackagesColumnIndex) {
                    clazz = Boolean.class;
                } else {
                    throw new IllegalArgumentException(String.valueOf(columnIndex));
                }
                return clazz;
            }

            public void setValueAt(Object value, int rowIndex, int columnIndex) {
                KotlinPackageEntry kotlinPackageEntry;
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                KotlinPackageEntry entry = this.$packageTable.getEntryAt(rowIndex);
                int n = columnIndex;
                if (n == this.$packageNameColumnIndex) {
                    kotlinPackageEntry = new KotlinPackageEntry(((Object)StringsKt.trim((CharSequence)((String)value))).toString(), entry.getWithSubpackages());
                } else if (n == this.$withSubpackagesColumnIndex) {
                    kotlinPackageEntry = new KotlinPackageEntry(entry.getPackageName(), Boolean.parseBoolean(value.toString()));
                } else {
                    throw new IllegalArgumentException(String.valueOf(columnIndex));
                }
                KotlinPackageEntry newEntry = kotlinPackageEntry;
                this.$packageTable.setEntryAt(newEntry, rowIndex);
            }
        };
        JBTable result = new JBTable((TableModel)dataModel2);
        result.getSelectionModel().setSelectionMode(0);
        TableCellEditor editor = result.getDefaultEditor(String.class);
        if (editor instanceof DefaultCellEditor) {
            ((DefaultCellEditor)editor).setClickCountToStart(1);
        }
        return result;
    }
}

