/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.performance;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.uast.UastHintedVisitorAdapter;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002J\f\u0010\u0007\u001a\u00020\u0005*\u00020\bH\u0002J\f\u0010\t\u001a\u00020\u0005*\u00020\bH\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/codeInspection/performance/UrlHashCodeInspection;", "Lcom/intellij/codeInspection/AbstractBaseUastLocalInspectionTool;", "<init>", "()V", "isUrlType", "", "Lorg/jetbrains/uast/UExpression;", "isMapType", "Lcom/intellij/psi/PsiClassType;", "isSetType", "mapKeyOperationMatcher", "Lcom/siyeh/ig/callMatcher/CallMatcher;", "setOperationMatcher", "hashCodeMatcher", "equalsMatcher", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "UrlHashCodeVisitor", "intellij.jvm.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nUrlHashCodeInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlHashCodeInspection.kt\ncom/intellij/codeInspection/performance/UrlHashCodeInspection\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n*L\n1#1,111:1\n171#2:112\n*S KotlinDebug\n*F\n+ 1 UrlHashCodeInspection.kt\ncom/intellij/codeInspection/performance/UrlHashCodeInspection\n*L\n39#1:112\n*E\n"})
public final class UrlHashCodeInspection
extends AbstractBaseUastLocalInspectionTool {
    @NotNull
    private final CallMatcher mapKeyOperationMatcher;
    @NotNull
    private final CallMatcher setOperationMatcher;
    @NotNull
    private final CallMatcher hashCodeMatcher;
    @NotNull
    private final CallMatcher equalsMatcher;

    public UrlHashCodeInspection() {
        String[] stringArray = new String[]{"compute", "computeIfAbsent", "computeIfPresent", "containsKey", "get", "getOrDefault", "merge", "put", "putIfAbsent", "remove", "replace"};
        CallMatcher.Simple simple = CallMatcher.instanceCall((String)"java.util.Map", (String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)simple, (String)"instanceCall(...)");
        this.mapKeyOperationMatcher = (CallMatcher)simple;
        stringArray = new String[]{"add", "contains", "equals", "remove"};
        CallMatcher.Simple simple2 = CallMatcher.instanceCall((String)"java.util.Set", (String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)simple2, (String)"instanceCall(...)");
        this.setOperationMatcher = (CallMatcher)simple2;
        stringArray = new String[]{"hashCode"};
        CallMatcher.Simple simple3 = CallMatcher.instanceCall((String)"java.net.URL", (String[])stringArray).parameterCount(0);
        Intrinsics.checkNotNullExpressionValue((Object)simple3, (String)"parameterCount(...)");
        this.hashCodeMatcher = (CallMatcher)simple3;
        stringArray = new String[]{"equals"};
        CallMatcher.Simple simple4 = CallMatcher.instanceCall((String)"java.net.URL", (String[])stringArray);
        stringArray = new String[]{"java.lang.Object"};
        CallMatcher callMatcher = simple4.parameterTypes(stringArray).withContextFilter(arg_0 -> UrlHashCodeInspection.equalsMatcher$lambda$1(UrlHashCodeInspection::equalsMatcher$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)callMatcher, (String)"withContextFilter(...)");
        this.equalsMatcher = callMatcher;
    }

    private final boolean isUrlType(UExpression $this$isUrlType) {
        PsiType psiType = $this$isUrlType.getExpressionType();
        return psiType != null ? psiType.equalsToText("java.net.URL") : false;
    }

    private final boolean isMapType(PsiClassType $this$isMapType) {
        return $this$isMapType.rawType().equalsToText("java.util.Map");
    }

    private final boolean isSetType(PsiClassType $this$isSetType) {
        return $this$isSetType.rawType().equalsToText("java.util.Set");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Language language = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Class[] classArray = new Class[]{UVariable.class, UCallExpression.class, UCallableReferenceExpression.class, UBinaryExpression.class};
        return UastHintedVisitorAdapter.Companion.create(language, (AbstractUastNonRecursiveVisitor)new UrlHashCodeVisitor(holder), classArray, true);
    }

    private static final boolean equalsMatcher$lambda$0(PsiElement it) {
        PsiElement $this$toUElementOfType$iv = it;
        boolean $i$f$toUElementOfType = false;
        UCallExpression uCallExpression = (UCallExpression)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UCallExpression.class);
        if (uCallExpression == null) {
            return true;
        }
        UCallExpression uCallExpression2 = uCallExpression;
        UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)uCallExpression2.getValueArguments());
        return uExpression != null ? !UastLiteralUtils.isNullLiteral((UElement)((UElement)uExpression)) : true;
    }

    private static final boolean equalsMatcher$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/codeInspection/performance/UrlHashCodeInspection$UrlHashCodeVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/performance/UrlHashCodeInspection;Lcom/intellij/codeInspection/ProblemsHolder;)V", "visitVariable", "", "node", "Lorg/jetbrains/uast/UVariable;", "findUrlCollection", "Lcom/intellij/psi/PsiClassType;", "type", "visitBinaryExpression", "Lorg/jetbrains/uast/UBinaryExpression;", "visitCallExpression", "Lorg/jetbrains/uast/UCallExpression;", "isUrlMapOrSetOperation", "visitCallableReferenceExpression", "Lorg/jetbrains/uast/UCallableReferenceExpression;", "intellij.jvm.analysis.impl"})
    @SourceDebugExtension(value={"SMAP\nUrlHashCodeInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlHashCodeInspection.kt\ncom/intellij/codeInspection/performance/UrlHashCodeInspection$UrlHashCodeVisitor\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,111:1\n19#2:112\n19#2:115\n1310#3,2:113\n*S KotlinDebug\n*F\n+ 1 UrlHashCodeInspection.kt\ncom/intellij/codeInspection/performance/UrlHashCodeInspection$UrlHashCodeVisitor\n*L\n54#1:112\n62#1:115\n62#1:113,2\n*E\n"})
    private final class UrlHashCodeVisitor
    extends AbstractUastNonRecursiveVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public UrlHashCodeVisitor(ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        public boolean visitVariable(@NotNull UVariable node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiType $this$asSafely$iv = node.getType();
            boolean $i$f$asSafely = false;
            PsiType psiType = $this$asSafely$iv;
            if (!(psiType instanceof PsiClassType)) {
                psiType = null;
            }
            PsiClassType psiClassType = (PsiClassType)psiType;
            if (psiClassType == null) {
                return true;
            }
            PsiClassType type = psiClassType;
            if (this.findUrlCollection(type) == null) {
                return true;
            }
            UDeclaration uDeclaration = (UDeclaration)node;
            Object[] objectArray = new Object[]{node.getName()};
            String string = JvmAnalysisBundle.message("jvm.inspections.collection.contains.url.problem.descriptor", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UDeclaration)uDeclaration, (String)string, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
            return true;
        }

        private final PsiClassType findUrlCollection(PsiClassType type) {
            PsiClassType psiClassType;
            Object object;
            block6: {
                if (UrlHashCodeInspection.this.isMapType(type) || UrlHashCodeInspection.this.isSetType(type)) {
                    PsiType[] psiTypeArray = type.getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"getParameters(...)");
                    PsiType psiType = (PsiType)ArraysKt.firstOrNull((Object[])psiTypeArray);
                    boolean bl = psiType != null ? psiType.equalsToText("java.net.URL") : false;
                    if (bl) {
                        return type;
                    }
                }
                PsiType[] psiTypeArray = type.getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"getParameters(...)");
                Object[] $this$firstOrNull$iv = psiTypeArray;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiType it = (PsiType)element$iv;
                    boolean bl = false;
                    if (!(it instanceof PsiClassType && this.findUrlCollection((PsiClassType)it) != null)) continue;
                    object = element$iv;
                    break block6;
                }
                object = null;
            }
            PsiType psiType = (PsiType)object;
            if (psiType != null) {
                PsiType $this$asSafely$iv = psiType;
                boolean $i$f$asSafely = false;
                PsiType psiType2 = $this$asSafely$iv;
                if (!(psiType2 instanceof PsiClassType)) {
                    psiType2 = null;
                }
                psiClassType = (PsiClassType)psiType2;
            } else {
                psiClassType = null;
            }
            return psiClassType;
        }

        public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (!UrlHashCodeInspection.this.isUrlType(node.getRightOperand()) && !UrlHashCodeInspection.this.isUrlType(node.getLeftOperand())) {
                return true;
            }
            UIdentifier uIdentifier = node.getOperatorIdentifier();
            if (!Intrinsics.areEqual((Object)(uIdentifier != null ? uIdentifier.getName() : null), (Object)"==")) {
                return true;
            }
            if (UastLiteralUtils.isNullLiteral((UElement)((UElement)node.getLeftOperand())) || UastLiteralUtils.isNullLiteral((UElement)((UElement)node.getRightOperand()))) {
                return true;
            }
            PsiMethod psiMethod = node.resolveOperator();
            if (psiMethod == null) {
                return true;
            }
            PsiMethod method = psiMethod;
            if (!Intrinsics.areEqual((Object)method.getName(), (Object)"equals")) {
                return true;
            }
            UIdentifier uIdentifier2 = node.getOperatorIdentifier();
            if (uIdentifier2 == null || (uIdentifier2 = uIdentifier2.getSourcePsi()) == null) {
                return true;
            }
            UIdentifier anchor = uIdentifier2;
            Object[] objectArray = new Object[]{method.getName() + "()"};
            this.holder.registerProblem((PsiElement)anchor, JvmAnalysisBundle.message("jvm.inspections.equals.hashcode.called.on.url.problem.descriptor", objectArray), new LocalQuickFix[0]);
            return true;
        }

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (UrlHashCodeInspection.this.hashCodeMatcher.uCallMatches(node) || UrlHashCodeInspection.this.equalsMatcher.uCallMatches(node)) {
                Object[] objectArray = new Object[]{node.getMethodName() + "()"};
                String string = JvmAnalysisBundle.message("jvm.inspections.equals.hashcode.called.on.url.problem.descriptor", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UCallExpression)node, (String)string, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
                return true;
            }
            if (this.isUrlMapOrSetOperation(node)) {
                String string;
                Object object = node.getReceiver();
                if (object == null || (object = object.getSourcePsi()) == null) {
                    UIdentifier uIdentifier = node.getMethodIdentifier();
                    object = uIdentifier != null ? uIdentifier.getSourcePsi() : null;
                    if (object == null) {
                        return true;
                    }
                }
                UExpression anchor = object;
                if (node.getReceiver() == null) {
                    string = "this";
                } else {
                    string = node.getReceiver();
                    if (string == null || (string = string.getSourcePsi()) == null || (string = string.getText()) == null) {
                        return true;
                    }
                }
                String name = string;
                Object[] objectArray = new Object[]{name};
                this.holder.registerProblem((PsiElement)anchor, JvmAnalysisBundle.message("jvm.inspections.collection.contains.url.problem.descriptor", objectArray), new LocalQuickFix[0]);
                return true;
            }
            return true;
        }

        private final boolean isUrlMapOrSetOperation(UCallExpression node) {
            if (!UrlHashCodeInspection.this.mapKeyOperationMatcher.uCallMatches(node) && !UrlHashCodeInspection.this.setOperationMatcher.uCallMatches(node)) {
                return false;
            }
            UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)node.getValueArguments());
            return uExpression != null ? UrlHashCodeInspection.this.isUrlType(uExpression) : false;
        }

        public boolean visitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (!UrlHashCodeInspection.this.hashCodeMatcher.uCallableReferenceMatches(node) && !UrlHashCodeInspection.this.equalsMatcher.uCallableReferenceMatches(node)) {
                return true;
            }
            UReferenceExpression uReferenceExpression = (UReferenceExpression)node;
            Object[] objectArray = new Object[]{node.getCallableName() + "()"};
            String string = JvmAnalysisBundle.message("jvm.inspections.equals.hashcode.called.on.url.problem.descriptor", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UReferenceExpression)uReferenceExpression, (String)string, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
            return true;
        }
    }
}

