/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.sceneBuilder;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SideBorder;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.plugins.javaFX.JavaFXBundle;
import org.jetbrains.plugins.javaFX.sceneBuilder.EditorCallback;
import org.jetbrains.plugins.javaFX.sceneBuilder.SceneBuilder;
import org.jetbrains.plugins.javaFX.sceneBuilder.SceneBuilderUtil;

public final class SceneBuilderEditor
extends UserDataHolderBase
implements FileEditor,
EditorCallback {
    private static final Logger LOG = Logger.getInstance(SceneBuilderEditor.class);
    private static final String SCENE_CARD = "scene_builder";
    private static final String ERROR_CARD = "error";
    private final Project myProject;
    private final VirtualFile myFile;
    private final CardLayout myLayout;
    private final JPanel myPanel;
    private final JPanel myErrorPanel;
    private final EditorNotificationPanel myErrorNotification;
    private JTextArea myErrorStack;
    private final Document myDocument;
    private final ExternalChangeListener myChangeListener;
    private SceneBuilder mySceneBuilder;
    private NonOpaquePanel myWrapper;

    public SceneBuilderEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            SceneBuilderEditor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            SceneBuilderEditor.$$$reportNull$$$0(1);
        }
        this.myLayout = new CardLayout();
        this.myPanel = new JPanel(this.myLayout);
        this.myErrorPanel = new JPanel(new BorderLayout());
        this.myErrorNotification = new EditorNotificationPanel(EditorNotificationPanel.Status.Error);
        this.myProject = project;
        this.myFile = file;
        this.myDocument = FileDocumentManager.getInstance().getDocument(file);
        this.myChangeListener = new ExternalChangeListener();
        this.createErrorPage();
    }

    private void createErrorPage() {
        this.myErrorStack = new JTextArea(1, 20);
        this.myErrorStack.setBorder((Border)JBUI.Borders.empty((int)12, (int)20));
        this.myErrorStack.setEditable(false);
        this.myWrapper = new NonOpaquePanel((JComponent)this.myErrorNotification);
        this.myWrapper.setBorder((Border)new SideBorder(JBUI.CurrentTheme.Banner.ERROR_BORDER_COLOR, 8));
        this.myWrapper.setVisible(false);
        this.myErrorPanel.add((Component)this.myWrapper, "North");
        this.myErrorPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myErrorStack), "Center");
        this.myPanel.add(this.myErrorPanel);
    }

    private void showErrorPage(Throwable e) {
        Object description;
        if (e != null) {
            LOG.info(e);
        }
        this.removeSceneBuilder();
        this.myWrapper.setVisible(true);
        this.myErrorNotification.clear();
        this.myErrorStack.setText("");
        if (JavaVersion.current().feature > 11 && e instanceof NoClassDefFoundError && !SceneBuilderUtil.getSceneBuilder11Path().toFile().isFile()) {
            this.myErrorNotification.setText(JavaFXBundle.message("javafx.scene.builder.editor.failed.to.open.file.error", new Object[0]));
            this.myErrorNotification.createActionLabel(JavaFXBundle.message("javafx.scene.builder.editor.download.scene.builder.kit", new Object[0]), () -> {
                DownloadableFileService service = DownloadableFileService.getInstance();
                DownloadableFileDescription description = service.createFileDescription("https://cache-redirector.jetbrains.com/intellij-dependencies/org/jetbrains/intellij/deps/scenebuilderkit/11.0.6/scenebuilderkit-11.0.6.jar", "scenebuilderkit-11.0.6.jar");
                FileDownloader downloader = service.createDownloader(Collections.singletonList(description), "Scene Builder Kit");
                try {
                    Path tempDir = Files.createTempDirectory("", new FileAttribute[0]);
                    List list = downloader.downloadWithProgress(tempDir.toString(), this.myProject, (JComponent)this.myErrorPanel);
                    if (list == null || list.isEmpty()) {
                        this.myErrorNotification.clear();
                        this.myErrorNotification.setText(JavaFXBundle.message("javafx.scene.builder.editor.failed.to.download.kit.error", new Object[0]));
                        return;
                    }
                    FileUtil.copy((File)VfsUtilCore.virtualToIoFile((VirtualFile)((VirtualFile)((Pair)list.get((int)0)).first)), (File)SceneBuilderUtil.getSceneBuilder11Path().toFile());
                    FileUtil.delete((File)tempDir.toFile());
                    SceneBuilderUtil.updateLoader();
                    this.updateState();
                }
                catch (IOException e2) {
                    LOG.warn("Can't download SceneBuilderKit", (Throwable)e2);
                }
            });
            this.myLayout.show(this.myPanel, ERROR_CARD);
            return;
        }
        if (JavaVersion.current().feature > 11) {
            try {
                Class.forName("javafx.scene.Node");
            }
            catch (ClassNotFoundException exception) {
                this.myErrorNotification.clear();
                this.myErrorNotification.setText(JavaFXBundle.message("javafx.scene.builder.editor.failed.to.open.file.error", new Object[0]));
                this.myErrorNotification.createActionLabel(JavaFXBundle.message("javafx.scene.builder.editor.download.javafx", new Object[0]), () -> this.downloadJavaFxDependencies());
                this.myLayout.show(this.myPanel, ERROR_CARD);
                return;
            }
        }
        if (e != null) {
            ArrayList<String> messages = new ArrayList<String>();
            for (Throwable t = e; t != null && t != t.getCause(); t = t.getCause()) {
                String message = SceneBuilderEditor.getErrorMessage(t);
                if (messages.isEmpty() || !((String)messages.get(messages.size() - 1)).contains(message)) {
                    messages.add(message);
                    continue;
                }
                messages.set(messages.size() - 1, message);
            }
            Collections.reverse(messages);
            description = "\n" + String.join((CharSequence)"\n\n", messages);
        } else {
            description = "Unknown error occurred";
        }
        this.myErrorNotification.setText(JavaFXBundle.message("javafx.scene.builder.editor.failed.to.open.file.error", new Object[0]));
        this.myErrorStack.setText((String)description);
        this.myErrorStack.setRows(((String)description).split("\n").length);
        this.myLayout.show(this.myPanel, ERROR_CARD);
    }

    private void downloadJavaFxDependencies() {
        for (String coordinate : SceneBuilderUtil.JAVAFX_ARTIFACTS) {
            RepositoryLibraryProperties libraryProperties = new RepositoryLibraryProperties("org.openjfx:" + coordinate + ":17.0.12", true);
            JarRepositoryManager.loadDependenciesModal((Project)this.myProject, (RepositoryLibraryProperties)libraryProperties, (boolean)false, (boolean)false, null, null);
        }
        SceneBuilderUtil.updateLoader();
        this.updateState();
    }

    private static String getErrorMessage(Throwable e) {
        String message = e.getMessage();
        String className = e.getClass().getName();
        if (StringUtil.isEmpty((String)message)) {
            if (e instanceof ClassNotFoundException) {
                return className + ": Unresolved import";
            }
            return className;
        }
        if (!message.contains(className)) {
            return className + ": " + message;
        }
        return message;
    }

    @Override
    public void saveChanges(String content) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.mySceneBuilder != null) {
                if (!this.myDocument.isWritable() && ReadonlyStatusHandler.getInstance((Project)this.myProject).ensureFilesWritable(Collections.singletonList(this.myFile)).hasReadonlyFiles()) {
                    return;
                }
                try {
                    this.myChangeListener.setRunState(false);
                    ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(this.myProject, () -> this.myDocument.setText((CharSequence)content), JavaFXBundle.message("javafx.scene.builder.editor.scene.builder.edit.operation", new Object[0]), null));
                }
                finally {
                    this.myChangeListener.setRunState(true);
                }
            }
        });
    }

    @Override
    public void handleError(Throwable e) {
        UIUtil.invokeLaterIfNeeded(() -> this.showErrorPage(e));
    }

    private void updateState() {
        this.addSceneBuilder();
    }

    private void addSceneBuilder() {
        ApplicationManager.getApplication().invokeLater(this::addSceneBuilderImpl, ModalityState.defaultModalityState());
    }

    private void addSceneBuilderImpl() {
        try {
            ApplicationManager.getApplication().runWriteAction(() -> FileDocumentManager.getInstance().saveDocument(this.myDocument));
            if (this.mySceneBuilder != null && this.mySceneBuilder.reload()) {
                return;
            }
            this.removeSceneBuilder();
            this.mySceneBuilder = SceneBuilderUtil.create(new File(this.myFile.getPath()).toURI().toURL(), this.myProject, this);
            this.myPanel.add((Component)this.mySceneBuilder.getPanel(), SCENE_CARD);
            this.myLayout.show(this.myPanel, SCENE_CARD);
            this.myChangeListener.start();
        }
        catch (Throwable e) {
            this.showErrorPage(e);
        }
    }

    private void removeSceneBuilder() {
        this.myChangeListener.stop();
        if (this.mySceneBuilder != null) {
            this.myPanel.remove(this.mySceneBuilder.getPanel());
            this.mySceneBuilder.close();
            this.mySceneBuilder = null;
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            SceneBuilderEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mySceneBuilder == null ? this.myErrorPanel : this.mySceneBuilder.getPanel();
    }

    public void dispose() {
        this.removeSceneBuilder();
        this.myChangeListener.dispose();
    }

    @NotNull
    public String getName() {
        String string = JavaFXBundle.message("scene.builder.editor.tab.name", new Object[0]);
        if (string == null) {
            SceneBuilderEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void selectNotify() {
        this.updateState();
    }

    public void deselectNotify() {
        this.myChangeListener.stop();
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            SceneBuilderEditor.$$$reportNull$$$0(4);
        }
    }

    public boolean isValid() {
        return this.myFile.isValid();
    }

    public boolean isModified() {
        return false;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            SceneBuilderEditor.$$$reportNull$$$0(5);
        }
        return virtualFile;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            SceneBuilderEditor.$$$reportNull$$$0(6);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            SceneBuilderEditor.$$$reportNull$$$0(7);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5 -> new IllegalStateException(string);
        };
    }

    private final class ExternalChangeListener
    implements DocumentListener {
        private volatile boolean myRunState;

        ExternalChangeListener() {
            SceneBuilderEditor.this.myDocument.addDocumentListener((DocumentListener)this);
        }

        public void start() {
            if (!this.myRunState) {
                this.myRunState = true;
            }
        }

        public void stop() {
            if (this.myRunState) {
                this.myRunState = false;
            }
        }

        public void setRunState(boolean state) {
            this.myRunState = state;
        }

        public void dispose() {
            SceneBuilderEditor.this.myDocument.removeDocumentListener((DocumentListener)this);
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                ExternalChangeListener.$$$reportNull$$$0(0);
            }
            if (this.myRunState) {
                SceneBuilderEditor.this.addSceneBuilder();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditor$ExternalChangeListener", "documentChanged"));
        }
    }
}

