/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.fs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.FileCollectionFactory;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.Utils;

@ApiStatus.Internal
public final class FilesDelta {
    private static final Logger LOG = Logger.getInstance(FilesDelta.class);
    private final ReentrantLock myDataLock = new ReentrantLock();
    private final Set<String> myDeletedPaths = CollectionFactory.createFilePathLinkedSet();
    private final Map<BuildRootDescriptor, Set<File>> myFilesToRecompile = new LinkedHashMap<BuildRootDescriptor, Set<File>>();

    public void lockData() {
        this.myDataLock.lock();
    }

    public void unlockData() {
        this.myDataLock.unlock();
    }

    public FilesDelta() {
    }

    FilesDelta(Collection<FilesDelta> deltas) {
        for (FilesDelta delta : deltas) {
            this.addAll(delta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAll(FilesDelta other) {
        other.lockData();
        try {
            this.myDeletedPaths.addAll(other.myDeletedPaths);
            for (Map.Entry<BuildRootDescriptor, Set<File>> entry : other.myFilesToRecompile.entrySet()) {
                this._addToRecompiled(entry.getKey(), (Collection<? extends File>)entry.getValue());
            }
        }
        finally {
            other.unlockData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(DataOutput out) throws IOException {
        this.lockData();
        try {
            out.writeInt(this.myDeletedPaths.size());
            for (String string : this.myDeletedPaths) {
                IOUtil.writeString((String)string, (DataOutput)out);
            }
            out.writeInt(this.myFilesToRecompile.size());
            for (Map.Entry entry : this.myFilesToRecompile.entrySet()) {
                IOUtil.writeString((String)((BuildRootDescriptor)entry.getKey()).getRootId(), (DataOutput)out);
                Set files = (Set)entry.getValue();
                out.writeInt(files.size());
                for (File file : files) {
                    IOUtil.writeString((String)FileUtil.toSystemIndependentName((String)file.getPath()), (DataOutput)out);
                }
            }
        }
        finally {
            this.unlockData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(DataInput in, @NotNull BuildTarget<?> target, BuildRootIndex buildRootIndex) throws IOException {
        if (target == null) {
            FilesDelta.$$$reportNull$$$0(0);
        }
        this.lockData();
        try {
            this.myDeletedPaths.clear();
            int deletedCount = in.readInt();
            while (deletedCount-- > 0) {
                this.myDeletedPaths.add(IOUtil.readString((DataInput)in));
            }
            this.myFilesToRecompile.clear();
            int recompileCount = in.readInt();
            while (recompileCount-- > 0) {
                Set files;
                String rootId = IOUtil.readString((DataInput)in);
                Object descriptor = target.findRootDescriptor(rootId, buildRootIndex);
                if (descriptor != null) {
                    files = this.myFilesToRecompile.get(descriptor);
                    if (files == null) {
                        files = FileCollectionFactory.createCanonicalFileLinkedSet();
                        this.myFilesToRecompile.put((BuildRootDescriptor)descriptor, files);
                    }
                } else {
                    LOG.debug("Cannot find root by " + rootId + ", delta will be skipped");
                    files = FileCollectionFactory.createCanonicalFileLinkedSet();
                }
                int filesCount = in.readInt();
                while (filesCount-- > 0) {
                    File file = new File(IOUtil.readString((DataInput)in));
                    if (Utils.IS_TEST_MODE) {
                        LOG.info("Loaded " + file.getPath());
                    }
                    files.add(file);
                }
            }
        }
        finally {
            this.unlockData();
        }
    }

    public static void skip(DataInput in) throws IOException {
        int deletedCount = in.readInt();
        while (deletedCount-- > 0) {
            IOUtil.readString((DataInput)in);
        }
        int recompiledCount = in.readInt();
        while (recompiledCount-- > 0) {
            IOUtil.readString((DataInput)in);
            int filesCount = in.readInt();
            while (filesCount-- > 0) {
                IOUtil.readString((DataInput)in);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChanges() {
        this.lockData();
        try {
            if (!this.myDeletedPaths.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            if (!this.myFilesToRecompile.isEmpty()) {
                for (Set<File> files : this.myFilesToRecompile.values()) {
                    if (files.isEmpty()) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlockData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markRecompile(BuildRootDescriptor root, File file) {
        this.lockData();
        try {
            boolean added = this._addToRecompiled(root, file);
            if (added && !this.myDeletedPaths.isEmpty()) {
                this.myDeletedPaths.remove(FileUtil.toCanonicalPath((String)file.getPath()));
            }
            boolean bl = added;
            return bl;
        }
        finally {
            this.unlockData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markRecompileIfNotDeleted(BuildRootDescriptor root, File file) {
        this.lockData();
        try {
            boolean isMarkedDeleted;
            String path = null;
            boolean bl = isMarkedDeleted = !this.myDeletedPaths.isEmpty() && this.myDeletedPaths.contains(path = FileUtil.toCanonicalPath((String)file.getPath()));
            if (!isMarkedDeleted) {
                if (!file.exists()) {
                    if (path == null) {
                        path = FileUtil.toCanonicalPath((String)file.getPath());
                    }
                    if (Utils.IS_TEST_MODE) {
                        LOG.info("Marking deleted: " + path);
                    }
                    this.myDeletedPaths.add(path);
                    boolean bl2 = false;
                    return bl2;
                }
                this._addToRecompiled(root, file);
                boolean bl3 = true;
                return bl3;
            }
            boolean bl4 = false;
            return bl4;
        }
        finally {
            this.unlockData();
        }
    }

    private boolean _addToRecompiled(BuildRootDescriptor root, File file) {
        if (Utils.IS_TEST_MODE) {
            LOG.info("Marking dirty: " + file.getPath());
        }
        return this._addToRecompiled(root, Collections.singleton(file));
    }

    private boolean _addToRecompiled(BuildRootDescriptor root, Collection<? extends File> filesToAdd) {
        Set files = this.myFilesToRecompile.get(root);
        if (files == null) {
            files = FileCollectionFactory.createCanonicalFileLinkedSet();
            this.myFilesToRecompile.put(root, files);
        }
        return files.addAll(filesToAdd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeleted(File file) {
        String path = FileUtil.toCanonicalPath((String)file.getPath());
        this.lockData();
        try {
            for (Set<File> files : this.myFilesToRecompile.values()) {
                files.remove(file);
            }
            this.myDeletedPaths.add(path);
            if (Utils.IS_TEST_MODE) {
                LOG.info("Marking deleted: " + path);
            }
        }
        finally {
            this.unlockData();
        }
    }

    public void clearDeletedPaths() {
        this.lockData();
        try {
            this.myDeletedPaths.clear();
        }
        finally {
            this.unlockData();
        }
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public Set<String> getAndClearDeletedPaths() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    public Map<BuildRootDescriptor, Set<File>> getSourcesToRecompile() {
        LOG.assertTrue(this.myDataLock.isHeldByCurrentThread(), (Object)"FilesDelta data must be locked by querying thread");
        Map<BuildRootDescriptor, Set<File>> map = this.myFilesToRecompile;
        if (map == null) {
            FilesDelta.$$$reportNull$$$0(3);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMarkedRecompile(BuildRootDescriptor rd, File file) {
        this.lockData();
        try {
            Set<File> files = this.myFilesToRecompile.get(rd);
            boolean bl = files != null && files.contains(file);
            return bl;
        }
        finally {
            this.unlockData();
        }
    }

    @Nullable
    public Set<File> clearRecompile(BuildRootDescriptor root) {
        this.lockData();
        try {
            Set<File> set = this.myFilesToRecompile.remove(root);
            return set;
        }
        finally {
            this.unlockData();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/fs/FilesDelta";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/fs/FilesDelta";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndClearDeletedPaths";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourcesToRecompile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

