/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml.behavior;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.xml.XmlPsiPolicy;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class DefaultXmlPsiPolicy
implements XmlPsiPolicy {
    private static final Logger LOG = Logger.getInstance(DefaultXmlPsiPolicy.class);

    @Override
    public ASTNode encodeXmlTextContents(String displayText, PsiElement text2) {
        if (displayText.isEmpty()) {
            return null;
        }
        CharTable charTable = SharedImplUtil.findCharTableByTree((ASTNode)text2.getNode());
        FileElement dummyParent = DummyHolderFactory.createHolder((PsiManager)text2.getManager(), null, (CharTable)charTable).getTreeElement();
        XmlTag rootTag = ((XmlFile)PsiFileFactory.getInstance((Project)text2.getProject()).createFileFromText("a.xml", text2.getLanguage(), (CharSequence)this.buildTagForText(text2, displayText), false, true)).getRootTag();
        assert (rootTag != null);
        XmlTagChild[] tagChildren = rootTag.getValue().getChildren();
        XmlTagChild child = tagChildren.length > 0 ? tagChildren[0] : null;
        LOG.assertTrue(child != null, (Object)("Child is null for tag: " + rootTag.getText()));
        TreeElement element = (TreeElement)child.getNode();
        DebugUtil.performPsiModification((String)this.getClass().getName(), () -> {
            ((TreeElement)tagChildren[tagChildren.length - 1].getNode().getTreeNext()).rawRemoveUpToLast();
            dummyParent.rawAddChildren(element);
        });
        TreeUtil.clearCaches((TreeElement)dummyParent);
        return element.getFirstChildNode();
    }

    @NotNull
    protected String buildTagForText(PsiElement text2, String displayText) {
        String string2 = "<a>" + displayText + "</a>";
        if (string2 == null) {
            DefaultXmlPsiPolicy.$$$reportNull$$$0(0);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/behavior/DefaultXmlPsiPolicy", "buildTagForText"));
    }
}

