/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNamedElementWithCustomPresentation;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import icons.SpellcheckerIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RenameTo
extends PsiUpdateModCommandQuickFix
implements Iconable {
    @NotNull
    public String getFamilyName() {
        String string2 = RenameTo.getFixName();
        if (string2 == null) {
            RenameTo.$$$reportNull$$$0(0);
        }
        return string2;
    }

    protected void applyFix(@NotNull Project project2, @NotNull PsiElement psiElement, @NotNull ModPsiUpdater updater) {
        String name;
        PsiNamedElement named;
        if (project2 == null) {
            RenameTo.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            RenameTo.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            RenameTo.$$$reportNull$$$0(3);
        }
        if ((named = (PsiNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{PsiNamedElement.class})) == null) {
            return;
        }
        if (named instanceof PsiNamedElementWithCustomPresentation) {
            PsiNamedElementWithCustomPresentation custom = (PsiNamedElementWithCustomPresentation)named;
            v0 = custom.getPresentationName();
        } else {
            v0 = name = named.getName();
        }
        if (name == null) {
            return;
        }
        List<String> names = SpellCheckerManager.getInstance(project2).getSuggestions(name).stream().filter(suggestion -> RenameUtil.isValidName((Project)project2, (PsiElement)psiElement, (String)suggestion)).toList();
        updater.rename(named, psiElement, names);
    }

    @Nls
    public static String getFixName() {
        return SpellCheckerBundle.message("rename.to", new Object[0]);
    }

    public Icon getIcon(int flags) {
        return SpellcheckerIcons.Spellcheck;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/quickfixes/RenameTo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/quickfixes/RenameTo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3 -> new IllegalArgumentException(string2);
        };
    }
}

