/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.search;

import com.intellij.codeWithMe.ClientId;
import com.intellij.find.usages.api.PsiUsage;
import com.intellij.model.psi.PsiExternalReferenceHost;
import com.intellij.model.psi.PsiSymbolReferenceHints;
import com.intellij.model.psi.PsiSymbolReferenceService;
import com.intellij.model.search.LeafOccurrence;
import com.intellij.model.search.LeafOccurrenceMapper;
import com.intellij.model.search.SearchContext;
import com.intellij.model.search.SearchService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.Query;
import com.intellij.webSymbols.PsiSourcedWebSymbol;
import com.intellij.webSymbols.WebSymbol;
import com.intellij.webSymbols.declarations.WebSymbolDeclaration;
import com.intellij.webSymbols.declarations.WebSymbolDeclarationProvider;
import com.intellij.webSymbols.query.WebSymbolNamesProvider;
import com.intellij.webSymbols.query.WebSymbolsQueryExecutor;
import com.intellij.webSymbols.query.WebSymbolsQueryExecutorFactory;
import com.intellij.webSymbols.references.WebSymbolReference;
import com.intellij.webSymbols.search.WebSymbolPsiUsage;
import com.intellij.webSymbols.search.WebSymbolUsageQueries$findReferencesToSymbol$lambda$12$;
import com.intellij.webSymbols.utils.WebSymbolUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u0004\u001a\"\u0012\u001e\u0012\u001c\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\n0\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/webSymbols/search/WebSymbolUsageQueries;", "", "<init>", "()V", "buildWebSymbolUsagesQueries", "", "Lcom/intellij/util/Query;", "Lcom/intellij/find/usages/api/PsiUsage;", "kotlin.jvm.PlatformType", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/annotations/NotNull;", "symbol", "Lcom/intellij/webSymbols/WebSymbol;", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "findReferencesToSymbol", "", "leafOccurrence", "Lcom/intellij/model/search/LeafOccurrence;", "intellij.platform.webSymbols"})
@SourceDebugExtension(value={"SMAP\nWebSymbolsUsageSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSymbolsUsageSearcher.kt\ncom/intellij/webSymbols/search/WebSymbolUsageQueries\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,112:1\n1#2:113\n40#3,3:114\n774#4:117\n865#4,2:118\n1557#4:120\n1628#4,3:121\n477#5:124\n*S KotlinDebug\n*F\n+ 1 WebSymbolsUsageSearcher.kt\ncom/intellij/webSymbols/search/WebSymbolUsageQueries\n*L\n63#1:114,3\n77#1:117\n77#1:118,2\n78#1:120\n78#1:121,3\n87#1:124\n*E\n"})
public final class WebSymbolUsageQueries {
    @NotNull
    public static final WebSymbolUsageQueries INSTANCE = new WebSymbolUsageQueries();

    private WebSymbolUsageQueries() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final List<Query<? extends PsiUsage>> buildWebSymbolUsagesQueries(@NotNull WebSymbol symbol, @NotNull Project project2, @NotNull SearchScope searchScope) {
        Sequence sequence;
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        PsiElement psiElement = symbol.getPsiContext();
        if (psiElement != null) {
            Sequence sequence2;
            List<String> list2;
            WebSymbolNamesProvider webSymbolNamesProvider;
            PsiElement it = psiElement;
            boolean bl = false;
            WebSymbolsQueryExecutor webSymbolsQueryExecutor = WebSymbolsQueryExecutorFactory.Companion.create(it, true);
            if (webSymbolsQueryExecutor != null && (webSymbolNamesProvider = webSymbolsQueryExecutor.getNamesProvider()) != null && (list2 = webSymbolNamesProvider.getNames(WebSymbolUtils.getQualifiedName(symbol), WebSymbolNamesProvider.Target.NAMES_QUERY)) != null && (sequence2 = CollectionsKt.asSequence((Iterable)list2)) != null) {
                sequence = sequence2;
                return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)sequence, WebSymbolUsageQueries::buildWebSymbolUsagesQueries$lambda$1)), arg_0 -> WebSymbolUsageQueries.buildWebSymbolUsagesQueries$lambda$3(project2, searchScope, symbol, arg_0)));
            }
        }
        Object[] objectArray = new String[]{symbol.getName()};
        sequence = SequencesKt.sequenceOf((Object[])objectArray);
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)sequence, WebSymbolUsageQueries::buildWebSymbolUsagesQueries$lambda$1)), arg_0 -> WebSymbolUsageQueries.buildWebSymbolUsagesQueries$lambda$3(project2, searchScope, symbol, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<PsiUsage> findReferencesToSymbol(WebSymbol symbol, LeafOccurrence leafOccurrence) {
        boolean $i$f$service = false;
        Class<PsiSymbolReferenceService> serviceClass$iv = PsiSymbolReferenceService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        PsiSymbolReferenceService $this$findReferencesToSymbol_u24lambda_u2412 = (PsiSymbolReferenceService)object;
        boolean bl = false;
        Iterator iterator = PsiTreeUtilKt.walkUp((PsiElement)leafOccurrence.getStart(), (int)leafOccurrence.getOffsetInStart(), (PsiElement)leafOccurrence.getScope());
        while (iterator.hasNext()) {
            PsiElement psiSource;
            Pair pair = (Pair)iterator.next();
            PsiElement element = (PsiElement)pair.component1();
            int offsetInElement = ((Number)pair.component2()).intValue();
            PsiSourcedWebSymbol psiSourcedWebSymbol = symbol instanceof PsiSourcedWebSymbol ? (PsiSourcedWebSymbol)symbol : null;
            Object object2 = psiSource = psiSourcedWebSymbol != null ? psiSourcedWebSymbol.getSource() : null;
            if (Intrinsics.areEqual((Object)psiSource, (Object)element)) {
                PsiElement nameIdentifier;
                PsiNameIdentifierOwner psiNameIdentifierOwner = element instanceof PsiNameIdentifierOwner ? (PsiNameIdentifierOwner)element : null;
                Object object3 = nameIdentifier = psiNameIdentifierOwner != null ? psiNameIdentifierOwner.getNameIdentifier() : null;
                if (nameIdentifier != null) {
                    PsiFile psiFile = ((PsiNameIdentifierOwner)element).getContainingFile();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                    TextRange textRange = nameIdentifier.getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                    return CollectionsKt.listOf((Object)new WebSymbolPsiUsage(psiFile, textRange, true));
                }
            }
            if (element instanceof PsiExternalReferenceHost) {
                void $this$filterIsInstance$iv;
                Collection<WebSymbolDeclaration> declarations = WebSymbolDeclarationProvider.Companion.getAllDeclarations(element, offsetInElement);
                if (!declarations.isEmpty()) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    WebSymbolDeclaration it;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    Iterable iterable = declarations;
                    boolean $i$f$filter = false;
                    void var14_16 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it = (WebSymbolDeclaration)element$iv$iv;
                        boolean bl2 = false;
                        if (!it.getSymbol().isEquivalentTo(symbol)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it = (WebSymbolDeclaration)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        PsiFile psiFile = it.getDeclaringElement().getContainingFile();
                        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                        TextRange textRange = it.getRangeInDeclaringElement();
                        PsiElement psiElement = it.getDeclaringElement();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getDeclaringElement(...)");
                        TextRange textRange2 = textRange.shiftRight(PsiTreeUtilKt.getStartOffset((PsiElement)psiElement));
                        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"shiftRight(...)");
                        collection.add(new WebSymbolPsiUsage(psiFile, textRange2, true));
                    }
                    return (List)destination$iv$iv;
                }
                Collection collection = $this$findReferencesToSymbol_u24lambda_u2412.getReferences(element, PsiSymbolReferenceHints.offsetHint((int)offsetInElement));
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getReferences(...)");
                Sequence $i$f$map = CollectionsKt.asSequence((Iterable)collection);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findReferencesToSymbol$lambda$12$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                List foundReferences = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)sequence, arg_0 -> WebSymbolUsageQueries.findReferencesToSymbol$lambda$12$lambda$6(offsetInElement, arg_0)), arg_0 -> WebSymbolUsageQueries.findReferencesToSymbol$lambda$12$lambda$7(symbol, arg_0)), WebSymbolUsageQueries::findReferencesToSymbol$lambda$12$lambda$8));
                if (!((Collection)foundReferences).isEmpty()) {
                    return foundReferences;
                }
            }
            if (psiSource == null) continue;
            PsiReference[] psiReferenceArray = element.getReferences();
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
            List foundReferences = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])psiReferenceArray), arg_0 -> WebSymbolUsageQueries.findReferencesToSymbol$lambda$12$lambda$9(offsetInElement, arg_0)), arg_0 -> WebSymbolUsageQueries.findReferencesToSymbol$lambda$12$lambda$10(psiSource, arg_0)), WebSymbolUsageQueries::findReferencesToSymbol$lambda$12$lambda$11));
            if (!(!((Collection)foundReferences).isEmpty())) continue;
            return foundReferences;
        }
        return CollectionsKt.emptyList();
    }

    private static final String buildWebSymbolUsagesQueries$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string2 = it;
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return string3;
    }

    private static final Collection buildWebSymbolUsagesQueries$lambda$3$lambda$2(Function2 $tmp0, Object p0, LeafOccurrence p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        return (Collection)$tmp0.invoke(p0, (Object)p1);
    }

    private static final Query buildWebSymbolUsagesQueries$lambda$3(Project $project, SearchScope $searchScope, WebSymbol $symbol, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SearchContext[] searchContextArray = new SearchContext[]{SearchContext.IN_CODE, SearchContext.IN_PLAIN_TEXT, SearchContext.IN_STRINGS};
        return SearchService.getInstance().searchWord($project, it).caseSensitive(false).inContexts(SearchContext.IN_CODE_HOSTS, searchContextArray).includeInjections().inScope($searchScope).buildQuery(LeafOccurrenceMapper.withPointer($symbol.createPointer(), (arg_0, arg_1) -> WebSymbolUsageQueries.buildWebSymbolUsagesQueries$lambda$3$lambda$2((Function2)new Function2<WebSymbol, LeafOccurrence, Collection<? extends PsiUsage>>((Object)INSTANCE){

            public final Collection<PsiUsage> invoke(WebSymbol p0, LeafOccurrence p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return WebSymbolUsageQueries.access$findReferencesToSymbol((WebSymbolUsageQueries)this.receiver, p0, p1);
            }
        }, arg_0, arg_1)));
    }

    private static final boolean findReferencesToSymbol$lambda$12$lambda$6(int $offsetInElement, WebSymbolReference it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getRangeInElement().containsOffset($offsetInElement);
    }

    private static final boolean findReferencesToSymbol$lambda$12$lambda$7(WebSymbol $symbol, WebSymbolReference ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        return ref.resolvesTo($symbol);
    }

    private static final WebSymbolPsiUsage findReferencesToSymbol$lambda$12$lambda$8(WebSymbolReference it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiFile psiFile = it.getElement().getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        TextRange textRange = it.getAbsoluteRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getAbsoluteRange(...)");
        return new WebSymbolPsiUsage(psiFile, textRange, false);
    }

    private static final boolean findReferencesToSymbol$lambda$12$lambda$9(int $offsetInElement, PsiReference it) {
        return it.getRangeInElement().containsOffset($offsetInElement);
    }

    private static final boolean findReferencesToSymbol$lambda$12$lambda$10(PsiElement $psiSource, PsiReference it) {
        return it.isReferenceTo($psiSource);
    }

    private static final WebSymbolPsiUsage findReferencesToSymbol$lambda$12$lambda$11(PsiReference it) {
        PsiFile psiFile = it.getElement().getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        TextRange textRange = it.getAbsoluteRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getAbsoluteRange(...)");
        return new WebSymbolPsiUsage(psiFile, textRange, false);
    }

    public static final /* synthetic */ Collection access$findReferencesToSymbol(WebSymbolUsageQueries $this, WebSymbol symbol, LeafOccurrence leafOccurrence) {
        return $this.findReferencesToSymbol(symbol, leafOccurrence);
    }
}

