/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.python;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.api.BuildFileProvider;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.model.LibraryDependency;
import com.intellij.packageChecker.python.PyPIProjectDependenciesModel;
import com.intellij.packageChecker.python.PythonLibraryDependency;
import com.intellij.packageChecker.python.RequirementsTxtBuildFileProvider;
import com.intellij.packageChecker.service.PackageCheckerDisposable;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.common.PythonPackage;
import com.jetbrains.python.packaging.common.PythonPackageManagementListener;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/intellij/packageChecker/python/RequirementsTxtDependenciesModel;", "Lcom/intellij/packageChecker/python/PyPIProjectDependenciesModel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "buildFileName", "", "getBuildFileName", "()Ljava/lang/String;", "findBuildFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/intellij/openapi/module/Module;", "getBuildFileSpecificRequirements", "", "Lcom/jetbrains/python/packaging/PyRequirement;", "supports", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "declaredDependencies", "Lcom/intellij/packageChecker/api/PackageDeclaration;", "libraryDependencies", "Lcom/intellij/packageChecker/model/LibraryDependency;", "findCorrespondingBuildFileProvider", "Lcom/intellij/packageChecker/python/RequirementsTxtBuildFileProvider;", "intellij.packageChecker.python"})
@SourceDebugExtension(value={"SMAP\nRequirementsTxtDependenciesModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequirementsTxtDependenciesModel.kt\ncom/intellij/packageChecker/python/RequirementsTxtDependenciesModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1557#2:62\n1628#2,3:63\n*S KotlinDebug\n*F\n+ 1 RequirementsTxtDependenciesModel.kt\ncom/intellij/packageChecker/python/RequirementsTxtDependenciesModel\n*L\n53#1:62\n53#1:63,3\n*E\n"})
public final class RequirementsTxtDependenciesModel
extends PyPIProjectDependenciesModel {
    @NotNull
    private final Project project;
    @NotNull
    private final String buildFileName;

    public RequirementsTxtDependenciesModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.project = project;
        Disposer.register((Disposable)PackageCheckerDisposable.Companion.getInstance(this.project), (Disposable)this);
        this.project.getMessageBus().connect((Disposable)this).subscribe(PythonPackageManager.Companion.getPACKAGE_MANAGEMENT_TOPIC(), (Object)new PythonPackageManagementListener(){

            public void packagesChanged(Sdk sdk) {
                Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
                this.refresh(project);
            }
        });
        this.buildFileName = "requirements.txt";
    }

    @Override
    @NotNull
    public String getBuildFileName() {
        return this.buildFileName;
    }

    @Override
    @Nullable
    public VirtualFile findBuildFile(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return PyPackageUtil.findRequirementsTxt((Module)module);
    }

    @Override
    @NotNull
    public List<PyRequirement> getBuildFileSpecificRequirements(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        List list = (List)ReadAction.compute(() -> RequirementsTxtDependenciesModel.getBuildFileSpecificRequirements$lambda$0(module));
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public boolean supports(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return this.findCorrespondingBuildFileProvider().supports(psiFile);
    }

    @Override
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.findCorrespondingBuildFileProvider().supports(module);
    }

    @Override
    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return this.findCorrespondingBuildFileProvider().declaredDependencies(psiFile);
    }

    @Override
    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.findCorrespondingBuildFileProvider().declaredDependencies(module);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<LibraryDependency> libraryDependencies(@NotNull Module module) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Sdk sdk = PythonSdkUtil.findPythonSdk((Module)module);
        if (sdk == null) {
            return CollectionsKt.emptyList();
        }
        Sdk sdk2 = sdk;
        Iterable $this$map$iv = PythonPackageManager.Companion.forSdk(project2, sdk2).getInstalledPackages();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PythonPackage pythonPackage = (PythonPackage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PythonLibraryDependency((PythonPackage)it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public RequirementsTxtBuildFileProvider findCorrespondingBuildFileProvider() {
        return (RequirementsTxtBuildFileProvider)BuildFileProvider.Companion.getEP_NAME().findExtensionOrFail(RequirementsTxtBuildFileProvider.class, (AreaInstance)this.project);
    }

    private static final List getBuildFileSpecificRequirements$lambda$0(Module $module) {
        return PyPackageUtil.getRequirementsFromTxt((Module)$module);
    }
}

