/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSessionProviderKt;
import org.jetbrains.kotlin.analysis.api.impl.base.sessions.KaBaseSessionProvider;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinProjectStructureProvider;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModuleKt;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionInvalidationListener;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/sessions/KaBaseSessionProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "getAnalysisSession", "useSiteElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "useSiteModule", "createAnalysisSession", "Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "useSiteKtModule", "clearCaches", "", "SessionInvalidationListener", "analysis-api-fir"})
public final class KaFirSessionProvider
extends KaBaseSessionProvider {
    @NotNull
    private final ConcurrentMap<KaModule, KaSession> cache;

    public KaFirSessionProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftValueMap(...)");
        this.cache = concurrentMap;
        LowMemoryWatcher.register(this::clearCaches, (Disposable)((Disposable)project));
    }

    @Override
    @NotNull
    public KaSession getAnalysisSession(@NotNull KtElement useSiteElement) {
        Intrinsics.checkNotNullParameter((Object)useSiteElement, (String)"useSiteElement");
        KaModule module = KotlinProjectStructureProvider.Companion.getModule(this.getProject(), (PsiElement)useSiteElement, null);
        return this.getAnalysisSession(module);
    }

    @Override
    @NotNull
    public KaSession getAnalysisSession(@NotNull KaModule useSiteModule) {
        Intrinsics.checkNotNullParameter((Object)useSiteModule, (String)"useSiteModule");
        if (useSiteModule instanceof KaDanglingFileModule && !KaModuleKt.isStable((KaDanglingFileModule)useSiteModule)) {
            return this.createAnalysisSession(useSiteModule);
        }
        KClass<? extends KaLifetimeToken> identifier = this.getTokenFactory().getIdentifier();
        KaFirSessionProviderKt.access$flushPendingChanges(identifier, this.getProject());
        KaSession kaSession = this.cache.computeIfAbsent(useSiteModule, arg_0 -> KaFirSessionProvider.getAnalysisSession$lambda$0((Function1)new Function1<KaModule, KaFirSession>((Object)this){

            public final KaFirSession invoke(KaModule p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return KaFirSessionProvider.access$createAnalysisSession((KaFirSessionProvider)this.receiver, p0);
            }

            public final String getSignature() {
                return "createAnalysisSession(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;)Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;";
            }

            public final String getName() {
                return "createAnalysisSession";
            }

            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(KaFirSessionProvider.class);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)kaSession, (String)"computeIfAbsent(...)");
        return kaSession;
    }

    private final KaFirSession createAnalysisSession(KaModule useSiteKtModule) {
        LLFirResolveSession firResolveSession = LowLevelFirApiFacadeKt.getFirResolveSession(useSiteKtModule, this.getProject());
        KaLifetimeToken validityToken = this.getTokenFactory().create(this.getProject(), firResolveSession.getUseSiteFirSession().createValidityTracker());
        return KaFirSession.Companion.createAnalysisSessionByFirResolveSession$analysis_api_fir(firResolveSession, validityToken);
    }

    @Override
    public void clearCaches() {
        this.cache.clear();
    }

    private static final KaSession getAnalysisSession$lambda$0(Function1 $tmp0, Object p0) {
        return (KaSession)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ KaFirSession access$createAnalysisSession(KaFirSessionProvider $this, KaModule useSiteKtModule) {
        return $this.createAnalysisSession(useSiteKtModule);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider$SessionInvalidationListener;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionInvalidationListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "analysisSessionProvider", "Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider;", "getAnalysisSessionProvider", "()Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider;", "afterInvalidation", "", "modules", "", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "afterGlobalInvalidation", "analysis-api-fir"})
    @SourceDebugExtension(value={"SMAP\nKaFirSessionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaFirSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider$SessionInvalidationListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1863#2,2:102\n*S KotlinDebug\n*F\n+ 1 KaFirSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider$SessionInvalidationListener\n*L\n77#1:102,2\n*E\n"})
    public static final class SessionInvalidationListener
    implements LLFirSessionInvalidationListener {
        @NotNull
        private final Project project;

        public SessionInvalidationListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        private final KaFirSessionProvider getAnalysisSessionProvider() {
            KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(this.project);
            KaFirSessionProvider kaFirSessionProvider = kaSessionProvider instanceof KaFirSessionProvider ? (KaFirSessionProvider)kaSessionProvider : null;
            if (kaFirSessionProvider == null) {
                throw new IllegalStateException(("Expected the analysis session provider to be a `" + Reflection.getOrCreateKotlinClass(KaFirSessionProvider.class).getSimpleName() + "`.").toString());
            }
            return kaFirSessionProvider;
        }

        @Override
        public void afterInvalidation(@NotNull Set<? extends KaModule> modules) {
            Intrinsics.checkNotNullParameter(modules, (String)"modules");
            Iterable $this$forEach$iv = modules;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KaModule it = (KaModule)element$iv;
                boolean bl = false;
                this.getAnalysisSessionProvider().cache.remove(it);
            }
        }

        @Override
        public void afterGlobalInvalidation() {
            this.getAnalysisSessionProvider().clearCaches();
        }
    }
}

