/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.run;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.SimpleConfigurationType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.sh.ShBundle;
import com.intellij.sh.ShLanguage;
import com.intellij.sh.run.ShDefaultShellPathProvider;
import com.intellij.sh.run.ShRunConfiguration;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public final class ShConfigurationType
extends SimpleConfigurationType {
    ShConfigurationType() {
        super("ShConfigurationType", ShLanguage.INSTANCE.getID(), ShBundle.message("sh.run.configuration.description.0.configuration", ShLanguage.INSTANCE.getID()), NotNullLazyValue.lazy(() -> AllIcons.Nodes.Console));
    }

    @NotNull
    public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
        if (project == null) {
            ShConfigurationType.$$$reportNull$$$0(0);
        }
        ShRunConfiguration configuration = new ShRunConfiguration(project, (ConfigurationFactory)this, ShLanguage.INSTANCE.getID());
        String defaultShell = ShConfigurationType.getDefaultShell(project);
        configuration.setInterpreterPath(defaultShell);
        String projectPath = project.getBasePath();
        if (projectPath != null) {
            configuration.setScriptWorkingDirectory(projectPath);
        }
        ShRunConfiguration shRunConfiguration = configuration;
        if (shRunConfiguration == null) {
            ShConfigurationType.$$$reportNull$$$0(1);
        }
        return shRunConfiguration;
    }

    public static ShConfigurationType getInstance() {
        return (ShConfigurationType)ConfigurationTypeUtil.findConfigurationType(ShConfigurationType.class);
    }

    public boolean isEditableInDumbMode() {
        return true;
    }

    @NotNull
    public static String getDefaultShell(@NotNull Project project) {
        ShDefaultShellPathProvider shellPathProvider;
        if (project == null) {
            ShConfigurationType.$$$reportNull$$$0(2);
        }
        if ((shellPathProvider = (ShDefaultShellPathProvider)project.getService(ShDefaultShellPathProvider.class)) != null) {
            String string = shellPathProvider.getDefaultShell();
            if (string == null) {
                ShConfigurationType.$$$reportNull$$$0(3);
            }
            return string;
        }
        return ShConfigurationType.trivialDefaultShellDetection();
    }

    @NotNull
    private static String trivialDefaultShellDetection() {
        String shell = System.getenv("SHELL");
        if (shell != null && new File(shell).canExecute()) {
            String string = shell;
            if (string == null) {
                ShConfigurationType.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (SystemInfo.isUnix) {
            String bashPath = "/bin/bash";
            if (new File(bashPath).exists()) {
                String string = bashPath;
                if (string == null) {
                    ShConfigurationType.$$$reportNull$$$0(5);
                }
                return string;
            }
            return "/bin/sh";
        }
        return "powershell.exe";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/run/ShConfigurationType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/run/ShConfigurationType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplateConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultShell";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "trivialDefaultShellDetection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateConfiguration";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultShell";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

