/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.execution.wsl.WSLDistribution;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001H\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u0004\u0018\u00010\u00058VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\f\u0010\nR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/idea/maven/server/WslMavenDistribution;", "Lorg/jetbrains/idea/maven/server/MavenDistribution;", "wslDistribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "pathToMaven", "", "name", "<init>", "(Lcom/intellij/execution/wsl/WSLDistribution;Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "version", "getVersion", "version$delegate", "Lkotlin/Lazy;", "mavenHome", "Ljava/nio/file/Path;", "getMavenHome", "()Ljava/nio/file/Path;", "compatibleWith", "", "mavenDistribution", "isValid", "toString", "intellij.maven"})
public final class WslMavenDistribution
implements MavenDistribution {
    @NotNull
    private final WSLDistribution wslDistribution;
    @NotNull
    private final String pathToMaven;
    @NotNull
    private final String name;
    @NotNull
    private final Lazy version$delegate;
    @NotNull
    private final Path mavenHome;

    public WslMavenDistribution(@NotNull WSLDistribution wslDistribution, @NotNull String pathToMaven, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)wslDistribution, (String)"wslDistribution");
        Intrinsics.checkNotNullParameter((Object)pathToMaven, (String)"pathToMaven");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.wslDistribution = wslDistribution;
        this.pathToMaven = pathToMaven;
        this.name = name;
        this.version$delegate = LazyKt.lazy(() -> WslMavenDistribution.version_delegate$lambda$0(this));
        String string = this.wslDistribution.getWindowsPath(this.pathToMaven);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWindowsPath(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        this.mavenHome = path;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getVersion() {
        Lazy lazy = this.version$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public Path getMavenHome() {
        return this.mavenHome;
    }

    @Override
    public boolean compatibleWith(@NotNull MavenDistribution mavenDistribution) {
        Intrinsics.checkNotNullParameter((Object)mavenDistribution, (String)"mavenDistribution");
        if (Intrinsics.areEqual((Object)mavenDistribution, (Object)this)) {
            return true;
        }
        WslMavenDistribution wslMavenDistribution = mavenDistribution instanceof WslMavenDistribution ? (WslMavenDistribution)mavenDistribution : null;
        if (wslMavenDistribution == null) {
            return false;
        }
        WslMavenDistribution another = wslMavenDistribution;
        return Intrinsics.areEqual((Object)another.wslDistribution, (Object)this.wslDistribution) && Intrinsics.areEqual((Object)another.pathToMaven, (Object)this.pathToMaven);
    }

    @Override
    public boolean isValid() {
        return this.getVersion() != null;
    }

    @NotNull
    public String toString() {
        return this.getName() + "(" + this.getMavenHome() + ") v " + this.getVersion();
    }

    private static final String version_delegate$lambda$0(WslMavenDistribution this$0) {
        return MavenUtil.getMavenVersion(this$0.wslDistribution.getWindowsPath(this$0.pathToMaven));
    }
}

