/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.internal.daemon;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0001J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0006J\u001e\u0010\f\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00062\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/gradle/internal/daemon/GradleServiceLookup;", "", "<init>", "()V", "services", "", "Ljava/lang/reflect/Type;", "register", "", "type", "instance", "find", "get", "clazz", "Ljava/lang/Class;", "", "intellij.gradle"})
public final class GradleServiceLookup {
    @NotNull
    private final Map<Type, Object> services = new ConcurrentHashMap();

    public final void register(@NotNull Type type, @NotNull Object instance) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        this.services.put(type, instance);
    }

    @Nullable
    public final Object find(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.services.get(type);
    }

    @NotNull
    public final Object get(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Object object = this.find(type);
        if (object == null) {
            throw new IllegalArgumentException("The type " + type + " is not registered. Gradle version: " + GradleVersion.current());
        }
        return object;
    }

    @NotNull
    public final Object get(@NotNull Type type, @NotNull Class<? extends Annotation> clazz) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Object result = this.get(type);
        if (clazz.isInstance(result)) {
            return result;
        }
        throw new IllegalStateException("The " + type + " instance expected to be " + clazz + ", but was " + result.getClass() + ". Gradle version: " + GradleVersion.current());
    }
}

