/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.impl.ProgressBuildEventImpl;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import com.intellij.openapi.util.NlsSafe;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.configuration.ProjectConfigurationProgressEvent;
import org.gradle.tooling.events.lifecycle.BuildPhaseFinishEvent;
import org.gradle.tooling.events.lifecycle.BuildPhaseProgressEvent;
import org.gradle.tooling.events.lifecycle.BuildPhaseStartEvent;
import org.gradle.tooling.events.task.TaskProgressEvent;
import org.gradle.tooling.events.test.TestProgressEvent;
import org.gradle.tooling.events.work.WorkItemProgressEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleProgressEventConverter;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u0004\u0018\u00010\n*\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0012\u0010\u0017\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0003J\u0017\u0010\u0018\u001a\t\u0018\u00010\u0011\u00a2\u0006\u0002\b\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0017\u0010\u001a\u001a\t\u0018\u00010\u0011\u00a2\u0006\u0002\b\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0017\u0010\u001b\u001a\t\u0018\u00010\u0011\u00a2\u0006\u0002\b\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\f\u0010\u001c\u001a\u00020\u0006*\u00020\u001dH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionProgressMapper;", "", "<init>", "()V", "states", "Ljava/util/LinkedList;", "Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionProgressMapper$State;", "phasedEventReceived", "", "map", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationEvent;", "taskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "event", "Lorg/gradle/tooling/events/ProgressEvent;", "mapLegacyEvent", "eventDescription", "", "toEsEvent", "mapLegacyEventToStateKeepingEsEvent", "Lcom/intellij/openapi/externalSystem/model/task/event/ExternalSystemBuildEvent;", "id", "state", "getPhaseName", "getLegacyEventActionItem", "Lcom/intellij/openapi/util/NlsSafe;", "getBuildEventActionItem", "trimLegacyEventActionItem", "asState", "Lorg/gradle/tooling/events/lifecycle/BuildPhaseProgressEvent;", "State", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleExecutionProgressMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleExecutionProgressMapper.kt\norg/jetbrains/plugins/gradle/service/execution/GradleExecutionProgressMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
public final class GradleExecutionProgressMapper {
    @NotNull
    private final LinkedList<State> states = new LinkedList();
    private boolean phasedEventReceived;

    @Nullable
    public final ExternalSystemTaskNotificationEvent map(@NotNull ExternalSystemTaskId taskId, @NotNull ProgressEvent event) {
        ExternalSystemTaskNotificationEvent externalSystemTaskNotificationEvent;
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ProgressEvent progressEvent = event;
        if (progressEvent instanceof BuildPhaseStartEvent) {
            this.phasedEventReceived = true;
            this.states.addLast(this.asState((BuildPhaseProgressEvent)event));
            externalSystemTaskNotificationEvent = null;
        } else if (progressEvent instanceof BuildPhaseFinishEvent) {
            this.states.pollLast();
            externalSystemTaskNotificationEvent = null;
        } else if (progressEvent instanceof FinishEvent) {
            State state = (State)CollectionsKt.lastOrNull((List)this.states);
            if (state != null) {
                state.increment();
            }
            externalSystemTaskNotificationEvent = this.toEsEvent(event, taskId);
        } else {
            externalSystemTaskNotificationEvent = this.toEsEvent(event, taskId);
        }
        return externalSystemTaskNotificationEvent;
    }

    @Nullable
    public final ExternalSystemTaskNotificationEvent mapLegacyEvent(@NotNull ExternalSystemTaskId taskId, @NotNull String eventDescription) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)eventDescription, (String)"eventDescription");
        if (this.phasedEventReceived && taskId.getType() == ExternalSystemTaskType.EXECUTE_TASK) {
            return null;
        }
        if (!((Collection)this.states).isEmpty()) {
            State state = this.states.getLast();
            Intrinsics.checkNotNullExpressionValue((Object)state, (String)"getLast(...)");
            return (ExternalSystemTaskNotificationEvent)this.mapLegacyEventToStateKeepingEsEvent(taskId, eventDescription, state);
        }
        return GradleProgressEventConverter.legacyConvertProgressBuildEvent(taskId, taskId, eventDescription);
    }

    private final ExternalSystemTaskNotificationEvent toEsEvent(ProgressEvent $this$toEsEvent, ExternalSystemTaskId taskId) {
        String string = this.getBuildEventActionItem($this$toEsEvent);
        if (string == null) {
            return null;
        }
        String actionItem = string;
        State state = (State)CollectionsKt.lastOrNull((List)this.states);
        String description = this.getPhaseName(state) + ": '" + actionItem + "'";
        State state2 = state;
        State state3 = state;
        ProgressBuildEventImpl progress = new ProgressBuildEventImpl((Object)taskId, null, $this$toEsEvent.getEventTime(), description, state2 != null ? state2.getTotalItems() : -1L, state3 != null ? state3.getCurrentItem() : -1L, "items");
        return (ExternalSystemTaskNotificationEvent)new ExternalSystemBuildEvent(taskId, (BuildEvent)progress);
    }

    private final ExternalSystemBuildEvent mapLegacyEventToStateKeepingEsEvent(ExternalSystemTaskId id, String eventDescription, State state) {
        Object object;
        block3: {
            block2: {
                object = this.getLegacyEventActionItem(eventDescription);
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = this.getPhaseName(state) + ": '" + it + "'";
                object = string;
                if (string != null) break block3;
            }
            return null;
        }
        Object description = object;
        ProgressBuildEventImpl progress = new ProgressBuildEventImpl((Object)id, null, System.currentTimeMillis(), (String)description, state.getTotalItems(), state.getCurrentItem(), "items");
        return new ExternalSystemBuildEvent(id, (BuildEvent)progress);
    }

    /*
     * Unable to fully structure code
     */
    @NlsSafe
    private final String getPhaseName(State state) {
        block8: {
            block7: {
                v0 = state;
                v1 = var2_2 = v0 != null ? v0.getPhase() : null;
                if (var2_2 == null) break block7;
                switch (var2_2.hashCode()) {
                    case -1489474628: {
                        if (var2_2.equals("RUN_MAIN_TASKS")) break;
                        ** break;
                    }
                    case -1665140843: {
                        if (!var2_2.equals("CONFIGURE_BUILD")) {
                            ** break;
                        }
                        ** GOTO lbl17
                    }
                    case 1628406885: {
                        if (var2_2.equals("RUN_WORK")) break;
                        ** break;
                    }
                    case 288785354: {
                        if (!var2_2.equals("CONFIGURE_ROOT_BUILD")) ** break;
lbl17:
                        // 2 sources

                        v2 = GradleBundle.message("progress.title.configure.build", new Object[0]);
                        v3 = v2;
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"message(...)");
                        break block8;
                    }
                }
                v4 = GradleBundle.message("progress.title.run.task", new Object[0]);
                v3 = v4;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"message(...)");
                break block8;
            }
            v5 = GradleBundle.message("progress.title.build", new Object[0]);
            v3 = v5;
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"message(...)");
        }
        return v3;
    }

    private final String getLegacyEventActionItem(String eventDescription) {
        Object object;
        if (StringsKt.startsWith$default((String)eventDescription, (String)"Build model ", (boolean)false, (int)2, null) & (StringsKt.contains$default((CharSequence)eventDescription, (CharSequence)" for project ", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)eventDescription, (CharSequence)" for root project ", (boolean)false, (int)2, null))) {
            String string = this.trimLegacyEventActionItem(eventDescription);
            object = string != null ? StringsKt.replace$default((String)string, (String)"'", (String)"", (boolean)false, (int)4, null) : null;
        } else {
            object = StringsKt.startsWith$default((String)eventDescription, (String)"Build parameterized model ", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)eventDescription, (CharSequence)" for project ", (boolean)false, (int)2, null) ? this.trimLegacyEventActionItem(eventDescription) : (StringsKt.startsWith$default((String)eventDescription, (String)"Resolve files of ", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)eventDescription, (String)"Resolve dependencies ", (boolean)false, (int)2, null) ? this.trimLegacyEventActionItem(eventDescription) : (StringsKt.startsWith$default((String)eventDescription, (String)"Configure project ", (boolean)false, (int)2, null) ? this.trimLegacyEventActionItem(eventDescription) : (StringsKt.startsWith$default((String)eventDescription, (String)"Download from ", (boolean)false, (int)2, null) ? null : GradleProgressEventConverter.legacyConvertBuildEventDisplayName(eventDescription))));
        }
        return object;
    }

    private final String getBuildEventActionItem(ProgressEvent event) {
        ProgressEvent progressEvent = event;
        return progressEvent instanceof TaskProgressEvent || progressEvent instanceof TestProgressEvent ? event.getDescriptor().getName() : (progressEvent instanceof ProjectConfigurationProgressEvent ? ((ProjectConfigurationProgressEvent)event).getDescriptor().getProject().getProjectPath() : (progressEvent instanceof WorkItemProgressEvent ? ((WorkItemProgressEvent)event).getDescriptor().getClassName() : null));
    }

    private final String trimLegacyEventActionItem(String eventDescription) {
        int index = StringsKt.indexOf$default((CharSequence)eventDescription, (char)':', (int)0, (boolean)false, (int)6, null);
        if (index < 0) {
            return null;
        }
        String string = eventDescription.substring(index);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private final State asState(BuildPhaseProgressEvent $this$asState) {
        long l = $this$asState.getDescriptor().getBuildItemsCount();
        String string = $this$asState.getDescriptor().getBuildPhase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBuildPhase(...)");
        return new State(l, 0L, string, 2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0011\u001a\u00020\u0012J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0006H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionProgressMapper$State;", "", "totalItems", "", "currentItem", "phase", "", "<init>", "(JJLjava/lang/String;)V", "getTotalItems", "()J", "setTotalItems", "(J)V", "getCurrentItem", "setCurrentItem", "getPhase", "()Ljava/lang/String;", "increment", "", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.gradle"})
    private static final class State {
        private long totalItems;
        private long currentItem;
        @NotNull
        private final String phase;

        public State(long totalItems, long currentItem, @NotNull String phase) {
            Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
            this.totalItems = totalItems;
            this.currentItem = currentItem;
            this.phase = phase;
        }

        public /* synthetic */ State(long l, long l2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                l2 = 0L;
            }
            this(l, l2, string);
        }

        public final long getTotalItems() {
            return this.totalItems;
        }

        public final void setTotalItems(long l) {
            this.totalItems = l;
        }

        public final long getCurrentItem() {
            return this.currentItem;
        }

        public final void setCurrentItem(long l) {
            this.currentItem = l;
        }

        @NotNull
        public final String getPhase() {
            return this.phase;
        }

        public final void increment() {
            ++this.currentItem;
        }

        public final long component1() {
            return this.totalItems;
        }

        public final long component2() {
            return this.currentItem;
        }

        @NotNull
        public final String component3() {
            return this.phase;
        }

        @NotNull
        public final State copy(long totalItems, long currentItem, @NotNull String phase) {
            Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
            return new State(totalItems, currentItem, phase);
        }

        public static /* synthetic */ State copy$default(State state, long l, long l2, String string, int n, Object object) {
            if ((n & 1) != 0) {
                l = state.totalItems;
            }
            if ((n & 2) != 0) {
                l2 = state.currentItem;
            }
            if ((n & 4) != 0) {
                string = state.phase;
            }
            return state.copy(l, l2, string);
        }

        @NotNull
        public String toString() {
            return "State(totalItems=" + this.totalItems + ", currentItem=" + this.currentItem + ", phase=" + this.phase + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.totalItems);
            result = result * 31 + Long.hashCode(this.currentItem);
            result = result * 31 + this.phase.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (this.totalItems != state.totalItems) {
                return false;
            }
            if (this.currentItem != state.currentItem) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.phase, (Object)state.phase);
        }
    }
}

