/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution.wsl;

import com.intellij.execution.target.value.TargetValue;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.StringKt;
import java.net.URI;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.plugins.gradle.execution.target.GradleTargetUtil;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.execution.BuildLayoutParameters;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000eH\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0014H\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e*\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\u000e*\u00020\u00032\u0006\u0010!\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0013\u001a\u0004\u0018\u00010\u00148VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0012\u001a\u0004\b\u0015\u0010\u0016R!\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0012\u001a\u0004\b\u0019\u0010\u0010\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/wsl/WslBuildLayoutParameters;", "Lorg/jetbrains/plugins/gradle/service/execution/BuildLayoutParameters;", "wslDistribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "project", "Lcom/intellij/openapi/project/Project;", "projectPath", "", "<init>", "(Lcom/intellij/execution/wsl/WSLDistribution;Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "gradleProjectSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "Lorg/jetbrains/annotations/Nullable;", "gradleHome", "Lcom/intellij/execution/target/value/TargetValue;", "getGradleHome", "()Lcom/intellij/execution/target/value/TargetValue;", "gradleHome$delegate", "Lkotlin/Lazy;", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "getGradleVersion", "()Lorg/gradle/util/GradleVersion;", "gradleVersion$delegate", "gradleUserHome", "getGradleUserHome", "gradleUserHome$delegate", "findGradleHome", "guessGradleVersion", "findGradleUserHomeDir", "getTargetValueForLocalPath", "windowsPath", "getTargetValueForRemotePath", "wslPath", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nWslBuildLayoutParameters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WslBuildLayoutParameters.kt\norg/jetbrains/plugins/gradle/service/execution/wsl/WslBuildLayoutParameters\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public final class WslBuildLayoutParameters
implements BuildLayoutParameters {
    @NotNull
    private final WSLDistribution wslDistribution;
    @NotNull
    private final Project project;
    @Nullable
    private final String projectPath;
    @Nullable
    private final GradleProjectSettings gradleProjectSettings;
    @NotNull
    private final Lazy gradleHome$delegate;
    @NotNull
    private final Lazy gradleVersion$delegate;
    @NotNull
    private final Lazy gradleUserHome$delegate;

    /*
     * WARNING - void declaration
     */
    public WslBuildLayoutParameters(@NotNull WSLDistribution wslDistribution, @NotNull Project project2, @Nullable String projectPath) {
        GradleProjectSettings gradleProjectSettings;
        Intrinsics.checkNotNullParameter((Object)wslDistribution, (String)"wslDistribution");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.wslDistribution = wslDistribution;
        this.project = project2;
        this.projectPath = projectPath;
        WslBuildLayoutParameters wslBuildLayoutParameters = this;
        String string = this.projectPath;
        if (string != null) {
            void it;
            String string2 = string;
            WslBuildLayoutParameters wslBuildLayoutParameters2 = wslBuildLayoutParameters;
            boolean bl = false;
            gradleProjectSettings = (GradleProjectSettings)GradleSettings.getInstance(this.project).getLinkedProjectSettings((String)it);
            wslBuildLayoutParameters = wslBuildLayoutParameters2;
        } else {
            gradleProjectSettings = null;
        }
        wslBuildLayoutParameters.gradleProjectSettings = gradleProjectSettings;
        this.gradleHome$delegate = LazyKt.lazy(() -> WslBuildLayoutParameters.gradleHome_delegate$lambda$1(this));
        this.gradleVersion$delegate = LazyKt.lazy(() -> WslBuildLayoutParameters.gradleVersion_delegate$lambda$2(this));
        this.gradleUserHome$delegate = LazyKt.lazy(() -> WslBuildLayoutParameters.gradleUserHome_delegate$lambda$3(this));
    }

    @Override
    @Nullable
    public TargetValue<String> getGradleHome() {
        Lazy lazy = this.gradleHome$delegate;
        return (TargetValue)lazy.getValue();
    }

    @Override
    @Nullable
    public GradleVersion getGradleVersion() {
        Lazy lazy = this.gradleVersion$delegate;
        return (GradleVersion)lazy.getValue();
    }

    @Override
    @NotNull
    public TargetValue<String> getGradleUserHome() {
        Lazy lazy = this.gradleUserHome$delegate;
        return (TargetValue)lazy.getValue();
    }

    private final TargetValue<String> findGradleHome() {
        TargetValue<String> targetValue;
        Object object = this.gradleProjectSettings;
        if (object == null || (object = object.getDistributionType()) == null) {
            return null;
        }
        Object distributionType = object;
        if (distributionType == DistributionType.LOCAL) {
            TargetValue<String> targetValue2;
            String string = this.gradleProjectSettings.getGradleHome();
            if (string != null) {
                String it = string;
                boolean bl = false;
                targetValue2 = this.getTargetValueForRemotePath(this.wslDistribution, it);
            } else {
                targetValue2 = null;
            }
            return targetValue2;
        }
        String string = GradleLocalSettings.getInstance(this.project).getGradleHome(this.projectPath);
        if (string != null) {
            String it = string;
            boolean bl = false;
            targetValue = this.getTargetValueForLocalPath(this.wslDistribution, it);
        } else {
            targetValue = null;
        }
        return targetValue;
    }

    private final GradleVersion guessGradleVersion() {
        Object object = this.gradleProjectSettings;
        if (object == null || (object = object.getDistributionType()) == null) {
            return null;
        }
        GradleProjectSettings distributionType = object;
        switch (WhenMappings.$EnumSwitchMapping$0[((Enum)((Object)distributionType)).ordinal()]) {
            case 1: {
                return GradleVersion.current();
            }
            case 2: {
                GradleVersion gradleVersion;
                TargetValue<String> targetValue = this.getGradleHome();
                String string = GradleInstallationManager.getGradleVersion(targetValue != null ? GradleTargetUtil.maybeGetLocalValue(targetValue) : null);
                if (string != null) {
                    String $this$guessGradleVersion_u24lambda_u246 = string;
                    boolean bl = false;
                    gradleVersion = GradleInstallationManager.getGradleVersionSafe($this$guessGradleVersion_u24lambda_u246);
                } else {
                    gradleVersion = null;
                }
                return gradleVersion;
            }
            case 3: {
                GradleVersion gradleVersion;
                TargetValue<String> targetValue = this.getGradleHome();
                String string = GradleInstallationManager.getGradleVersion(targetValue != null ? GradleTargetUtil.maybeGetLocalValue(targetValue) : null);
                if (string != null) {
                    String $this$guessGradleVersion_u24lambda_u247 = string;
                    boolean bl = false;
                    v6 = GradleInstallationManager.getGradleVersionSafe($this$guessGradleVersion_u24lambda_u247);
                } else {
                    v6 = gradleVersion = null;
                }
                if (gradleVersion == null) {
                    String path;
                    Object object2 = GradleUtil.getWrapperConfiguration(this.projectPath);
                    String string2 = object2 != null && (object2 = object2.getDistribution()) != null ? ((URI)object2).getRawPath() : (path = null);
                    if (path == null) break;
                    return GradleInstallationManager.parseDistributionVersion(path);
                }
                return gradleVersion;
            }
            case 4: {
                return null;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return null;
    }

    private final TargetValue<String> findGradleUserHomeDir(WSLDistribution wslDistribution) {
        String serviceDirectoryPath;
        if (this.projectPath != null && (serviceDirectoryPath = GradleSettings.getInstance(this.project).getServiceDirectoryPath()) != null) {
            return this.getTargetValueForLocalPath(wslDistribution, serviceDirectoryPath);
        }
        String gradleUserHome = StringKt.nullize((String)wslDistribution.getEnvironmentVariable("GRADLE_USER_HOME"), (boolean)true);
        Object object = gradleUserHome;
        if (object == null) {
            object = wslDistribution.getUserHome() + "/.gradle";
        }
        return this.getTargetValueForRemotePath(wslDistribution, (String)object);
    }

    private final TargetValue<String> getTargetValueForLocalPath(WSLDistribution $this$getTargetValueForLocalPath, String windowsPath) {
        String string = $this$getTargetValueForLocalPath.getWslPath(windowsPath);
        if (string == null) {
            string = windowsPath;
        }
        String wslPath = string;
        TargetValue targetValue = TargetValue.create((Object)windowsPath, (Promise)Promises.resolvedPromise((Object)wslPath));
        Intrinsics.checkNotNullExpressionValue((Object)targetValue, (String)"create(...)");
        return targetValue;
    }

    private final TargetValue<String> getTargetValueForRemotePath(WSLDistribution $this$getTargetValueForRemotePath, String wslPath) {
        String string = $this$getTargetValueForRemotePath.getWindowsPath(wslPath);
        if (string == null) {
            string = wslPath;
        }
        String windowsPath = string;
        TargetValue targetValue = TargetValue.create((Object)windowsPath, (Promise)Promises.resolvedPromise((Object)wslPath));
        Intrinsics.checkNotNullExpressionValue((Object)targetValue, (String)"create(...)");
        return targetValue;
    }

    private static final TargetValue gradleHome_delegate$lambda$1(WslBuildLayoutParameters this$0) {
        return this$0.findGradleHome();
    }

    private static final GradleVersion gradleVersion_delegate$lambda$2(WslBuildLayoutParameters this$0) {
        return this$0.guessGradleVersion();
    }

    private static final TargetValue gradleUserHome_delegate$lambda$3(WslBuildLayoutParameters this$0) {
        return this$0.findGradleUserHomeDir(this$0.wslDistribution);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DistributionType.values().length];
            try {
                nArray[DistributionType.BUNDLED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DistributionType.LOCAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DistributionType.DEFAULT_WRAPPED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DistributionType.WRAPPED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

