/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.project.ExternalStorageConfigurationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.config.DelegatingGradleSettingsListenerAdapter;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.gradle.settings.GradleSettingsMigration;
import org.jetbrains.plugins.gradle.settings.GradleSystemSettings;
import org.jetbrains.plugins.gradle.settings.TestRunner;

@State(name="GradleSettings", storages={@Storage(value="gradle.xml")})
public class GradleSettings
extends AbstractExternalSystemSettings<GradleSettings, GradleProjectSettings, GradleSettingsListener>
implements PersistentStateComponent<MyState> {
    private boolean isOfflineMode;
    private boolean isParallelModelFetch;

    public GradleSettings(@NotNull Project project2) {
        if (project2 == null) {
            GradleSettings.$$$reportNull$$$0(0);
        }
        super(GradleSettingsListener.TOPIC, project2);
        this.isOfflineMode = false;
        this.isParallelModelFetch = Experiments.getInstance().isFeatureEnabled("gradle.parallel.model.fetch");
    }

    @NotNull
    public static GradleSettings getInstance(@NotNull Project project2) {
        if (project2 == null) {
            GradleSettings.$$$reportNull$$$0(1);
        }
        GradleSettings gradleSettings = (GradleSettings)((Object)project2.getService(GradleSettings.class));
        if (gradleSettings == null) {
            GradleSettings.$$$reportNull$$$0(2);
        }
        return gradleSettings;
    }

    public void subscribe(@NotNull ExternalSystemSettingsListener<GradleProjectSettings> listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            GradleSettings.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            GradleSettings.$$$reportNull$$$0(4);
        }
        this.doSubscribe(new DelegatingGradleSettingsListenerAdapter(listener2), parentDisposable);
    }

    protected void copyExtraSettingsFrom(@NotNull GradleSettings settings) {
        if (settings == null) {
            GradleSettings.$$$reportNull$$$0(5);
        }
    }

    @Nullable
    public MyState getState() {
        MyState state = new MyState();
        this.fillState(state);
        state.setOfflineMode(this.isOfflineWork());
        state.setParallelModelFetch(this.isParallelModelFetch());
        return state;
    }

    public void loadState(@NotNull MyState state) {
        if (state == null) {
            GradleSettings.$$$reportNull$$$0(6);
        }
        super.loadState((AbstractExternalSystemSettings.State)state);
        this.setOfflineWork(state.isOfflineMode());
        this.setParallelModelFetch(state.isParallelModelFetch());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        GradleSettingsMigration migration = (GradleSettingsMigration)this.getProject().getService(GradleSettingsMigration.class);
        if (migration.getMigrationVersion() < 1) {
            migration.setMigrationVersion(1);
            GradleSettingsMigration.LegacyDefaultGradleProjectSettings.MyState legacyProjectDefaults = ((GradleSettingsMigration.LegacyDefaultGradleProjectSettings)this.getProject().getService(GradleSettingsMigration.LegacyDefaultGradleProjectSettings.class)).getState();
            if (legacyProjectDefaults != null) {
                for (GradleProjectSettings each : this.getLinkedProjectsSettings()) {
                    if (each.getDirectDelegatedBuild() == null) {
                        each.setDelegatedBuild(legacyProjectDefaults.delegatedBuild);
                    }
                    if (each.getDirectTestRunner() != null) continue;
                    each.setTestRunner(legacyProjectDefaults.testRunner);
                }
            }
        }
    }

    @Nullable
    @NlsSafe
    public String getServiceDirectoryPath() {
        return GradleLocalSettings.getInstance(this.getProject()).getGradleUserHome();
    }

    public void setServiceDirectoryPath(@Nullable String newPath) {
        String myServiceDirectoryPath = GradleLocalSettings.getInstance(this.getProject()).getGradleUserHome();
        if (!Objects.equals(myServiceDirectoryPath, newPath)) {
            GradleLocalSettings.getInstance(this.getProject()).setGradleUserHome(newPath);
            ((GradleSettingsListener)this.getPublisher()).onServiceDirectoryPathChange(myServiceDirectoryPath, newPath);
        }
    }

    @Nullable
    public String getGradleVmOptions() {
        return GradleSystemSettings.getInstance().getGradleVmOptions();
    }

    public void setGradleVmOptions(@Nullable String gradleVmOptions) {
        String myGradleVmOptions = GradleSystemSettings.getInstance().getGradleVmOptions();
        if (!Objects.equals(myGradleVmOptions, gradleVmOptions)) {
            GradleSystemSettings.getInstance().setGradleVmOptions(gradleVmOptions);
            ((GradleSettingsListener)this.getPublisher()).onGradleVmOptionsChange(myGradleVmOptions, gradleVmOptions);
        }
    }

    public boolean isOfflineWork() {
        return this.isOfflineMode;
    }

    public void setOfflineWork(boolean isOfflineMode) {
        this.isOfflineMode = isOfflineMode;
    }

    public boolean getStoreProjectFilesExternally() {
        return ExternalStorageConfigurationManager.getInstance((Project)this.getProject()).isEnabled();
    }

    public void setStoreProjectFilesExternally(boolean value) {
        ExternalProjectsManagerImpl.getInstance((Project)this.getProject()).setStoreExternally(value);
    }

    public boolean isParallelModelFetch() {
        return this.isParallelModelFetch;
    }

    public void setParallelModelFetch(boolean parallelModelFetch) {
        this.isParallelModelFetch = parallelModelFetch;
    }

    protected void checkSettings(@NotNull GradleProjectSettings old, @NotNull GradleProjectSettings current) {
        if (old == null) {
            GradleSettings.$$$reportNull$$$0(7);
        }
        if (current == null) {
            GradleSettings.$$$reportNull$$$0(8);
        }
        if (!Objects.equals(old.getGradleHome(), current.getGradleHome())) {
            ((GradleSettingsListener)this.getPublisher()).onGradleHomeChange(old.getGradleHome(), current.getGradleHome(), current.getExternalProjectPath());
        }
        if (!Objects.equals(old.getGradleJvm(), current.getGradleJvm())) {
            ((GradleSettingsListener)this.getPublisher()).onGradleJvmChange(old.getGradleJvm(), current.getGradleJvm(), current.getExternalProjectPath());
        }
        if (old.getDistributionType() != current.getDistributionType()) {
            ((GradleSettingsListener)this.getPublisher()).onGradleDistributionTypeChange(current.getDistributionType(), current.getExternalProjectPath());
        }
        if (old.isResolveModulePerSourceSet() != current.isResolveModulePerSourceSet()) {
            ExternalProjectsManager.getInstance((Project)this.getProject()).getExternalProjectsWatcher().markDirty(current.getExternalProjectPath());
        }
        if (!Comparing.equal((Object)old.getDelegatedBuild(), (Object)current.getDelegatedBuild())) {
            boolean delegatedBuild = GradleProjectSettings.isDelegatedBuildEnabled(this.getProject(), current.getExternalProjectPath());
            ((GradleSettingsListener)this.getPublisher()).onBuildDelegationChange(delegatedBuild, current.getExternalProjectPath());
        }
        if (!Comparing.equal((Object)((Object)old.getTestRunner()), (Object)((Object)current.getTestRunner()))) {
            TestRunner testRunner = GradleProjectSettings.getTestRunner(this.getProject(), current.getExternalProjectPath());
            ((GradleSettingsListener)this.getPublisher()).onTestRunnerChange(testRunner, current.getExternalProjectPath());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/settings/GradleSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "old";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "subscribe";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copyExtraSettingsFrom";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static class MyState
    implements AbstractExternalSystemSettings.State<GradleProjectSettings> {
        private final Set<GradleProjectSettings> myProjectSettings = new TreeSet<GradleProjectSettings>();
        private boolean isOfflineMode = false;
        private boolean isParallelModelFetch = Experiments.getInstance().isFeatureEnabled("gradle.parallel.model.fetch");

        @XCollection(elementTypes={GradleProjectSettings.class})
        public Set<GradleProjectSettings> getLinkedExternalProjectsSettings() {
            return this.myProjectSettings;
        }

        public void setLinkedExternalProjectsSettings(Set<GradleProjectSettings> settings) {
            if (settings != null) {
                this.myProjectSettings.addAll(settings);
            }
        }

        public boolean isOfflineMode() {
            return this.isOfflineMode;
        }

        public void setOfflineMode(boolean isOfflineMode) {
            this.isOfflineMode = isOfflineMode;
        }

        public boolean isParallelModelFetch() {
            return this.isParallelModelFetch;
        }

        public void setParallelModelFetch(boolean parallelModelFetch) {
            this.isParallelModelFetch = parallelModelFetch;
        }
    }
}

