/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.models.ContentSecurityPolicyBuilder;

public enum BrowserSecurityHeaders {
    X_FRAME_OPTIONS("xFrameOptions", "X-Frame-Options", "SAMEORIGIN"),
    CONTENT_SECURITY_POLICY("contentSecurityPolicy", "Content-Security-Policy", ContentSecurityPolicyBuilder.create().build()),
    CONTENT_SECURITY_POLICY_REPORT_ONLY("contentSecurityPolicyReportOnly", "Content-Security-Policy-Report-Only", ""),
    X_CONTENT_TYPE_OPTIONS("xContentTypeOptions", "X-Content-Type-Options", "nosniff"),
    X_ROBOTS_TAG("xRobotsTag", "X-Robots-Tag", "none"),
    X_XSS_PROTECTION("xXSSProtection", "X-XSS-Protection", "1; mode=block"),
    STRICT_TRANSPORT_SECURITY("strictTransportSecurity", "Strict-Transport-Security", "max-age=31536000; includeSubDomains"),
    REFERRER_POLICY("referrerPolicy", "Referrer-Policy", "no-referrer");

    private final String key;
    private final String headerName;
    private final String defaultValue;
    @Deprecated
    public static final Map<String, String> realmDefaultHeaders;

    private BrowserSecurityHeaders(String key, String headerName, String defaultValue) {
        this.key = key;
        this.headerName = headerName;
        this.defaultValue = defaultValue;
    }

    public String getKey() {
        return this.key;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    static {
        HashMap<String, String> dh = new HashMap<String, String>();
        dh.put(X_FRAME_OPTIONS.getKey(), X_FRAME_OPTIONS.getDefaultValue());
        dh.put(CONTENT_SECURITY_POLICY.getKey(), CONTENT_SECURITY_POLICY.getDefaultValue());
        dh.put(CONTENT_SECURITY_POLICY_REPORT_ONLY.getKey(), CONTENT_SECURITY_POLICY_REPORT_ONLY.getDefaultValue());
        dh.put(X_CONTENT_TYPE_OPTIONS.getKey(), X_CONTENT_TYPE_OPTIONS.getDefaultValue());
        dh.put(X_ROBOTS_TAG.getKey(), X_ROBOTS_TAG.getDefaultValue());
        dh.put(X_XSS_PROTECTION.getKey(), X_XSS_PROTECTION.getDefaultValue());
        dh.put(STRICT_TRANSPORT_SECURITY.getKey(), STRICT_TRANSPORT_SECURITY.getDefaultValue());
        dh.put(REFERRER_POLICY.getKey(), REFERRER_POLICY.getDefaultValue());
        realmDefaultHeaders = Collections.unmodifiableMap(dh);
    }
}

