/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import io.netty.buffer.ByteBuf;
import java.net.SocketAddress;
import java.util.function.Function;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.event.impl.AbstractClientEvent;
import org.infinispan.client.hotrod.event.impl.ExpiredEventImpl;
import org.infinispan.client.hotrod.impl.protocol.Codec20;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.commons.configuration.ClassAllowList;

public class Codec21
extends Codec20 {
    @Override
    public HeaderParams writeHeader(ByteBuf buf, HeaderParams params) {
        return this.writeHeader(buf, params, (byte)21);
    }

    @Override
    public void writeClientListenerParams(ByteBuf buf, ClientListener clientListener, byte[][] filterFactoryParams, byte[][] converterFactoryParams) {
        super.writeClientListenerParams(buf, clientListener, filterFactoryParams, converterFactoryParams);
        buf.writeByte((int)((short)(clientListener.useRawData() ? 1 : 0)));
    }

    @Override
    public AbstractClientEvent readCacheEvent(ByteBuf buf, Function<byte[], DataFormat> listenerDataFormat, short eventTypeId, ClassAllowList allowList, SocketAddress serverAddress) {
        ClientEvent.Type eventType;
        short status = buf.readUnsignedByte();
        buf.readUnsignedByte();
        switch (eventTypeId) {
            case 96: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED;
                break;
            }
            case 97: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED;
                break;
            }
            case 98: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED;
                break;
            }
            case 99: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_EXPIRED;
                break;
            }
            case 80: {
                this.checkForErrorsInResponseStatus(buf, null, status, serverAddress);
            }
            default: {
                throw Log.HOTROD.unknownEvent(eventTypeId);
            }
        }
        byte[] listenerId = ByteBufUtil.readArray(buf);
        short isCustom = buf.readUnsignedByte();
        boolean isRetried = buf.readUnsignedByte() == 1;
        DataFormat dataFormat = listenerDataFormat.apply(listenerId);
        if (isCustom == 1) {
            Object eventData = dataFormat.valueToObj(ByteBufUtil.readArray(buf), allowList);
            return this.createCustomEvent(listenerId, eventData, eventType, isRetried);
        }
        if (isCustom == 2) {
            return this.createCustomEvent(listenerId, ByteBufUtil.readArray(buf), eventType, isRetried);
        }
        switch (eventType) {
            case CLIENT_CACHE_ENTRY_CREATED: {
                Object createdKey = dataFormat.keyToObj(ByteBufUtil.readArray(buf), allowList);
                long createdDataVersion = buf.readLong();
                return this.createCreatedEvent(listenerId, createdKey, createdDataVersion, isRetried);
            }
            case CLIENT_CACHE_ENTRY_MODIFIED: {
                Object modifiedKey = dataFormat.keyToObj(ByteBufUtil.readArray(buf), allowList);
                long modifiedDataVersion = buf.readLong();
                return this.createModifiedEvent(listenerId, modifiedKey, modifiedDataVersion, isRetried);
            }
            case CLIENT_CACHE_ENTRY_REMOVED: {
                Object removedKey = dataFormat.keyToObj(ByteBufUtil.readArray(buf), allowList);
                return this.createRemovedEvent(listenerId, removedKey, isRetried);
            }
            case CLIENT_CACHE_ENTRY_EXPIRED: {
                Object expiredKey = dataFormat.keyToObj(ByteBufUtil.readArray(buf), allowList);
                return this.createExpiredEvent(listenerId, expiredKey);
            }
        }
        throw Log.HOTROD.unknownEvent(eventTypeId);
    }

    protected AbstractClientEvent createExpiredEvent(byte[] listenerId, Object key) {
        return new ExpiredEventImpl<Object>(listenerId, key);
    }
}

