/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ingest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.logstash.ingest.IngestConverter;

public class IngestGeoIp {
    public static String toLogstash(String json, boolean appendStdio) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        HashMap<String, Object> jsonDefinition = mapper.readValue(json, typeRef);
        List processors = (List)jsonDefinition.get("processors");
        List<String> filters_pipeline = processors.stream().map(IngestGeoIp::mapProcessor).collect(Collectors.toList());
        return IngestConverter.filtersToFile(IngestConverter.appendIoPlugins(filters_pipeline, appendStdio));
    }

    private static String mapProcessor(Map processor) {
        return IngestConverter.filterHash(IngestConverter.createHash("geoip", IngestGeoIp.geoIpHash(processor)));
    }

    static String geoIpHash(Map<String, Map> processor) {
        Map geoip_data = processor.get("geoip");
        String sourceField = IngestConverter.createField("source", IngestConverter.quoteString(IngestConverter.dotsToSquareBrackets((String)geoip_data.get("field"))));
        String targetField = IngestConverter.createField("target", IngestConverter.quoteString(IngestConverter.dotsToSquareBrackets((String)geoip_data.get("target_field"))));
        if (geoip_data.containsKey("properties")) {
            String fields = IngestConverter.createField("fields", IngestConverter.createPatternArray(((List)geoip_data.get("properties")).toArray(new String[0])));
            return IngestConverter.joinHashFields(sourceField, targetField, fields);
        }
        return IngestConverter.joinHashFields(sourceField, targetField);
    }

    public static boolean has_geoip(Map<String, Object> processor) {
        return processor.containsKey("geoip");
    }
}

