/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.EnumSet;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NoOperandInstr;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class DefineInstanceMethodInstr
extends NoOperandInstr
implements FixedArityInstr {
    private final IRMethod method;

    public DefineInstanceMethodInstr(IRMethod method2) {
        super(Operation.DEF_INST_METH);
        this.method = method2;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"name: " + this.method.getId()};
    }

    @Override
    public boolean computeScopeFlags(IRScope scope, EnumSet<IRFlags> flags2) {
        flags2.add(IRFlags.REQUIRES_DYNSCOPE);
        flags2.add(IRFlags.REQUIRES_VISIBILITY);
        return true;
    }

    public IRMethod getMethod() {
        return this.method;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new DefineInstanceMethodInstr(this.method);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getMethod());
    }

    public static DefineInstanceMethodInstr decode(IRReaderDecoder d) {
        return new DefineInstanceMethodInstr((IRMethod)d.decodeScope());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        IRRuntimeHelpers.defInterpretedInstanceMethod(context, this.method, currDynScope, self2);
        return null;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.DefineInstanceMethodInstr(this);
    }
}

