/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.inputs.http.util;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;

public class ExecutionObserver {
    private final AtomicReference<Execution> tail;
    private final AtomicReference<Execution> head;
    private final LongSupplier nanosSupplier;

    public ExecutionObserver() {
        this(System::nanoTime);
    }

    ExecutionObserver(LongSupplier nanosSupplier) {
        this.nanosSupplier = nanosSupplier;
        Execution anchor = new Execution(nanosSupplier.getAsLong(), true);
        this.tail = new AtomicReference<Execution>(anchor);
        this.head = new AtomicReference<Execution>(anchor);
    }

    public boolean anyExecuting() {
        return this.anyExecuting(Duration.ZERO);
    }

    public boolean anyExecuting(Duration minimumDuration) {
        Execution headExecution = this.compactHead();
        if (headExecution.isComplete) {
            return false;
        }
        return this.nanosSupplier.getAsLong() - headExecution.startNanos >= minimumDuration.toNanos();
    }

    Optional<Duration> longestExecuting() {
        Execution headExecution = this.compactHead();
        if (headExecution.isComplete) {
            return Optional.empty();
        }
        return Optional.of(Duration.ofNanos(this.nanosSupplier.getAsLong() - headExecution.startNanos));
    }

    Stats stats() {
        int nodes = 0;
        int executing = 0;
        Execution candidate = this.head.get();
        while (candidate != null) {
            ++nodes;
            if (!candidate.isComplete) {
                ++executing;
            }
            candidate = (Execution)candidate.next.get();
        }
        return new Stats(nodes, executing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T observeExecution(ExceptionalSupplier<T, E> supplier) throws E {
        Execution execution = this.startExecution();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            boolean isCompact = execution.markComplete();
            if (!isCompact) {
                this.compactHead();
            }
        }
    }

    public <E extends Throwable> void observeExecution(ExceptionalRunnable<E> runnable) throws E {
        this.observeExecution(() -> {
            runnable.run();
            return null;
        });
    }

    Execution startExecution() {
        Execution newTail = new Execution(this.nanosSupplier.getAsLong());
        Execution oldTail = this.tail.getAndSet(newTail);
        oldTail.linkNext(newTail);
        return newTail;
    }

    private Execution compactHead() {
        return this.head.updateAndGet(rec$ -> ((Execution)rec$).seekHead());
    }

    static class Execution {
        private final long startNanos;
        private volatile boolean isComplete;
        private final AtomicReference<Execution> next = new AtomicReference();

        Execution(long startNanos) {
            this(startNanos, false);
        }

        Execution(long startNanos, boolean isComplete) {
            this.startNanos = startNanos;
            this.isComplete = isComplete;
        }

        boolean markComplete() {
            this.isComplete = true;
            Execution preCompletionNext = this.next.get();
            if (preCompletionNext != null) {
                Execution result = this.next.updateAndGet(Execution::seekHead);
                return result != preCompletionNext;
            }
            return false;
        }

        private void linkNext(Execution proposedNext) {
            Execution result = this.next.updateAndGet(ex -> ex == null ? proposedNext : ex);
            if (result != proposedNext) {
                throw new IllegalStateException();
            }
        }

        private Execution seekHead() {
            Execution compactedHead = this;
            Execution candidate = this.next.get();
            while (candidate != null && compactedHead.isComplete) {
                compactedHead = candidate;
                candidate = candidate.next.get();
            }
            return compactedHead;
        }
    }

    static class Stats {
        final int nodes;
        final int executing;

        Stats(int nodes, int executing) {
            this.nodes = nodes;
            this.executing = executing;
        }
    }

    @FunctionalInterface
    public static interface ExceptionalSupplier<T, E extends Throwable> {
        public T get() throws E;
    }

    @FunctionalInterface
    public static interface ExceptionalRunnable<E extends Throwable> {
        public void run() throws E;
    }
}

