/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.monitor.DerbyObservable;
import org.apache.derby.iapi.services.monitor.DerbyObserver;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.StreamContainerHandle;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.raw.data.DropOnCommit;
import org.apache.derby.impl.store.raw.data.StreamFileContainer;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

final class StreamFileContainerHandle
implements StreamContainerHandle,
DerbyObserver {
    private final UUID rawStoreId;
    protected final ContainerKey identity;
    protected boolean active;
    protected StreamFileContainer container;
    protected RawTransaction xact;
    private boolean hold;

    public StreamFileContainerHandle(UUID rawStoreId, RawTransaction xact, ContainerKey identity, boolean hold) {
        this.identity = identity;
        this.xact = xact;
        this.rawStoreId = rawStoreId;
        this.hold = hold;
    }

    public StreamFileContainerHandle(UUID rawStoreId, RawTransaction xact, StreamFileContainer container, boolean hold) {
        this.identity = container.getIdentity();
        this.xact = xact;
        this.rawStoreId = rawStoreId;
        this.hold = hold;
        this.container = container;
    }

    @Override
    public void getContainerProperties(Properties prop) throws StandardException {
        this.container.getContainerProperties(prop);
    }

    @Override
    public boolean fetchNext(DataValueDescriptor[] row) throws StandardException {
        return this.container.fetchNext(row);
    }

    @Override
    public void close() {
        if (this.xact == null) {
            SanityManager.ASSERT((!this.active ? 1 : 0) != 0);
            return;
        }
        this.active = false;
        this.container.close();
        this.container = null;
        this.xact.deleteObserver(this);
        this.xact = null;
    }

    @Override
    public void removeContainer() throws StandardException {
        this.container.removeContainer();
    }

    @Override
    public ContainerKey getId() {
        return this.identity;
    }

    @Override
    public void update(DerbyObservable obj, Object arg) {
        if (arg == null) {
            SanityManager.THROWASSERT((String)("still on observr list " + String.valueOf(this)));
        }
        if (this.xact == null) {
            return;
        }
        if (obj != this.xact) {
            SanityManager.THROWASSERT((String)("Observable passed to update is incorrect expected " + String.valueOf(this.xact) + " got " + String.valueOf(obj)));
        }
        if (arg.equals(RawTransaction.COMMIT) || arg.equals(RawTransaction.ABORT) || arg.equals(this.identity)) {
            this.close();
            return;
        }
        if (arg.equals(RawTransaction.SAVEPOINT_ROLLBACK)) {
            return;
        }
    }

    public boolean useContainer() throws StandardException {
        SanityManager.ASSERT((!this.active ? 1 : 0) != 0);
        SanityManager.ASSERT((this.container != null ? 1 : 0) != 0);
        if (!this.container.use(this)) {
            this.container = null;
            return false;
        }
        this.active = true;
        if (!this.hold) {
            this.xact.addObserver(this);
            this.xact.addObserver(new DropOnCommit(this.identity, true));
        }
        return true;
    }

    public final RawTransaction getTransaction() {
        SanityManager.ASSERT((this.xact != null ? 1 : 0) != 0);
        return this.xact;
    }

    public String toString() {
        String str = "StreamContainerHandle:(" + this.identity.toString() + ")";
        return str;
    }
}

