"use strict";

var _intlMessageformat = _interopRequireDefault(require("intl-messageformat"));
var _intlRelativeformat = _interopRequireDefault(require("intl-relativeformat"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/* eslint-disable */

// Copied from https://github.com/yahoo/intl-relativeformat/tree/master/dist/locale-data

function addLocaleData(localeData) {
  _intlMessageformat.default.__addLocaleData(localeData);
  _intlRelativeformat.default.__addLocaleData(localeData);
}
addLocaleData({
  locale: "de",
  pluralRuleFunction: function (n, ord) {
    var s = String(n).split("."),
      v0 = !s[1];
    if (ord) return "other";
    return n == 1 && v0 ? "one" : "other";
  },
  "fields": {
    "year": {
      "displayName": "Jahr",
      "relative": {
        "0": "dieses Jahr",
        "1": "nächstes Jahr",
        "-1": "letztes Jahr"
      },
      "relativeTime": {
        "future": {
          "one": "in {0} Jahr",
          "other": "in {0} Jahren"
        },
        "past": {
          "one": "vor {0} Jahr",
          "other": "vor {0} Jahren"
        }
      }
    },
    "year-short": {
      "displayName": "Jahr",
      "relative": {
        "0": "dieses Jahr",
        "1": "nächstes Jahr",
        "-1": "letztes Jahr"
      },
      "relativeTime": {
        "future": {
          "one": "in {0} Jahr",
          "other": "in {0} Jahren"
        },
        "past": {
          "one": "vor {0} Jahr",
          "other": "vor {0} Jahren"
        }
      }
    },
    "month": {
      "displayName": "Monat",
      "relative": {
        "0": "diesen Monat",
        "1": "nächsten Monat",
        "-1": "letzten Monat"
      },
      "relativeTime": {
        "future": {
          "one": "in {0} Monat",
          "other": "in {0} Monaten"
        },
        "past": {
          "one": "vor {0} Monat",
          "other": "vor {0} Monaten"
        }
      }
    },
    "month-short": {
      "displayName": "Monat",
      "relative": {
        "0": "diesen Monat",
        "1": "nächsten Monat",
        "-1": "letzten Monat"
      },
      "relativeTime": {
        "future": {
          "one": "in {0} Monat",
          "other": "in {0} Monaten"
        },
        "past": {
          "one": "vor {0} Monat",
          "other": "vor {0} Monaten"
        }
      }
    },
    "day": {
      "displayName": "Tag",
      "relative": {
        "0": "heute",
        "1": "morgen",
        "2": "übermorgen",
        "-2": "vorgestern",
        "-1": "gestern"
      },
      "relativeTime": {
        "future": {
          "one": "in {0} Tag",
          "other": "in {0} Tagen"
        },
        "past": {
          "one": "vor {0} Tag",
          "other": "vor {0} Tagen"
        }
      }
    },
    "day-short": {
      "displayName": "Tag",
      "relative": {
        "0": "heute",
        "1": "morgen",
        "2": "übermorgen",
        "-2": "vorgestern",
        "-1": "gestern"
      },
      "relativeTime": {
        "future": {
          "one": "in {0} Tag",
          "other": "in {0} Tagen"
        },
        "past": {
          "one": "vor {0} Tag",
          "other": "vor {0} Tagen"
        }
      }
    },
    "hour": {
      "displayName": "Stunde",
      "relative": {
        "0": "in dieser Stunde"
      },
      "relativeTime": {
        "future": {
          "one": "in {0} Stunde",
          "other": "in {0} Stunden"
        },
        "past": {
          "one": "vor {0} Stunde",
          "other": "vor {0} Stunden"
        }
      }
    },
    "hour-short": {
      "displayName": "Std.",
      "relative": {
        "0": "in dieser Stunde"
      },
      "relativeTime": {
        "future": {
          "one": "in {0} Std.",
          "other": "in {0} Std."
        },
        "past": {
          "one": "vor {0} Std.",
          "other": "vor {0} Std."
        }
      }
    },
    "minute": {
      "displayName": "Minute",
      "relative": {
        "0": "in dieser Minute"
      },
      "relativeTime": {
        "future": {
          "one": "in {0} Minute",
          "other": "in {0} Minuten"
        },
        "past": {
          "one": "vor {0} Minute",
          "other": "vor {0} Minuten"
        }
      }
    },
    "minute-short": {
      "displayName": "Min.",
      "relative": {
        "0": "in dieser Minute"
      },
      "relativeTime": {
        "future": {
          "one": "in {0} Min.",
          "other": "in {0} Min."
        },
        "past": {
          "one": "vor {0} Min.",
          "other": "vor {0} Min."
        }
      }
    },
    "second": {
      "displayName": "Sekunde",
      "relative": {
        "0": "jetzt"
      },
      "relativeTime": {
        "future": {
          "one": "in {0} Sekunde",
          "other": "in {0} Sekunden"
        },
        "past": {
          "one": "vor {0} Sekunde",
          "other": "vor {0} Sekunden"
        }
      }
    },
    "second-short": {
      "displayName": "Sek.",
      "relative": {
        "0": "jetzt"
      },
      "relativeTime": {
        "future": {
          "one": "in {0} Sek.",
          "other": "in {0} Sek."
        },
        "past": {
          "one": "vor {0} Sek.",
          "other": "vor {0} Sek."
        }
      }
    }
  }
});
addLocaleData({
  locale: "de-DE",
  parentLocale: "de"
});
addLocaleData({
  locale: "en",
  pluralRuleFunction: function (n, ord) {
    var s = String(n).split("."),
      v0 = !s[1],
      t0 = Number(s[0]) == n,
      n10 = t0 && s[0].slice(-1),
      n100 = t0 && s[0].slice(-2);
    if (ord) return n10 == 1 && n100 != 11 ? "one" : n10 == 2 && n100 != 12 ? "two" : n10 == 3 && n100 != 13 ? "few" : "other";
    return n == 1 && v0 ? "one" : "other";
  },
  "fields": {
    "year": {
      "displayName": "year",
      "relative": {
        "0": "this year",
        "1": "next year",
        "-1": "last year"
      },
      "relativeTime": {
        "future": {
          "one": "in {0} year",
          "other": "in {0} years"
        },
        "past": {
          "one": "{0} year ago",
          "other": "{0} years ago"
        }
      }
    },
    "year-short": {
      "displayName": "yr.",
      "relative": {
        "0": "this yr.",
        "1": "next yr.",
        "-1": "last yr."
      },
      "relativeTime": {
        "future": {
          "one": "in {0} yr.",
          "other": "in {0} yr."
        },
        "past": {
          "one": "{0} yr. ago",
          "other": "{0} yr. ago"
        }
      }
    },
    "month": {
      "displayName": "month",
      "relative": {
        "0": "this month",
        "1": "next month",
        "-1": "last month"
      },
      "relativeTime": {
        "future": {
          "one": "in {0} month",
          "other": "in {0} months"
        },
        "past": {
          "one": "{0} month ago",
          "other": "{0} months ago"
        }
      }
    },
    "month-short": {
      "displayName": "mo.",
      "relative": {
        "0": "this mo.",
        "1": "next mo.",
        "-1": "last mo."
      },
      "relativeTime": {
        "future": {
          "one": "in {0} mo.",
          "other": "in {0} mo."
        },
        "past": {
          "one": "{0} mo. ago",
          "other": "{0} mo. ago"
        }
      }
    },
    "day": {
      "displayName": "day",
      "relative": {
        "0": "today",
        "1": "tomorrow",
        "-1": "yesterday"
      },
      "relativeTime": {
        "future": {
          "one": "in {0} day",
          "other": "in {0} days"
        },
        "past": {
          "one": "{0} day ago",
          "other": "{0} days ago"
        }
      }
    },
    "day-short": {
      "displayName": "day",
      "relative": {
        "0": "today",
        "1": "tomorrow",
        "-1": "yesterday"
      },
      "relativeTime": {
        "future": {
          "one": "in {0} day",
          "other": "in {0} days"
        },
        "past": {
          "one": "{0} day ago",
          "other": "{0} days ago"
        }
      }
    },
    "hour": {
      "displayName": "hour",
      "relative": {
        "0": "this hour"
      },
      "relativeTime": {
        "future": {
          "one": "in {0} hour",
          "other": "in {0} hours"
        },
        "past": {
          "one": "{0} hour ago",
          "other": "{0} hours ago"
        }
      }
    },
    "hour-short": {
      "displayName": "hr.",
      "relative": {
        "0": "this hour"
      },
      "relativeTime": {
        "future": {
          "one": "in {0} hr.",
          "other": "in {0} hr."
        },
        "past": {
          "one": "{0} hr. ago",
          "other": "{0} hr. ago"
        }
      }
    },
    "minute": {
      "displayName": "minute",
      "relative": {
        "0": "this minute"
      },
      "relativeTime": {
        "future": {
          "one": "in {0} minute",
          "other": "in {0} minutes"
        },
        "past": {
          "one": "{0} minute ago",
          "other": "{0} minutes ago"
        }
      }
    },
    "minute-short": {
      "displayName": "min.",
      "relative": {
        "0": "this minute"
      },
      "relativeTime": {
        "future": {
          "one": "in {0} min.",
          "other": "in {0} min."
        },
        "past": {
          "one": "{0} min. ago",
          "other": "{0} min. ago"
        }
      }
    },
    "second": {
      "displayName": "second",
      "relative": {
        "0": "now"
      },
      "relativeTime": {
        "future": {
          "one": "in {0} second",
          "other": "in {0} seconds"
        },
        "past": {
          "one": "{0} second ago",
          "other": "{0} seconds ago"
        }
      }
    },
    "second-short": {
      "displayName": "sec.",
      "relative": {
        "0": "now"
      },
      "relativeTime": {
        "future": {
          "one": "in {0} sec.",
          "other": "in {0} sec."
        },
        "past": {
          "one": "{0} sec. ago",
          "other": "{0} sec. ago"
        }
      }
    }
  }
});
addLocaleData({
  locale: "en-US",
  parentLocale: "en"
});
addLocaleData({
  locale: "en-xa",
  pluralRuleFunction: function (n, ord) {
    var s = String(n).split("."),
      v0 = !s[1],
      t0 = Number(s[0]) == n,
      n10 = t0 && s[0].slice(-1),
      n100 = t0 && s[0].slice(-2);
    if (ord) return n10 == 1 && n100 != 11 ? "one" : n10 == 2 && n100 != 12 ? "two" : n10 == 3 && n100 != 13 ? "few" : "other";
    return n == 1 && v0 ? "one" : "other";
  },
  "fields": {
    "year": {
      "displayName": "ýéààŕ",
      "relative": {
        "0": "ţĥîîš ýééàŕ",
        "1": "ñéẋẋţ ýééàŕ",
        "-1": "ļàššţ ýééàŕ"
      },
      "relativeTime": {
        "future": {
          "one": "îñ {0} ýýéàŕŕ",
          "other": "îñ {0} ýýéàŕŕš"
        },
        "past": {
          "one": "{0} ýéààŕ àĝĝô",
          "other": "{0} ýéààŕš ààĝô"
        }
      }
    },
    "year-short": {
      "displayName": "ýŕ.",
      "relative": {
        "0": "ţĥîîš ýŕŕ.",
        "1": "ñéẋẋţ ýŕŕ.",
        "-1": "ļàššţ ýŕŕ."
      },
      "relativeTime": {
        "future": {
          "one": "îñ {0} ýýŕ.",
          "other": "îñ {0} ýýŕ."
        },
        "past": {
          "one": "{0} ýŕ. ààĝô",
          "other": "{0} ýŕ. ààĝô"
        }
      }
    },
    "month": {
      "displayName": "ɱôññţĥ",
      "relative": {
        "0": "ţĥîîš ɱôôñţĥĥ",
        "1": "ñéẋẋţ ɱôôñţĥĥ",
        "-1": "ļàššţ ɱôôñţĥĥ"
      },
      "relativeTime": {
        "future": {
          "one": "îñ {0} ɱɱôñţţĥ",
          "other": "îñ {0} ɱɱôñţţĥš"
        },
        "past": {
          "one": "{0} ɱôññţĥ ààĝô",
          "other": "{0} ɱôññţĥšš àĝôô"
        }
      }
    },
    "month-short": {
      "displayName": "ɱô.",
      "relative": {
        "0": "ţĥîîš ɱôô.",
        "1": "ñéẋẋţ ɱôô.",
        "-1": "ļàššţ ɱôô."
      },
      "relativeTime": {
        "future": {
          "one": "îñ {0} ɱɱô.",
          "other": "îñ {0} ɱɱô."
        },
        "past": {
          "one": "{0} ɱô. ààĝô",
          "other": "{0} ɱô. ààĝô"
        }
      }
    },
    "day": {
      "displayName": "ðàýý",
      "relative": {
        "0": "ţôððàý",
        "1": "ţôɱɱôŕŕŕôŵ",
        "-1": "ýéššţéŕŕðàýý"
      },
      "relativeTime": {
        "future": {
          "one": "îñ {0} ððàý",
          "other": "îñ {0} ððàýšš"
        },
        "past": {
          "one": "{0} ðàýý àĝôô",
          "other": "{0} ðàýýš àĝĝô"
        }
      }
    },
    "day-short": {
      "displayName": "ðàýý",
      "relative": {
        "0": "ţôððàý",
        "1": "ţôɱɱôŕŕŕôŵ",
        "-1": "ýéššţéŕŕðàýý"
      },
      "relativeTime": {
        "future": {
          "one": "îñ {0} ððàý",
          "other": "îñ {0} ððàýšš"
        },
        "past": {
          "one": "{0} ðàýý àĝôô",
          "other": "{0} ðàýýš àĝĝô"
        }
      }
    },
    "hour": {
      "displayName": "ĥôûûŕ",
      "relative": {
        "0": "ţĥîîš ĥôôûŕ"
      },
      "relativeTime": {
        "future": {
          "one": "îñ {0} ĥĥôûŕŕ",
          "other": "îñ {0} ĥĥôûŕŕš"
        },
        "past": {
          "one": "{0} ĥôûûŕ àĝĝô",
          "other": "{0} ĥôûûŕš ààĝô"
        }
      }
    },
    "hour-short": {
      "displayName": "ĥŕ.",
      "relative": {
        "0": "ţĥîîš ĥôôûŕ"
      },
      "relativeTime": {
        "future": {
          "one": "îñ {0} ĥĥŕ.",
          "other": "îñ {0} ĥĥŕ."
        },
        "past": {
          "one": "{0} ĥŕ. ààĝô",
          "other": "{0} ĥŕ. ààĝô"
        }
      }
    },
    "minute": {
      "displayName": "ɱîññûţéé",
      "relative": {
        "0": "ţĥîîš ɱîîñûţţé"
      },
      "relativeTime": {
        "future": {
          "one": "îñ {0} ɱɱîñûûţé",
          "other": "îñ {0} ɱɱîñûûţéšš"
        },
        "past": {
          "one": "{0} ɱîññûţéé àĝôô",
          "other": "{0} ɱîññûţééš àĝĝô"
        }
      }
    },
    "minute-short": {
      "displayName": "ɱîññ.",
      "relative": {
        "0": "ţĥîîš ɱîîñûţţé"
      },
      "relativeTime": {
        "future": {
          "one": "îñ {0} ɱɱîñ.",
          "other": "îñ {0} ɱɱîñ."
        },
        "past": {
          "one": "{0} ɱîññ. àĝôô",
          "other": "{0} ɱîññ. àĝôô"
        }
      }
    },
    "second": {
      "displayName": "šéççôñðð",
      "relative": {
        "0": "ñôŵŵ"
      },
      "relativeTime": {
        "future": {
          "one": "îñ {0} ššéçôôñð",
          "other": "îñ {0} ššéçôôñðšš"
        },
        "past": {
          "one": "{0} šéççôñðð àĝôô",
          "other": "{0} šéççôñððš àĝĝô"
        }
      }
    },
    "second-short": {
      "displayName": "šéçç.",
      "relative": {
        "0": "ñôŵŵ"
      },
      "relativeTime": {
        "future": {
          "one": "îñ {0} ššéç.",
          "other": "îñ {0} ššéç."
        },
        "past": {
          "one": "{0} šéçç. àĝôô",
          "other": "{0} šéçç. àĝôô"
        }
      }
    }
  }
});
addLocaleData({
  locale: "es",
  pluralRuleFunction: function (n, ord) {
    if (ord) return "other";
    return n == 1 ? "one" : "other";
  },
  "fields": {
    "year": {
      "displayName": "año",
      "relative": {
        "0": "este año",
        "1": "el próximo año",
        "-1": "el año pasado"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} año",
          "other": "dentro de {0} años"
        },
        "past": {
          "one": "hace {0} año",
          "other": "hace {0} años"
        }
      }
    },
    "year-short": {
      "displayName": "a",
      "relative": {
        "0": "este año",
        "1": "el próximo año",
        "-1": "el año pasado"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} a",
          "other": "dentro de {0} a"
        },
        "past": {
          "one": "hace {0} a",
          "other": "hace {0} a"
        }
      }
    },
    "month": {
      "displayName": "mes",
      "relative": {
        "0": "este mes",
        "1": "el próximo mes",
        "-1": "el mes pasado"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} mes",
          "other": "dentro de {0} meses"
        },
        "past": {
          "one": "hace {0} mes",
          "other": "hace {0} meses"
        }
      }
    },
    "month-short": {
      "displayName": "m",
      "relative": {
        "0": "este mes",
        "1": "el próximo mes",
        "-1": "el mes pasado"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} m",
          "other": "dentro de {0} m"
        },
        "past": {
          "one": "hace {0} m",
          "other": "hace {0} m"
        }
      }
    },
    "day": {
      "displayName": "día",
      "relative": {
        "0": "hoy",
        "1": "mañana",
        "2": "pasado mañana",
        "-2": "anteayer",
        "-1": "ayer"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} día",
          "other": "dentro de {0} días"
        },
        "past": {
          "one": "hace {0} día",
          "other": "hace {0} días"
        }
      }
    },
    "day-short": {
      "displayName": "d",
      "relative": {
        "0": "hoy",
        "1": "mañana",
        "2": "pasado mañana",
        "-2": "anteayer",
        "-1": "ayer"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} día",
          "other": "dentro de {0} días"
        },
        "past": {
          "one": "hace {0} día",
          "other": "hace {0} días"
        }
      }
    },
    "hour": {
      "displayName": "hora",
      "relative": {
        "0": "esta hora"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} hora",
          "other": "dentro de {0} horas"
        },
        "past": {
          "one": "hace {0} hora",
          "other": "hace {0} horas"
        }
      }
    },
    "hour-short": {
      "displayName": "h",
      "relative": {
        "0": "esta hora"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} h",
          "other": "dentro de {0} h"
        },
        "past": {
          "one": "hace {0} h",
          "other": "hace {0} h"
        }
      }
    },
    "minute": {
      "displayName": "minuto",
      "relative": {
        "0": "este minuto"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} minuto",
          "other": "dentro de {0} minutos"
        },
        "past": {
          "one": "hace {0} minuto",
          "other": "hace {0} minutos"
        }
      }
    },
    "minute-short": {
      "displayName": "min",
      "relative": {
        "0": "este minuto"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} min",
          "other": "dentro de {0} min"
        },
        "past": {
          "one": "hace {0} min",
          "other": "hace {0} min"
        }
      }
    },
    "second": {
      "displayName": "segundo",
      "relative": {
        "0": "ahora"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} segundo",
          "other": "dentro de {0} segundos"
        },
        "past": {
          "one": "hace {0} segundo",
          "other": "hace {0} segundos"
        }
      }
    },
    "second-short": {
      "displayName": "s",
      "relative": {
        "0": "ahora"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} s",
          "other": "dentro de {0} s"
        },
        "past": {
          "one": "hace {0} s",
          "other": "hace {0} s"
        }
      }
    }
  }
});
addLocaleData({
  locale: "es-419",
  parentLocale: "es",
  "fields": {
    "year": {
      "displayName": "año",
      "relative": {
        "0": "este año",
        "1": "el próximo año",
        "-1": "el año pasado"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} año",
          "other": "dentro de {0} años"
        },
        "past": {
          "one": "hace {0} año",
          "other": "hace {0} años"
        }
      }
    },
    "year-short": {
      "displayName": "a",
      "relative": {
        "0": "este año",
        "1": "el próximo año",
        "-1": "el año pasado"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} a",
          "other": "dentro de {0} a"
        },
        "past": {
          "one": "hace {0} a",
          "other": "hace {0} a"
        }
      }
    },
    "month": {
      "displayName": "mes",
      "relative": {
        "0": "este mes",
        "1": "el próximo mes",
        "-1": "el mes pasado"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} mes",
          "other": "dentro de {0} meses"
        },
        "past": {
          "one": "hace {0} mes",
          "other": "hace {0} meses"
        }
      }
    },
    "month-short": {
      "displayName": "m",
      "relative": {
        "0": "este mes",
        "1": "el próximo mes",
        "-1": "el mes pasado"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} m",
          "other": "dentro de {0} m"
        },
        "past": {
          "one": "hace {0} m",
          "other": "hace {0} m"
        }
      }
    },
    "week": {
      "displayName": "semana",
      "relativePeriod": "la semana del {0}",
      "relative": {
        "0": "esta semana",
        "1": "la próxima semana",
        "-1": "la semana pasada"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} semana",
          "other": "dentro de {0} semanas"
        },
        "past": {
          "one": "hace {0} semana",
          "other": "hace {0} semanas"
        }
      }
    },
    "week-short": {
      "displayName": "sem.",
      "relativePeriod": "la semana del {0}",
      "relative": {
        "0": "esta semana",
        "1": "la próxima semana",
        "-1": "la semana pasada"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} sem.",
          "other": "dentro de {0} sem."
        },
        "past": {
          "one": "hace {0} sem.",
          "other": "hace {0} sem."
        }
      }
    },
    "day": {
      "displayName": "día",
      "relative": {
        "0": "hoy",
        "1": "mañana",
        "2": "pasado mañana",
        "-2": "anteayer",
        "-1": "ayer"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} día",
          "other": "dentro de {0} días"
        },
        "past": {
          "one": "hace {0} día",
          "other": "hace {0} días"
        }
      }
    },
    "day-short": {
      "displayName": "d",
      "relative": {
        "0": "hoy",
        "1": "mañana",
        "2": "pasado mañana",
        "-2": "anteayer",
        "-1": "ayer"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} día",
          "other": "dentro de {0} días"
        },
        "past": {
          "one": "hace {0} día",
          "other": "hace {0} días"
        }
      }
    },
    "hour": {
      "displayName": "hora",
      "relative": {
        "0": "esta hora"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} hora",
          "other": "dentro de {0} horas"
        },
        "past": {
          "one": "hace {0} hora",
          "other": "hace {0} horas"
        }
      }
    },
    "hour-short": {
      "displayName": "h",
      "relative": {
        "0": "esta hora"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} h",
          "other": "dentro de {0} h"
        },
        "past": {
          "one": "hace {0} h",
          "other": "hace {0} h"
        }
      }
    },
    "minute": {
      "displayName": "minuto",
      "relative": {
        "0": "este minuto"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} minuto",
          "other": "dentro de {0} minutos"
        },
        "past": {
          "one": "hace {0} minuto",
          "other": "hace {0} minutos"
        }
      }
    },
    "minute-short": {
      "displayName": "min",
      "relative": {
        "0": "este minuto"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} min",
          "other": "dentro de {0} min"
        },
        "past": {
          "one": "hace {0} min",
          "other": "hace {0} min"
        }
      }
    },
    "second": {
      "displayName": "segundo",
      "relative": {
        "0": "ahora"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} segundo",
          "other": "dentro de {0} segundos"
        },
        "past": {
          "one": "hace {0} segundo",
          "other": "hace {0} segundos"
        }
      }
    },
    "second-short": {
      "displayName": "s",
      "relative": {
        "0": "ahora"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} s",
          "other": "dentro de {0} s"
        },
        "past": {
          "one": "hace {0} s",
          "other": "hace {0} s"
        }
      }
    }
  }
});
addLocaleData({
  locale: "es-ES",
  parentLocale: "es"
});
addLocaleData({
  locale: "es-LA",
  parentLocale: "es"
});
addLocaleData({
  locale: "fr",
  pluralRuleFunction: function (n, ord) {
    if (ord) return n == 1 ? "one" : "other";
    return n >= 0 && n < 2 ? "one" : "other";
  },
  "fields": {
    "year": {
      "displayName": "année",
      "relative": {
        "0": "cette année",
        "1": "l’année prochaine",
        "-1": "l’année dernière"
      },
      "relativeTime": {
        "future": {
          "one": "dans {0} an",
          "other": "dans {0} ans"
        },
        "past": {
          "one": "il y a {0} an",
          "other": "il y a {0} ans"
        }
      }
    },
    "year-short": {
      "displayName": "an",
      "relative": {
        "0": "cette année",
        "1": "l’année prochaine",
        "-1": "l’année dernière"
      },
      "relativeTime": {
        "future": {
          "one": "dans {0} a",
          "other": "dans {0} a"
        },
        "past": {
          "one": "il y a {0} a",
          "other": "il y a {0} a"
        }
      }
    },
    "month": {
      "displayName": "mois",
      "relative": {
        "0": "ce mois-ci",
        "1": "le mois prochain",
        "-1": "le mois dernier"
      },
      "relativeTime": {
        "future": {
          "one": "dans {0} mois",
          "other": "dans {0} mois"
        },
        "past": {
          "one": "il y a {0} mois",
          "other": "il y a {0} mois"
        }
      }
    },
    "month-short": {
      "displayName": "m.",
      "relative": {
        "0": "ce mois-ci",
        "1": "le mois prochain",
        "-1": "le mois dernier"
      },
      "relativeTime": {
        "future": {
          "one": "dans {0} m.",
          "other": "dans {0} m."
        },
        "past": {
          "one": "il y a {0} m.",
          "other": "il y a {0} m."
        }
      }
    },
    "day": {
      "displayName": "jour",
      "relative": {
        "0": "aujourd’hui",
        "1": "demain",
        "2": "après-demain",
        "-2": "avant-hier",
        "-1": "hier"
      },
      "relativeTime": {
        "future": {
          "one": "dans {0} jour",
          "other": "dans {0} jours"
        },
        "past": {
          "one": "il y a {0} jour",
          "other": "il y a {0} jours"
        }
      }
    },
    "day-short": {
      "displayName": "j",
      "relative": {
        "0": "aujourd’hui",
        "1": "demain",
        "2": "après-demain",
        "-2": "avant-hier",
        "-1": "hier"
      },
      "relativeTime": {
        "future": {
          "one": "dans {0} j",
          "other": "dans {0} j"
        },
        "past": {
          "one": "il y a {0} j",
          "other": "il y a {0} j"
        }
      }
    },
    "hour": {
      "displayName": "heure",
      "relative": {
        "0": "cette heure-ci"
      },
      "relativeTime": {
        "future": {
          "one": "dans {0} heure",
          "other": "dans {0} heures"
        },
        "past": {
          "one": "il y a {0} heure",
          "other": "il y a {0} heures"
        }
      }
    },
    "hour-short": {
      "displayName": "h",
      "relative": {
        "0": "cette heure-ci"
      },
      "relativeTime": {
        "future": {
          "one": "dans {0} h",
          "other": "dans {0} h"
        },
        "past": {
          "one": "il y a {0} h",
          "other": "il y a {0} h"
        }
      }
    },
    "minute": {
      "displayName": "minute",
      "relative": {
        "0": "cette minute-ci"
      },
      "relativeTime": {
        "future": {
          "one": "dans {0} minute",
          "other": "dans {0} minutes"
        },
        "past": {
          "one": "il y a {0} minute",
          "other": "il y a {0} minutes"
        }
      }
    },
    "minute-short": {
      "displayName": "min",
      "relative": {
        "0": "cette minute-ci"
      },
      "relativeTime": {
        "future": {
          "one": "dans {0} min",
          "other": "dans {0} min"
        },
        "past": {
          "one": "il y a {0} min",
          "other": "il y a {0} min"
        }
      }
    },
    "second": {
      "displayName": "seconde",
      "relative": {
        "0": "maintenant"
      },
      "relativeTime": {
        "future": {
          "one": "dans {0} seconde",
          "other": "dans {0} secondes"
        },
        "past": {
          "one": "il y a {0} seconde",
          "other": "il y a {0} secondes"
        }
      }
    },
    "second-short": {
      "displayName": "s",
      "relative": {
        "0": "maintenant"
      },
      "relativeTime": {
        "future": {
          "one": "dans {0} s",
          "other": "dans {0} s"
        },
        "past": {
          "one": "il y a {0} s",
          "other": "il y a {0} s"
        }
      }
    }
  }
});
addLocaleData({
  locale: "fr-CA",
  parentLocale: "fr",
  "fields": {
    "year": {
      "displayName": "année",
      "relative": {
        "0": "cette année",
        "1": "l’année prochaine",
        "-1": "l’année dernière"
      },
      "relativeTime": {
        "future": {
          "one": "Dans {0} an",
          "other": "Dans {0} ans"
        },
        "past": {
          "one": "Il y a {0} an",
          "other": "Il y a {0} ans"
        }
      }
    },
    "year-short": {
      "displayName": "a",
      "relative": {
        "0": "cette année",
        "1": "l’année prochaine",
        "-1": "l’année dernière"
      },
      "relativeTime": {
        "future": {
          "one": "dans {0} a",
          "other": "dans {0} a"
        },
        "past": {
          "one": "il y a {0} a",
          "other": "il y a {0} a"
        }
      }
    },
    "month": {
      "displayName": "mois",
      "relative": {
        "0": "ce mois-ci",
        "1": "le mois prochain",
        "-1": "le mois dernier"
      },
      "relativeTime": {
        "future": {
          "one": "dans {0} mois",
          "other": "dans {0} mois"
        },
        "past": {
          "one": "il y a {0} mois",
          "other": "il y a {0} mois"
        }
      }
    },
    "month-short": {
      "displayName": "m.",
      "relative": {
        "0": "ce mois-ci",
        "1": "le mois prochain",
        "-1": "le mois dernier"
      },
      "relativeTime": {
        "future": {
          "one": "dans {0} m.",
          "other": "dans {0} m."
        },
        "past": {
          "one": "il y a {0} m.",
          "other": "il y a {0} m."
        }
      }
    },
    "week": {
      "displayName": "semaine",
      "relativePeriod": "la semaine du {0}",
      "relative": {
        "0": "cette semaine",
        "1": "la semaine prochaine",
        "-1": "la semaine dernière"
      },
      "relativeTime": {
        "future": {
          "one": "dans {0} semaine",
          "other": "dans {0} semaines"
        },
        "past": {
          "one": "il y a {0} semaine",
          "other": "il y a {0} semaines"
        }
      }
    },
    "week-short": {
      "displayName": "sem.",
      "relativePeriod": "sem. du {0}",
      "relative": {
        "0": "cette semaine",
        "1": "la semaine prochaine",
        "-1": "la semaine dernière"
      },
      "relativeTime": {
        "future": {
          "one": "dans {0} sem.",
          "other": "dans {0} sem."
        },
        "past": {
          "one": "il y a {0} sem.",
          "other": "il y a {0} sem."
        }
      }
    },
    "day": {
      "displayName": "jour",
      "relative": {
        "0": "aujourd’hui",
        "1": "demain",
        "2": "après-demain",
        "-2": "avant-hier",
        "-1": "hier"
      },
      "relativeTime": {
        "future": {
          "one": "dans {0} jour",
          "other": "dans {0} jours"
        },
        "past": {
          "one": "il y a {0} jour",
          "other": "il y a {0} jours"
        }
      }
    },
    "day-short": {
      "displayName": "j",
      "relative": {
        "0": "aujourd’hui",
        "1": "demain",
        "2": "après-demain",
        "-2": "avant-hier",
        "-1": "hier"
      },
      "relativeTime": {
        "future": {
          "one": "dans {0} j",
          "other": "dans {0} j"
        },
        "past": {
          "one": "il y a {0} j",
          "other": "il y a {0} j"
        }
      }
    },
    "hour": {
      "displayName": "heure",
      "relative": {
        "0": "cette heure-ci"
      },
      "relativeTime": {
        "future": {
          "one": "dans {0} heure",
          "other": "dans {0} heures"
        },
        "past": {
          "one": "il y a {0} heure",
          "other": "il y a {0} heures"
        }
      }
    },
    "hour-short": {
      "displayName": "h",
      "relative": {
        "0": "cette heure-ci"
      },
      "relativeTime": {
        "future": {
          "one": "dans {0} h",
          "other": "dans {0} h"
        },
        "past": {
          "one": "il y a {0} h",
          "other": "il y a {0} h"
        }
      }
    },
    "minute": {
      "displayName": "minute",
      "relative": {
        "0": "cette minute-ci"
      },
      "relativeTime": {
        "future": {
          "one": "dans {0} minute",
          "other": "dans {0} minutes"
        },
        "past": {
          "one": "il y a {0} minute",
          "other": "il y a {0} minutes"
        }
      }
    },
    "minute-short": {
      "displayName": "min",
      "relative": {
        "0": "cette minute-ci"
      },
      "relativeTime": {
        "future": {
          "one": "dans {0} min",
          "other": "dans {0} min"
        },
        "past": {
          "one": "il y a {0} min",
          "other": "il y a {0} min"
        }
      }
    },
    "second": {
      "displayName": "seconde",
      "relative": {
        "0": "maintenant"
      },
      "relativeTime": {
        "future": {
          "one": "dans {0} seconde",
          "other": "dans {0} secondes"
        },
        "past": {
          "one": "il y a {0} seconde",
          "other": "il y a {0} secondes"
        }
      }
    },
    "second-short": {
      "displayName": "s",
      "relative": {
        "0": "maintenant"
      },
      "relativeTime": {
        "future": {
          "one": "dans {0} s",
          "other": "dans {0} s"
        },
        "past": {
          "one": "il y a {0} s",
          "other": "il y a {0} s"
        }
      }
    }
  }
});
addLocaleData({
  locale: "fr-FR",
  parentLocale: "fr"
});
addLocaleData({
  locale: "id",
  pluralRuleFunction: function (n, ord) {
    if (ord) return 'other';
    return 'other';
  },
  "fields": {
    "year": {
      "displayName": "tahun",
      "relative": {
        "0": "tahun ini",
        "1": "tahun depan",
        "-1": "tahun lalu"
      },
      "relativeTime": {
        "future": {
          "other": "dalam {0} tahun"
        },
        "past": {
          "other": "{0} tahun yang lalu"
        }
      }
    },
    "year-short": {
      "displayName": "thn.",
      "relative": {
        "0": "tahun ini",
        "1": "tahun depan",
        "-1": "tahun lalu"
      },
      "relativeTime": {
        "future": {
          "other": "dlm {0} thn"
        },
        "past": {
          "other": "{0} thn lalu"
        }
      }
    },
    "month": {
      "displayName": "bulan",
      "relative": {
        "0": "bulan ini",
        "1": "bulan berikutnya",
        "-1": "bulan lalu"
      },
      "relativeTime": {
        "future": {
          "other": "dalam {0} bulan"
        },
        "past": {
          "other": "{0} bulan yang lalu"
        }
      }
    },
    "month-short": {
      "displayName": "bln.",
      "relative": {
        "0": "bulan ini",
        "1": "bulan berikutnya",
        "-1": "bulan lalu"
      },
      "relativeTime": {
        "future": {
          "other": "dlm {0} bln"
        },
        "past": {
          "other": "{0} bln lalu"
        }
      }
    },
    "week": {
      "displayName": "minggu",
      "relativePeriod": "minggu ke-{0}",
      "relative": {
        "0": "minggu ini",
        "1": "minggu depan",
        "-1": "minggu lalu"
      },
      "relativeTime": {
        "future": {
          "other": "dalam {0} minggu"
        },
        "past": {
          "other": "{0} minggu yang lalu"
        }
      }
    },
    "week-short": {
      "displayName": "mgg.",
      "relativePeriod": "mgg ke-{0}",
      "relative": {
        "0": "minggu ini",
        "1": "minggu depan",
        "-1": "minggu lalu"
      },
      "relativeTime": {
        "future": {
          "other": "dlm {0} mgg"
        },
        "past": {
          "other": "{0} mgg lalu"
        }
      }
    },
    "day": {
      "displayName": "hari",
      "relative": {
        "0": "hari ini",
        "1": "besok",
        "2": "lusa",
        "-2": "kemarin dulu",
        "-1": "kemarin"
      },
      "relativeTime": {
        "future": {
          "other": "dalam {0} hari"
        },
        "past": {
          "other": "{0} hari yang lalu"
        }
      }
    },
    "day-short": {
      "displayName": "h",
      "relative": {
        "0": "hari ini",
        "1": "besok",
        "2": "lusa",
        "-2": "kemarin dulu",
        "-1": "kemarin"
      },
      "relativeTime": {
        "future": {
          "other": "dalam {0} h"
        },
        "past": {
          "other": "{0} h lalu"
        }
      }
    },
    "hour": {
      "displayName": "Jam",
      "relative": {
        "0": "jam ini"
      },
      "relativeTime": {
        "future": {
          "other": "dalam {0} jam"
        },
        "past": {
          "other": "{0} jam yang lalu"
        }
      }
    },
    "hour-short": {
      "displayName": "jam",
      "relative": {
        "0": "jam ini"
      },
      "relativeTime": {
        "future": {
          "other": "dalam {0} jam"
        },
        "past": {
          "other": "{0} jam lalu"
        }
      }
    },
    "minute": {
      "displayName": "menit",
      "relative": {
        "0": "menit ini"
      },
      "relativeTime": {
        "future": {
          "other": "dalam {0} menit"
        },
        "past": {
          "other": "{0} menit yang lalu"
        }
      }
    },
    "minute-short": {
      "displayName": "mnt.",
      "relative": {
        "0": "menit ini"
      },
      "relativeTime": {
        "future": {
          "other": "dlm {0} mnt"
        },
        "past": {
          "other": "{0} mnt lalu"
        }
      }
    },
    "second": {
      "displayName": "detik",
      "relative": {
        "0": "sekarang"
      },
      "relativeTime": {
        "future": {
          "other": "dalam {0} detik"
        },
        "past": {
          "other": "{0} detik yang lalu"
        }
      }
    },
    "second-short": {
      "displayName": "dtk.",
      "relative": {
        "0": "sekarang"
      },
      "relativeTime": {
        "future": {
          "other": "dlm {0} dtk"
        },
        "past": {
          "other": "{0} dtk lalu"
        }
      }
    }
  }
});
addLocaleData({
  locale: "id-ID",
  parentLocale: "id"
});
addLocaleData({
  locale: "it",
  pluralRuleFunction: function (n, ord) {
    var s = String(n).split('.'),
      v0 = !s[1];
    if (ord) return n == 11 || n == 8 || n == 80 || n == 800 ? 'many' : 'other';
    return n == 1 && v0 ? 'one' : 'other';
  },
  "fields": {
    "year": {
      "displayName": "anno",
      "relative": {
        "0": "quest’anno",
        "1": "anno prossimo",
        "-1": "anno scorso"
      },
      "relativeTime": {
        "future": {
          "one": "tra {0} anno",
          "other": "tra {0} anni"
        },
        "past": {
          "one": "{0} anno fa",
          "other": "{0} anni fa"
        }
      }
    },
    "year-short": {
      "displayName": "anno",
      "relative": {
        "0": "quest’anno",
        "1": "anno prossimo",
        "-1": "anno scorso"
      },
      "relativeTime": {
        "future": {
          "one": "tra {0} anno",
          "other": "tra {0} anni"
        },
        "past": {
          "one": "{0} anno fa",
          "other": "{0} anni fa"
        }
      }
    },
    "month": {
      "displayName": "mese",
      "relative": {
        "0": "questo mese",
        "1": "mese prossimo",
        "-1": "mese scorso"
      },
      "relativeTime": {
        "future": {
          "one": "tra {0} mese",
          "other": "tra {0} mesi"
        },
        "past": {
          "one": "{0} mese fa",
          "other": "{0} mesi fa"
        }
      }
    },
    "month-short": {
      "displayName": "mese",
      "relative": {
        "0": "questo mese",
        "1": "mese prossimo",
        "-1": "mese scorso"
      },
      "relativeTime": {
        "future": {
          "one": "tra {0} mese",
          "other": "tra {0} mesi"
        },
        "past": {
          "one": "{0} mese fa",
          "other": "{0} mesi fa"
        }
      }
    },
    "week": {
      "displayName": "settimana",
      "relativePeriod": "la settimana del {0}",
      "relative": {
        "0": "questa settimana",
        "1": "settimana prossima",
        "-1": "settimana scorsa"
      },
      "relativeTime": {
        "future": {
          "one": "tra {0} settimana",
          "other": "tra {0} settimane"
        },
        "past": {
          "one": "{0} settimana fa",
          "other": "{0} settimane fa"
        }
      }
    },
    "week-short": {
      "displayName": "sett.",
      "relativePeriod": "la settimana del {0}",
      "relative": {
        "0": "questa settimana",
        "1": "settimana prossima",
        "-1": "settimana scorsa"
      },
      "relativeTime": {
        "future": {
          "one": "tra {0} sett.",
          "other": "tra {0} sett."
        },
        "past": {
          "one": "{0} sett. fa",
          "other": "{0} sett. fa"
        }
      }
    },
    "day": {
      "displayName": "giorno",
      "relative": {
        "0": "oggi",
        "1": "domani",
        "2": "dopodomani",
        "-2": "l’altro ieri",
        "-1": "ieri"
      },
      "relativeTime": {
        "future": {
          "one": "tra {0} giorno",
          "other": "tra {0} giorni"
        },
        "past": {
          "one": "{0} giorno fa",
          "other": "{0} giorni fa"
        }
      }
    },
    "day-short": {
      "displayName": "g",
      "relative": {
        "0": "oggi",
        "1": "domani",
        "2": "dopodomani",
        "-2": "l’altro ieri",
        "-1": "ieri"
      },
      "relativeTime": {
        "future": {
          "one": "tra {0} g",
          "other": "tra {0} gg"
        },
        "past": {
          "one": "{0} g fa",
          "other": "{0} gg fa"
        }
      }
    },
    "hour": {
      "displayName": "ora",
      "relative": {
        "0": "quest’ora"
      },
      "relativeTime": {
        "future": {
          "one": "tra {0} ora",
          "other": "tra {0} ore"
        },
        "past": {
          "one": "{0} ora fa",
          "other": "{0} ore fa"
        }
      }
    },
    "hour-short": {
      "displayName": "h.",
      "relative": {
        "0": "quest’ora"
      },
      "relativeTime": {
        "future": {
          "one": "tra {0} h",
          "other": "tra {0} h"
        },
        "past": {
          "one": "{0} h fa",
          "other": "{0} h fa"
        }
      }
    },
    "minute": {
      "displayName": "minuto",
      "relative": {
        "0": "questo minuto"
      },
      "relativeTime": {
        "future": {
          "one": "tra {0} minuto",
          "other": "tra {0} minuti"
        },
        "past": {
          "one": "{0} minuto fa",
          "other": "{0} minuti fa"
        }
      }
    },
    "minute-short": {
      "displayName": "min",
      "relative": {
        "0": "questo minuto"
      },
      "relativeTime": {
        "future": {
          "one": "tra {0} min",
          "other": "tra {0} min"
        },
        "past": {
          "one": "{0} min fa",
          "other": "{0} min fa"
        }
      }
    },
    "second": {
      "displayName": "secondo",
      "relative": {
        "0": "ora"
      },
      "relativeTime": {
        "future": {
          "one": "tra {0} secondo",
          "other": "tra {0} secondi"
        },
        "past": {
          "one": "{0} secondo fa",
          "other": "{0} secondi fa"
        }
      }
    },
    "second-short": {
      "displayName": "s",
      "relative": {
        "0": "ora"
      },
      "relativeTime": {
        "future": {
          "one": "tra {0} s",
          "other": "tra {0} sec."
        },
        "past": {
          "one": "{0} s fa",
          "other": "{0} sec. fa"
        }
      }
    }
  }
});
addLocaleData({
  locale: "it-CH",
  parentLocale: "it"
});
addLocaleData({
  locale: "it-IT",
  parentLocale: "it"
});
addLocaleData({
  locale: "it-SM",
  parentLocale: "it"
});
addLocaleData({
  locale: "it-VA",
  parentLocale: "it"
});
addLocaleData({
  locale: "ja",
  pluralRuleFunction: function (n, ord) {
    if (ord) return "other";
    return "other";
  },
  "fields": {
    "year": {
      "displayName": "年",
      "relative": {
        "0": "今年",
        "1": "翌年",
        "-1": "昨年"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 年後"
        },
        "past": {
          "other": "{0} 年前"
        }
      }
    },
    "year-short": {
      "displayName": "年",
      "relative": {
        "0": "今年",
        "1": "翌年",
        "-1": "昨年"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 年後"
        },
        "past": {
          "other": "{0} 年前"
        }
      }
    },
    "month": {
      "displayName": "月",
      "relative": {
        "0": "今月",
        "1": "翌月",
        "-1": "先月"
      },
      "relativeTime": {
        "future": {
          "other": "{0} か月後"
        },
        "past": {
          "other": "{0} か月前"
        }
      }
    },
    "month-short": {
      "displayName": "月",
      "relative": {
        "0": "今月",
        "1": "翌月",
        "-1": "先月"
      },
      "relativeTime": {
        "future": {
          "other": "{0} か月後"
        },
        "past": {
          "other": "{0} か月前"
        }
      }
    },
    "day": {
      "displayName": "日",
      "relative": {
        "0": "今日",
        "1": "明日",
        "2": "明後日",
        "-2": "一昨日",
        "-1": "昨日"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 日後"
        },
        "past": {
          "other": "{0} 日前"
        }
      }
    },
    "day-short": {
      "displayName": "日",
      "relative": {
        "0": "今日",
        "1": "明日",
        "2": "明後日",
        "-2": "一昨日",
        "-1": "昨日"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 日後"
        },
        "past": {
          "other": "{0} 日前"
        }
      }
    },
    "hour": {
      "displayName": "時",
      "relative": {
        "0": "1 時間以内"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 時間後"
        },
        "past": {
          "other": "{0} 時間前"
        }
      }
    },
    "hour-short": {
      "displayName": "時",
      "relative": {
        "0": "1 時間以内"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 時間後"
        },
        "past": {
          "other": "{0} 時間前"
        }
      }
    },
    "minute": {
      "displayName": "分",
      "relative": {
        "0": "1 分以内"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 分後"
        },
        "past": {
          "other": "{0} 分前"
        }
      }
    },
    "minute-short": {
      "displayName": "分",
      "relative": {
        "0": "1 分以内"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 分後"
        },
        "past": {
          "other": "{0} 分前"
        }
      }
    },
    "second": {
      "displayName": "秒",
      "relative": {
        "0": "今"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 秒後"
        },
        "past": {
          "other": "{0} 秒前"
        }
      }
    },
    "second-short": {
      "displayName": "秒",
      "relative": {
        "0": "今"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 秒後"
        },
        "past": {
          "other": "{0} 秒前"
        }
      }
    }
  }
});
addLocaleData({
  locale: "ja-JP",
  parentLocale: "ja"
});
addLocaleData({
  locale: "ko",
  pluralRuleFunction: function (n, ord) {
    if (ord) return "other";
    return "other";
  },
  "fields": {
    "year": {
      "displayName": "년",
      "relative": {
        "0": "올해",
        "1": "내년",
        "-1": "작년"
      },
      "relativeTime": {
        "future": {
          "other": "{0}년 후"
        },
        "past": {
          "other": "{0}년 전"
        }
      }
    },
    "year-short": {
      "displayName": "년",
      "relative": {
        "0": "올해",
        "1": "내년",
        "-1": "작년"
      },
      "relativeTime": {
        "future": {
          "other": "{0}년 후"
        },
        "past": {
          "other": "{0}년 전"
        }
      }
    },
    "month": {
      "displayName": "월",
      "relative": {
        "0": "이번 달",
        "1": "다음 달",
        "-1": "지난달"
      },
      "relativeTime": {
        "future": {
          "other": "{0}개월 후"
        },
        "past": {
          "other": "{0}개월 전"
        }
      }
    },
    "month-short": {
      "displayName": "월",
      "relative": {
        "0": "이번 달",
        "1": "다음 달",
        "-1": "지난달"
      },
      "relativeTime": {
        "future": {
          "other": "{0}개월 후"
        },
        "past": {
          "other": "{0}개월 전"
        }
      }
    },
    "day": {
      "displayName": "일",
      "relative": {
        "0": "오늘",
        "1": "내일",
        "2": "모레",
        "-2": "그저께",
        "-1": "어제"
      },
      "relativeTime": {
        "future": {
          "other": "{0}일 후"
        },
        "past": {
          "other": "{0}일 전"
        }
      }
    },
    "day-short": {
      "displayName": "일",
      "relative": {
        "0": "오늘",
        "1": "내일",
        "2": "모레",
        "-2": "그저께",
        "-1": "어제"
      },
      "relativeTime": {
        "future": {
          "other": "{0}일 후"
        },
        "past": {
          "other": "{0}일 전"
        }
      }
    },
    "hour": {
      "displayName": "시",
      "relative": {
        "0": "현재 시간"
      },
      "relativeTime": {
        "future": {
          "other": "{0}시간 후"
        },
        "past": {
          "other": "{0}시간 전"
        }
      }
    },
    "hour-short": {
      "displayName": "시",
      "relative": {
        "0": "현재 시간"
      },
      "relativeTime": {
        "future": {
          "other": "{0}시간 후"
        },
        "past": {
          "other": "{0}시간 전"
        }
      }
    },
    "minute": {
      "displayName": "분",
      "relative": {
        "0": "현재 분"
      },
      "relativeTime": {
        "future": {
          "other": "{0}분 후"
        },
        "past": {
          "other": "{0}분 전"
        }
      }
    },
    "minute-short": {
      "displayName": "분",
      "relative": {
        "0": "현재 분"
      },
      "relativeTime": {
        "future": {
          "other": "{0}분 후"
        },
        "past": {
          "other": "{0}분 전"
        }
      }
    },
    "second": {
      "displayName": "초",
      "relative": {
        "0": "지금"
      },
      "relativeTime": {
        "future": {
          "other": "{0}초 후"
        },
        "past": {
          "other": "{0}초 전"
        }
      }
    },
    "second-short": {
      "displayName": "초",
      "relative": {
        "0": "지금"
      },
      "relativeTime": {
        "future": {
          "other": "{0}초 후"
        },
        "past": {
          "other": "{0}초 전"
        }
      }
    }
  }
});
addLocaleData({
  locale: "ko-KR",
  parentLocale: "ko"
});
addLocaleData({
  locale: "pl",
  pluralRuleFunction: function (n, ord) {
    var s = String(n).split("."),
      v0 = !s[1],
      t0 = Number(s[0]) == n,
      n10 = t0 && s[0].slice(-1),
      n100 = t0 && s[0].slice(-2);
    if (ord) return n10 == 1 && n100 != 11 ? "jeden" : n10 == 2 && n100 != 12 ? "dwa" : n10 == 3 && n100 != 13 ? "kilka" : "inny";
    return n == 1 && v0 ? "jeden" : "inny";
  },
  "fields": {
    "rok": {
      "displayName": "rok",
      "relative": {
        "0": "ten rok",
        "1": "następny rok",
        "-1": "poprzedni rok"
      },
      "relativeTime": {
        "future": {
          "jeden": "za {0} rok",
          "other": "za {0} lat"
        },
        "past": {
          "jeden": "{0} rok temu",
          "other": "{0} lata temu"
        }
      }
    },
    "year-short": {
      "displayName": "rok",
      "relative": {
        "0": "ten rok",
        "1": "następny rok",
        "-1": "poprzedni rok"
      },
      "relativeTime": {
        "future": {
          "one": "za {0} r.",
          "other": "za {0} l."
        },
        "past": {
          "one": "{0} r. temu",
          "other": "{0} l. temu"
        }
      }
    },
    "month": {
      "displayName": "miesiąc",
      "relative": {
        "0": "ten miesiąc",
        "1": "następny miesiąc",
        "-1": "poprzedni miesiąc"
      },
      "relativeTime": {
        "future": {
          "one": "w {0} miesiącu",
          "other": "w {0} miesiącach"
        },
        "past": {
          "one": "{0} miesiąc temu",
          "other": "{0}  miesięcy temu"
        }
      }
    },
    "month-short": {
      "displayName": "miesiąc",
      "relative": {
        "0": "ten miesiąc",
        "1": "następny miesiąc",
        "-1": "poprzedni miesiąc"
      },
      "relativeTime": {
        "future": {
          "one": "z {0} miesiąc",
          "other": "za {0} miesięcy"
        },
        "past": {
          "one": "{0} miesiąc temu",
          "other": "{0} miesięcy temu"
        }
      }
    },
    "day": {
      "displayName": "dzień",
      "relative": {
        "0": "dzisiaj",
        "1": "jutro",
        "-1": "wczoraj"
      },
      "relativeTime": {
        "future": {
          "one": "za {0} dzień",
          "other": "za {0} dni"
        },
        "past": {
          "one": "{0} dzień temu",
          "other": "{0} dni temu"
        }
      }
    },
    "day-short": {
      "displayName": "dzień",
      "relative": {
        "0": "dzisiaj",
        "1": "jutro",
        "-1": "wczoraj"
      },
      "relativeTime": {
        "future": {
          "one": "za {0} dzień",
          "other": "za {0} dni"
        },
        "past": {
          "one": "{0} dzień temu",
          "other": "{0} dni temu"
        }
      }
    },
    "hour": {
      "displayName": "godzina",
      "relative": {
        "0": "ta godzina"
      },
      "relativeTime": {
        "future": {
          "one": "za {0} godzinę",
          "other": "za {0} godzin"
        },
        "past": {
          "one": "{0} godzina temu",
          "other": "{0} godzin temu"
        }
      }
    },
    "hour-short": {
      "displayName": "godz.",
      "relative": {
        "0": "ta godzina"
      },
      "relativeTime": {
        "future": {
          "one": "za {0} godz.",
          "other": "za {0} godz."
        },
        "past": {
          "one": "{0} godz. temu",
          "other": "{0} godz. temu"
        }
      }
    },
    "minute": {
      "displayName": "minuta",
      "relative": {
        "0": "ta minuta"
      },
      "relativeTime": {
        "future": {
          "one": "za {0} minutę",
          "other": "za {0} minut"
        },
        "past": {
          "one": "{0} minuta temu",
          "other": "{0} minut temu"
        }
      }
    },
    "minute-short": {
      "displayName": "min.",
      "relative": {
        "0": "ta min."
      },
      "relativeTime": {
        "future": {
          "one": "za {0} min.",
          "other": "za {0} min."
        },
        "past": {
          "one": "{0} min. temu",
          "other": "{0} min. temu"
        }
      }
    },
    "second": {
      "displayName": "sekunda",
      "relative": {
        "0": "teraz"
      },
      "relativeTime": {
        "future": {
          "one": "za {0} sekundę",
          "other": "za {0} sekund"
        },
        "past": {
          "one": "{0} sekundę temu",
          "other": "{0} sekund temu"
        }
      }
    },
    "second-short": {
      "displayName": "sek.",
      "relative": {
        "0": "teraz"
      },
      "relativeTime": {
        "future": {
          "one": "za {0} sek.",
          "other": "za {0} sek."
        },
        "past": {
          "one": "{0} sek. temu",
          "other": "{0} sek. temu"
        }
      }
    }
  }
});
addLocaleData({
  locale: "pl-PL",
  parentLocale: "pl"
});
addLocaleData({
  locale: "pt",
  pluralRuleFunction: function (n, ord) {
    var s = String(n).split('.'),
      i = s[0];
    if (ord) return 'other';
    return i == 0 || i == 1 ? 'one' : 'other';
  },
  "fields": {
    "year": {
      "displayName": "ano",
      "relative": {
        "0": "este ano",
        "1": "próximo ano",
        "-1": "ano passado"
      },
      "relativeTime": {
        "future": {
          "one": "em {0} ano",
          "other": "em {0} anos"
        },
        "past": {
          "one": "há {0} ano",
          "other": "há {0} anos"
        }
      }
    },
    "year-short": {
      "displayName": "ano",
      "relative": {
        "0": "este ano",
        "1": "próximo ano",
        "-1": "ano passado"
      },
      "relativeTime": {
        "future": {
          "one": "em {0} ano",
          "other": "em {0} anos"
        },
        "past": {
          "one": "há {0} ano",
          "other": "há {0} anos"
        }
      }
    },
    "month": {
      "displayName": "mês",
      "relative": {
        "0": "este mês",
        "1": "próximo mês",
        "-1": "mês passado"
      },
      "relativeTime": {
        "future": {
          "one": "em {0} mês",
          "other": "em {0} meses"
        },
        "past": {
          "one": "há {0} mês",
          "other": "há {0} meses"
        }
      }
    },
    "month-short": {
      "displayName": "mês",
      "relative": {
        "0": "este mês",
        "1": "próximo mês",
        "-1": "mês passado"
      },
      "relativeTime": {
        "future": {
          "one": "em {0} mês",
          "other": "em {0} meses"
        },
        "past": {
          "one": "há {0} mês",
          "other": "há {0} meses"
        }
      }
    },
    "week": {
      "displayName": "semana",
      "relativePeriod": "a semana de {0}",
      "relative": {
        "0": "esta semana",
        "1": "próxima semana",
        "-1": "semana passada"
      },
      "relativeTime": {
        "future": {
          "one": "em {0} semana",
          "other": "em {0} semanas"
        },
        "past": {
          "one": "há {0} semana",
          "other": "há {0} semanas"
        }
      }
    },
    "week-short": {
      "displayName": "sem.",
      "relativePeriod": "a semana de {0}",
      "relative": {
        "0": "esta semana",
        "1": "próxima semana",
        "-1": "semana passada"
      },
      "relativeTime": {
        "future": {
          "one": "em {0} sem.",
          "other": "em {0} sem."
        },
        "past": {
          "one": "há {0} sem.",
          "other": "há {0} sem."
        }
      }
    },
    "day": {
      "displayName": "dia",
      "relative": {
        "0": "hoje",
        "1": "amanhã",
        "2": "depois de amanhã",
        "-2": "anteontem",
        "-1": "ontem"
      },
      "relativeTime": {
        "future": {
          "one": "em {0} dia",
          "other": "em {0} dias"
        },
        "past": {
          "one": "há {0} dia",
          "other": "há {0} dias"
        }
      }
    },
    "day-short": {
      "displayName": "dia",
      "relative": {
        "0": "hoje",
        "1": "amanhã",
        "2": "depois de amanhã",
        "-2": "anteontem",
        "-1": "ontem"
      },
      "relativeTime": {
        "future": {
          "one": "em {0} dia",
          "other": "em {0} dias"
        },
        "past": {
          "one": "há {0} dia",
          "other": "há {0} dias"
        }
      }
    },
    "hour": {
      "displayName": "hora",
      "relative": {
        "0": "esta hora"
      },
      "relativeTime": {
        "future": {
          "one": "em {0} hora",
          "other": "em {0} horas"
        },
        "past": {
          "one": "há {0} hora",
          "other": "há {0} horas"
        }
      }
    },
    "hour-short": {
      "displayName": "h",
      "relative": {
        "0": "esta hora"
      },
      "relativeTime": {
        "future": {
          "one": "em {0} h",
          "other": "em {0} h"
        },
        "past": {
          "one": "há {0} h",
          "other": "há {0} h"
        }
      }
    },
    "minute": {
      "displayName": "minuto",
      "relative": {
        "0": "este minuto"
      },
      "relativeTime": {
        "future": {
          "one": "em {0} minuto",
          "other": "em {0} minutos"
        },
        "past": {
          "one": "há {0} minuto",
          "other": "há {0} minutos"
        }
      }
    },
    "minute-short": {
      "displayName": "min.",
      "relative": {
        "0": "este minuto"
      },
      "relativeTime": {
        "future": {
          "one": "em {0} min.",
          "other": "em {0} min."
        },
        "past": {
          "one": "há {0} min.",
          "other": "há {0} min."
        }
      }
    },
    "second": {
      "displayName": "segundo",
      "relative": {
        "0": "agora"
      },
      "relativeTime": {
        "future": {
          "one": "em {0} segundo",
          "other": "em {0} segundos"
        },
        "past": {
          "one": "há {0} segundo",
          "other": "há {0} segundos"
        }
      }
    },
    "second-short": {
      "displayName": "seg.",
      "relative": {
        "0": "agora"
      },
      "relativeTime": {
        "future": {
          "one": "em {0} seg.",
          "other": "em {0} seg."
        },
        "past": {
          "one": "há {0} seg.",
          "other": "há {0} seg."
        }
      }
    }
  }
});
addLocaleData({
  locale: "pt-PT",
  parentLocale: "pt",
  pluralRuleFunction: function (n) {
    var s = String(n).split('.'),
      v0 = !s[1];
    return n == 1 && v0 ? 'one' : 'other';
  },
  "fields": {
    "year": {
      "displayName": "ano",
      "relative": {
        "0": "este ano",
        "1": "próximo ano",
        "-1": "ano passado"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} ano",
          "other": "dentro de {0} anos"
        },
        "past": {
          "one": "há {0} ano",
          "other": "há {0} anos"
        }
      }
    },
    "year-short": {
      "displayName": "ano",
      "relative": {
        "0": "este ano",
        "1": "próximo ano",
        "-1": "ano passado"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} ano",
          "other": "dentro de {0} anos"
        },
        "past": {
          "one": "há {0} ano",
          "other": "há {0} anos"
        }
      }
    },
    "month": {
      "displayName": "mês",
      "relative": {
        "0": "este mês",
        "1": "próximo mês",
        "-1": "mês passado"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} mês",
          "other": "dentro de {0} meses"
        },
        "past": {
          "one": "há {0} mês",
          "other": "há {0} meses"
        }
      }
    },
    "month-short": {
      "displayName": "mês",
      "relative": {
        "0": "este mês",
        "1": "próximo mês",
        "-1": "mês passado"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} mês",
          "other": "dentro de {0} meses"
        },
        "past": {
          "one": "há {0} mês",
          "other": "há {0} meses"
        }
      }
    },
    "week": {
      "displayName": "semana",
      "relativePeriod": "a semana de {0}",
      "relative": {
        "0": "esta semana",
        "1": "próxima semana",
        "-1": "semana passada"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} semana",
          "other": "dentro de {0} semanas"
        },
        "past": {
          "one": "há {0} semana",
          "other": "há {0} semanas"
        }
      }
    },
    "week-short": {
      "displayName": "sem.",
      "relativePeriod": "a sem. de {0}",
      "relative": {
        "0": "esta semana",
        "1": "próxima semana",
        "-1": "semana passada"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} sem.",
          "other": "dentro de {0} sem."
        },
        "past": {
          "one": "há {0} sem.",
          "other": "há {0} sem."
        }
      }
    },
    "day": {
      "displayName": "dia",
      "relative": {
        "0": "hoje",
        "1": "amanhã",
        "2": "depois de amanhã",
        "-2": "anteontem",
        "-1": "ontem"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} dia",
          "other": "dentro de {0} dias"
        },
        "past": {
          "one": "há {0} dia",
          "other": "há {0} dias"
        }
      }
    },
    "day-short": {
      "displayName": "dia",
      "relative": {
        "0": "hoje",
        "1": "amanhã",
        "2": "depois de amanhã",
        "-2": "anteontem",
        "-1": "ontem"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} dia",
          "other": "dentro de {0} dias"
        },
        "past": {
          "one": "há {0} dia",
          "other": "há {0} dias"
        }
      }
    },
    "hour": {
      "displayName": "hora",
      "relative": {
        "0": "esta hora"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} hora",
          "other": "dentro de {0} horas"
        },
        "past": {
          "one": "há {0} hora",
          "other": "há {0} horas"
        }
      }
    },
    "hour-short": {
      "displayName": "h",
      "relative": {
        "0": "esta hora"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} h",
          "other": "dentro de {0} h"
        },
        "past": {
          "one": "há {0} h",
          "other": "há {0} h"
        }
      }
    },
    "minute": {
      "displayName": "minuto",
      "relative": {
        "0": "este minuto"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} minuto",
          "other": "dentro de {0} minutos"
        },
        "past": {
          "one": "há {0} minuto",
          "other": "há {0} minutos"
        }
      }
    },
    "minute-short": {
      "displayName": "min",
      "relative": {
        "0": "este minuto"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} min",
          "other": "dentro de {0} min"
        },
        "past": {
          "one": "há {0} min",
          "other": "há {0} min"
        }
      }
    },
    "second": {
      "displayName": "segundo",
      "relative": {
        "0": "agora"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} segundo",
          "other": "dentro de {0} segundos"
        },
        "past": {
          "one": "há {0} segundo",
          "other": "há {0} segundos"
        }
      }
    },
    "second-short": {
      "displayName": "s",
      "relative": {
        "0": "agora"
      },
      "relativeTime": {
        "future": {
          "one": "dentro de {0} s",
          "other": "dentro de {0} s"
        },
        "past": {
          "one": "há {0} s",
          "other": "há {0} s"
        }
      }
    }
  }
});
addLocaleData({
  locale: "pt-AO",
  parentLocale: "pt-PT"
});
addLocaleData({
  locale: "pt-BR",
  parentLocale: "pt"
});
addLocaleData({
  locale: "pt-MZ",
  parentLocale: "pt-PT"
});
addLocaleData({
  locale: "ru",
  pluralRuleFunction: function (n, ord) {
    var s = String(n).split("."),
      i = s[0],
      v0 = !s[1],
      i10 = i.slice(-1),
      i100 = i.slice(-2);
    if (ord) return "other";
    return v0 && i10 == 1 && i100 != 11 ? "one" : v0 && i10 >= 2 && i10 <= 4 && (i100 < 12 || i100 > 14) ? "few" : v0 && i10 == 0 || v0 && i10 >= 5 && i10 <= 9 || v0 && i100 >= 11 && i100 <= 14 ? "many" : "other";
  },
  "fields": {
    "year": {
      "displayName": "год",
      "relative": {
        "0": "в этом году",
        "1": "в следующем году",
        "-1": "в прошлом году"
      },
      "relativeTime": {
        "future": {
          "one": "через {0} год",
          "few": "через {0} года",
          "many": "через {0} лет",
          "other": "через {0} года"
        },
        "past": {
          "one": "{0} год назад",
          "few": "{0} года назад",
          "many": "{0} лет назад",
          "other": "{0} года назад"
        }
      }
    },
    "year-short": {
      "displayName": "г.",
      "relative": {
        "0": "в этом г.",
        "1": "в след. г.",
        "-1": "в прошлом г."
      },
      "relativeTime": {
        "future": {
          "one": "через {0} г.",
          "few": "через {0} г.",
          "many": "через {0} л.",
          "other": "через {0} г."
        },
        "past": {
          "one": "{0} г. назад",
          "few": "{0} г. назад",
          "many": "{0} л. назад",
          "other": "{0} г. назад"
        }
      }
    },
    "month": {
      "displayName": "месяц",
      "relative": {
        "0": "в этом месяце",
        "1": "в следующем месяце",
        "-1": "в прошлом месяце"
      },
      "relativeTime": {
        "future": {
          "one": "через {0} месяц",
          "few": "через {0} месяца",
          "many": "через {0} месяцев",
          "other": "через {0} месяца"
        },
        "past": {
          "one": "{0} месяц назад",
          "few": "{0} месяца назад",
          "many": "{0} месяцев назад",
          "other": "{0} месяца назад"
        }
      }
    },
    "month-short": {
      "displayName": "мес.",
      "relative": {
        "0": "в этом мес.",
        "1": "в следующем мес.",
        "-1": "в прошлом мес."
      },
      "relativeTime": {
        "future": {
          "one": "через {0} мес.",
          "few": "через {0} мес.",
          "many": "через {0} мес.",
          "other": "через {0} мес."
        },
        "past": {
          "one": "{0} мес. назад",
          "few": "{0} мес. назад",
          "many": "{0} мес. назад",
          "other": "{0} мес. назад"
        }
      }
    },
    "week": {
      "displayName": "неделя",
      "relativePeriod": "на неделе {0}",
      "relative": {
        "0": "на этой неделе",
        "1": "на следующей неделе",
        "-1": "на прошлой неделе"
      },
      "relativeTime": {
        "future": {
          "one": "через {0} неделю",
          "few": "через {0} недели",
          "many": "через {0} недель",
          "other": "через {0} недели"
        },
        "past": {
          "one": "{0} неделю назад",
          "few": "{0} недели назад",
          "many": "{0} недель назад",
          "other": "{0} недели назад"
        }
      }
    },
    "week-short": {
      "displayName": "нед.",
      "relativePeriod": "на нед. {0}",
      "relative": {
        "0": "на этой нед.",
        "1": "на следующей нед.",
        "-1": "на прошлой нед."
      },
      "relativeTime": {
        "future": {
          "one": "через {0} нед.",
          "few": "через {0} нед.",
          "many": "через {0} нед.",
          "other": "через {0} нед."
        },
        "past": {
          "one": "{0} нед. назад",
          "few": "{0} нед. назад",
          "many": "{0} нед. назад",
          "other": "{0} нед. назад"
        }
      }
    },
    "day": {
      "displayName": "день",
      "relative": {
        "0": "сегодня",
        "1": "завтра",
        "2": "послезавтра",
        "-1": "вчера",
        "-2": "позавчера"
      },
      "relativeTime": {
        "future": {
          "one": "через {0} день",
          "few": "через {0} дня",
          "many": "через {0} дней",
          "other": "через {0} дня"
        },
        "past": {
          "one": "{0} день назад",
          "few": "{0} дня назад",
          "many": "{0} дней назад",
          "other": "{0} дня назад"
        }
      }
    },
    "day-short": {
      "displayName": "дн.",
      "relative": {
        "0": "сегодня",
        "1": "завтра",
        "2": "послезавтра",
        "-1": "вчера",
        "-2": "позавчера"
      },
      "relativeTime": {
        "future": {
          "one": "через {0} дн.",
          "few": "через {0} дн.",
          "many": "через {0} дн.",
          "other": "через {0} дн."
        },
        "past": {
          "one": "{0} дн. назад",
          "few": "{0} дн. назад",
          "many": "{0} дн. назад",
          "other": "{0} дн. назад"
        }
      }
    },
    "hour": {
      "displayName": "час",
      "relative": {
        "0": "в этот час"
      },
      "relativeTime": {
        "future": {
          "one": "через {0} час",
          "few": "через {0} часа",
          "many": "через {0} часов",
          "other": "через {0} часа"
        },
        "past": {
          "one": "{0} час назад",
          "few": "{0} часа назад",
          "many": "{0} часов назад",
          "other": "{0} часа назад"
        }
      }
    },
    "hour-short": {
      "displayName": "ч",
      "relative": {
        "0": "в этот час"
      },
      "relativeTime": {
        "future": {
          "one": "через {0} ч.",
          "few": "через {0} ч.",
          "many": "через {0} ч.",
          "other": "через {0} ч."
        },
        "past": {
          "one": "{0} ч. назад",
          "few": "{0} ч. назад",
          "many": "{0} ч. назад",
          "other": "{0} ч. назад"
        }
      }
    },
    "minute": {
      "displayName": "минута",
      "relative": {
        "0": "в эту минуту"
      },
      "relativeTime": {
        "future": {
          "one": "через {0} минуту",
          "few": "через {0} минуты",
          "many": "через {0} минут",
          "other": "через {0} минуты"
        },
        "past": {
          "one": "{0} минуту назад",
          "few": "{0} минуты назад",
          "many": "{0} минут назад",
          "other": "{0} минуты назад"
        }
      }
    },
    "minute-short": {
      "displayName": "мин.",
      "relative": {
        "0": "в эту минуту"
      },
      "relativeTime": {
        "future": {
          "one": "через {0} мин.",
          "few": "через {0} мин.",
          "many": "через {0} мин.",
          "other": "через {0} мин."
        },
        "past": {
          "one": "{0} мин. назад",
          "few": "{0} мин. назад",
          "many": "{0} мин. назад",
          "other": "{0} мин. назад"
        }
      }
    },
    "second": {
      "displayName": "секунда",
      "relative": {
        "0": "сейчас"
      },
      "relativeTime": {
        "future": {
          "one": "через {0} секунду",
          "few": "через {0} секунды",
          "many": "через {0} секунд",
          "other": "через {0} секунды"
        },
        "past": {
          "one": "{0} секунду назад",
          "few": "{0} секунды назад",
          "many": "{0} секунд назад",
          "other": "{0} секунды назад"
        }
      }
    },
    "second-short": {
      "displayName": "сек.",
      "relative": {
        "0": "сейчас"
      },
      "relativeTime": {
        "future": {
          "one": "через {0} сек.",
          "few": "через {0} сек.",
          "many": "через {0} сек.",
          "other": "через {0} сек."
        },
        "past": {
          "one": "{0} сек. назад",
          "few": "{0} сек. назад",
          "many": "{0} сек. назад",
          "other": "{0} сек. назад"
        }
      }
    }
  }
});
addLocaleData({
  locale: "ru-RU",
  parentLocale: "ru"
});
addLocaleData({
  locale: "tr",
  pluralRuleFunction: function (n, ord) {
    if (ord) return 'other';
    return n == 1 ? 'one' : 'other';
  },
  "fields": {
    "year": {
      "displayName": "yıl",
      "relative": {
        "0": "bu yıl",
        "1": "gelecek yıl",
        "-1": "geçen yıl"
      },
      "relativeTime": {
        "future": {
          "one": "{0} yıl sonra",
          "other": "{0} yıl sonra"
        },
        "past": {
          "one": "{0} yıl önce",
          "other": "{0} yıl önce"
        }
      }
    },
    "year-short": {
      "displayName": "yıl",
      "relative": {
        "0": "bu yıl",
        "1": "gelecek yıl",
        "-1": "geçen yıl"
      },
      "relativeTime": {
        "future": {
          "one": "{0} yıl sonra",
          "other": "{0} yıl sonra"
        },
        "past": {
          "one": "{0} yıl önce",
          "other": "{0} yıl önce"
        }
      }
    },
    "month": {
      "displayName": "ay",
      "relative": {
        "0": "bu ay",
        "1": "gelecek ay",
        "-1": "geçen ay"
      },
      "relativeTime": {
        "future": {
          "one": "{0} ay sonra",
          "other": "{0} ay sonra"
        },
        "past": {
          "one": "{0} ay önce",
          "other": "{0} ay önce"
        }
      }
    },
    "month-short": {
      "displayName": "ay",
      "relative": {
        "0": "bu ay",
        "1": "gelecek ay",
        "-1": "geçen ay"
      },
      "relativeTime": {
        "future": {
          "one": "{0} ay sonra",
          "other": "{0} ay sonra"
        },
        "past": {
          "one": "{0} ay önce",
          "other": "{0} ay önce"
        }
      }
    },
    "week": {
      "displayName": "hafta",
      "relativePeriod": "{0} haftası",
      "relative": {
        "0": "bu hafta",
        "1": "gelecek hafta",
        "-1": "geçen hafta"
      },
      "relativeTime": {
        "future": {
          "one": "{0} hafta sonra",
          "other": "{0} hafta sonra"
        },
        "past": {
          "one": "{0} hafta önce",
          "other": "{0} hafta önce"
        }
      }
    },
    "week-short": {
      "displayName": "hf.",
      "relativePeriod": "{0} haftası",
      "relative": {
        "0": "bu hafta",
        "1": "gelecek hafta",
        "-1": "geçen hafta"
      },
      "relativeTime": {
        "future": {
          "one": "{0} hf. sonra",
          "other": "{0} hf. sonra"
        },
        "past": {
          "one": "{0} hf. önce",
          "other": "{0} hf. önce"
        }
      }
    },
    "day": {
      "displayName": "gün",
      "relative": {
        "0": "bugün",
        "1": "yarın",
        "2": "öbür gün",
        "-2": "evvelsi gün",
        "-1": "dün"
      },
      "relativeTime": {
        "future": {
          "one": "{0} gün sonra",
          "other": "{0} gün sonra"
        },
        "past": {
          "one": "{0} gün önce",
          "other": "{0} gün önce"
        }
      }
    },
    "day-short": {
      "displayName": "gün",
      "relative": {
        "0": "bugün",
        "1": "yarın",
        "2": "öbür gün",
        "-2": "evvelsi gün",
        "-1": "dün"
      },
      "relativeTime": {
        "future": {
          "one": "{0} gün sonra",
          "other": "{0} gün sonra"
        },
        "past": {
          "one": "{0} gün önce",
          "other": "{0} gün önce"
        }
      }
    },
    "hour": {
      "displayName": "saat",
      "relative": {
        "0": "bu saat"
      },
      "relativeTime": {
        "future": {
          "one": "{0} saat sonra",
          "other": "{0} saat sonra"
        },
        "past": {
          "one": "{0} saat önce",
          "other": "{0} saat önce"
        }
      }
    },
    "hour-short": {
      "displayName": "sa.",
      "relative": {
        "0": "bu saat"
      },
      "relativeTime": {
        "future": {
          "one": "{0} sa. sonra",
          "other": "{0} sa. sonra"
        },
        "past": {
          "one": "{0} sa. önce",
          "other": "{0} sa. önce"
        }
      }
    },
    "minute": {
      "displayName": "dakika",
      "relative": {
        "0": "bu dakika"
      },
      "relativeTime": {
        "future": {
          "one": "{0} dakika sonra",
          "other": "{0} dakika sonra"
        },
        "past": {
          "one": "{0} dakika önce",
          "other": "{0} dakika önce"
        }
      }
    },
    "minute-short": {
      "displayName": "dk.",
      "relative": {
        "0": "bu dakika"
      },
      "relativeTime": {
        "future": {
          "one": "{0} dk. sonra",
          "other": "{0} dk. sonra"
        },
        "past": {
          "one": "{0} dk. önce",
          "other": "{0} dk. önce"
        }
      }
    },
    "second": {
      "displayName": "saniye",
      "relative": {
        "0": "şimdi"
      },
      "relativeTime": {
        "future": {
          "one": "{0} saniye sonra",
          "other": "{0} saniye sonra"
        },
        "past": {
          "one": "{0} saniye önce",
          "other": "{0} saniye önce"
        }
      }
    },
    "second-short": {
      "displayName": "sn.",
      "relative": {
        "0": "şimdi"
      },
      "relativeTime": {
        "future": {
          "one": "{0} sn. sonra",
          "other": "{0} sn. sonra"
        },
        "past": {
          "one": "{0} sn. önce",
          "other": "{0} sn. önce"
        }
      }
    }
  }
});
addLocaleData({
  locale: "tr-CY",
  parentLocale: "tr"
});
addLocaleData({
  locale: "tr-TR",
  parentLocale: "tr"
});
addLocaleData({
  locale: "zh",
  pluralRuleFunction: function (n, ord) {
    if (ord) return "other";
    return "other";
  },
  "fields": {
    "year": {
      "displayName": "年",
      "relative": {
        "0": "今年",
        "1": "明年",
        "-1": "去年"
      },
      "relativeTime": {
        "future": {
          "other": "{0}年后"
        },
        "past": {
          "other": "{0}年前"
        }
      }
    },
    "year-short": {
      "displayName": "年",
      "relative": {
        "0": "今年",
        "1": "明年",
        "-1": "去年"
      },
      "relativeTime": {
        "future": {
          "other": "{0}年后"
        },
        "past": {
          "other": "{0}年前"
        }
      }
    },
    "month": {
      "displayName": "月",
      "relative": {
        "0": "本月",
        "1": "下个月",
        "-1": "上个月"
      },
      "relativeTime": {
        "future": {
          "other": "{0}个月后"
        },
        "past": {
          "other": "{0}个月前"
        }
      }
    },
    "month-short": {
      "displayName": "月",
      "relative": {
        "0": "本月",
        "1": "下个月",
        "-1": "上个月"
      },
      "relativeTime": {
        "future": {
          "other": "{0}个月后"
        },
        "past": {
          "other": "{0}个月前"
        }
      }
    },
    "day": {
      "displayName": "日",
      "relative": {
        "0": "今天",
        "1": "明天",
        "2": "后天",
        "-2": "前天",
        "-1": "昨天"
      },
      "relativeTime": {
        "future": {
          "other": "{0}天后"
        },
        "past": {
          "other": "{0}天前"
        }
      }
    },
    "day-short": {
      "displayName": "日",
      "relative": {
        "0": "今天",
        "1": "明天",
        "2": "后天",
        "-2": "前天",
        "-1": "昨天"
      },
      "relativeTime": {
        "future": {
          "other": "{0}天后"
        },
        "past": {
          "other": "{0}天前"
        }
      }
    },
    "hour": {
      "displayName": "小时",
      "relative": {
        "0": "这一时间 \u002F 此时"
      },
      "relativeTime": {
        "future": {
          "other": "{0}小时后"
        },
        "past": {
          "other": "{0}小时前"
        }
      }
    },
    "hour-short": {
      "displayName": "小时",
      "relative": {
        "0": "这一时间 \u002F 此时"
      },
      "relativeTime": {
        "future": {
          "other": "{0}小时后"
        },
        "past": {
          "other": "{0}小时前"
        }
      }
    },
    "minute": {
      "displayName": "分钟",
      "relative": {
        "0": "此刻"
      },
      "relativeTime": {
        "future": {
          "other": "{0}分钟后"
        },
        "past": {
          "other": "{0}分钟前"
        }
      }
    },
    "minute-short": {
      "displayName": "分",
      "relative": {
        "0": "此刻"
      },
      "relativeTime": {
        "future": {
          "other": "{0}分钟后"
        },
        "past": {
          "other": "{0}分钟前"
        }
      }
    },
    "second": {
      "displayName": "秒",
      "relative": {
        "0": "现在"
      },
      "relativeTime": {
        "future": {
          "other": "{0}秒钟后"
        },
        "past": {
          "other": "{0}秒钟前"
        }
      }
    },
    "second-short": {
      "displayName": "秒",
      "relative": {
        "0": "现在"
      },
      "relativeTime": {
        "future": {
          "other": "{0}秒后"
        },
        "past": {
          "other": "{0}秒前"
        }
      }
    }
  }
});
addLocaleData({
  locale: "zh-Hans",
  parentLocale: "zh"
});
addLocaleData({
  locale: "zh-CN",
  parentLocale: "zh"
});
addLocaleData({
  locale: "zh-Hans-SG",
  parentLocale: "zh-Hans",
  "fields": {
    "year": {
      "displayName": "年",
      "relative": {
        "0": "今年",
        "1": "明年",
        "-1": "去年"
      },
      "relativeTime": {
        "future": {
          "other": "{0}年后"
        },
        "past": {
          "other": "{0}年前"
        }
      }
    },
    "year-short": {
      "displayName": "年",
      "relative": {
        "0": "今年",
        "1": "明年",
        "-1": "去年"
      },
      "relativeTime": {
        "future": {
          "other": "{0}年后"
        },
        "past": {
          "other": "{0}年前"
        }
      }
    },
    "month": {
      "displayName": "月",
      "relative": {
        "0": "本月",
        "1": "下个月",
        "-1": "上个月"
      },
      "relativeTime": {
        "future": {
          "other": "{0}个月后"
        },
        "past": {
          "other": "{0}个月前"
        }
      }
    },
    "month-short": {
      "displayName": "月",
      "relative": {
        "0": "本月",
        "1": "下个月",
        "-1": "上个月"
      },
      "relativeTime": {
        "future": {
          "other": "{0}个月后"
        },
        "past": {
          "other": "{0}个月前"
        }
      }
    },
    "week": {
      "displayName": "周",
      "relativePeriod": "{0}这周",
      "relative": {
        "0": "本周",
        "1": "下周",
        "-1": "上周"
      },
      "relativeTime": {
        "future": {
          "other": "{0}周后"
        },
        "past": {
          "other": "{0}周前"
        }
      }
    },
    "week-short": {
      "displayName": "周",
      "relativePeriod": "{0}这周",
      "relative": {
        "0": "本周",
        "1": "下周",
        "-1": "上周"
      },
      "relativeTime": {
        "future": {
          "other": "{0}周后"
        },
        "past": {
          "other": "{0}周前"
        }
      }
    },
    "day": {
      "displayName": "日",
      "relative": {
        "0": "今天",
        "1": "明天",
        "2": "后天",
        "-2": "前天",
        "-1": "昨天"
      },
      "relativeTime": {
        "future": {
          "other": "{0}天后"
        },
        "past": {
          "other": "{0}天前"
        }
      }
    },
    "day-short": {
      "displayName": "日",
      "relative": {
        "0": "今天",
        "1": "明天",
        "2": "后天",
        "-2": "前天",
        "-1": "昨天"
      },
      "relativeTime": {
        "future": {
          "other": "{0}天后"
        },
        "past": {
          "other": "{0}天前"
        }
      }
    },
    "hour": {
      "displayName": "小时",
      "relative": {
        "0": "这一时间 \u002F 此时"
      },
      "relativeTime": {
        "future": {
          "other": "{0}小时后"
        },
        "past": {
          "other": "{0}小时前"
        }
      }
    },
    "hour-short": {
      "displayName": "小时",
      "relative": {
        "0": "这一时间 \u002F 此时"
      },
      "relativeTime": {
        "future": {
          "other": "{0}小时后"
        },
        "past": {
          "other": "{0}小时前"
        }
      }
    },
    "minute": {
      "displayName": "分钟",
      "relative": {
        "0": "此刻"
      },
      "relativeTime": {
        "future": {
          "other": "{0}分钟后"
        },
        "past": {
          "other": "{0}分钟前"
        }
      }
    },
    "minute-short": {
      "displayName": "分",
      "relative": {
        "0": "此刻"
      },
      "relativeTime": {
        "future": {
          "other": "{0}分钟后"
        },
        "past": {
          "other": "{0}分钟前"
        }
      }
    },
    "second": {
      "displayName": "秒",
      "relative": {
        "0": "现在"
      },
      "relativeTime": {
        "future": {
          "other": "{0}秒后"
        },
        "past": {
          "other": "{0}秒前"
        }
      }
    },
    "second-short": {
      "displayName": "秒",
      "relative": {
        "0": "现在"
      },
      "relativeTime": {
        "future": {
          "other": "{0}秒后"
        },
        "past": {
          "other": "{0}秒前"
        }
      }
    }
  }
});
addLocaleData({
  locale: "zh-Hant",
  pluralRuleFunction: function (n) {
    return 'other';
  },
  "fields": {
    "year": {
      "displayName": "年",
      "relative": {
        "0": "今年",
        "1": "明年",
        "-1": "去年"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 年後"
        },
        "past": {
          "other": "{0} 年前"
        }
      }
    },
    "year-short": {
      "displayName": "年",
      "relative": {
        "0": "今年",
        "1": "明年",
        "-1": "去年"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 年後"
        },
        "past": {
          "other": "{0} 年前"
        }
      }
    },
    "month": {
      "displayName": "月",
      "relative": {
        "0": "本月",
        "1": "下個月",
        "-1": "上個月"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 個月後"
        },
        "past": {
          "other": "{0} 個月前"
        }
      }
    },
    "month-short": {
      "displayName": "月",
      "relative": {
        "0": "本月",
        "1": "下個月",
        "-1": "上個月"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 個月後"
        },
        "past": {
          "other": "{0} 個月前"
        }
      }
    },
    "week": {
      "displayName": "週",
      "relativePeriod": "{0} 當週",
      "relative": {
        "0": "本週",
        "1": "下週",
        "-1": "上週"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 週後"
        },
        "past": {
          "other": "{0} 週前"
        }
      }
    },
    "week-short": {
      "displayName": "週",
      "relativePeriod": "{0} 當週",
      "relative": {
        "0": "本週",
        "1": "下週",
        "-1": "上週"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 週後"
        },
        "past": {
          "other": "{0} 週前"
        }
      }
    },
    "day": {
      "displayName": "日",
      "relative": {
        "0": "今天",
        "1": "明天",
        "2": "後天",
        "-2": "前天",
        "-1": "昨天"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 天後"
        },
        "past": {
          "other": "{0} 天前"
        }
      }
    },
    "day-short": {
      "displayName": "日",
      "relative": {
        "0": "今天",
        "1": "明天",
        "2": "後天",
        "-2": "前天",
        "-1": "昨天"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 天後"
        },
        "past": {
          "other": "{0} 天前"
        }
      }
    },
    "hour": {
      "displayName": "小時",
      "relative": {
        "0": "這一小時"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 小時後"
        },
        "past": {
          "other": "{0} 小時前"
        }
      }
    },
    "hour-short": {
      "displayName": "小時",
      "relative": {
        "0": "這一小時"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 小時後"
        },
        "past": {
          "other": "{0} 小時前"
        }
      }
    },
    "minute": {
      "displayName": "分鐘",
      "relative": {
        "0": "這一分鐘"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 分鐘後"
        },
        "past": {
          "other": "{0} 分鐘前"
        }
      }
    },
    "minute-short": {
      "displayName": "分鐘",
      "relative": {
        "0": "這一分鐘"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 分鐘後"
        },
        "past": {
          "other": "{0} 分鐘前"
        }
      }
    },
    "second": {
      "displayName": "秒",
      "relative": {
        "0": "現在"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 秒後"
        },
        "past": {
          "other": "{0} 秒前"
        }
      }
    },
    "second-short": {
      "displayName": "秒",
      "relative": {
        "0": "現在"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 秒後"
        },
        "past": {
          "other": "{0} 秒前"
        }
      }
    }
  }
});
addLocaleData({
  locale: "zh-Hant-HK",
  parentLocale: "zh-Hant",
  "fields": {
    "year": {
      "displayName": "年",
      "relative": {
        "0": "今年",
        "1": "下年",
        "-1": "上年"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 年後"
        },
        "past": {
          "other": "{0} 年前"
        }
      }
    },
    "year-short": {
      "displayName": "年",
      "relative": {
        "0": "今年",
        "1": "下年",
        "-1": "上年"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 年後"
        },
        "past": {
          "other": "{0} 年前"
        }
      }
    },
    "month": {
      "displayName": "月",
      "relative": {
        "0": "本月",
        "1": "下個月",
        "-1": "上個月"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 個月後"
        },
        "past": {
          "other": "{0} 個月前"
        }
      }
    },
    "month-short": {
      "displayName": "月",
      "relative": {
        "0": "本月",
        "1": "下個月",
        "-1": "上個月"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 個月後"
        },
        "past": {
          "other": "{0} 個月前"
        }
      }
    },
    "week": {
      "displayName": "星期",
      "relativePeriod": "{0} 當週",
      "relative": {
        "0": "本星期",
        "1": "下星期",
        "-1": "上星期"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 星期後"
        },
        "past": {
          "other": "{0} 星期前"
        }
      }
    },
    "week-short": {
      "displayName": "星期",
      "relativePeriod": "{0} 當週",
      "relative": {
        "0": "本星期",
        "1": "下星期",
        "-1": "上星期"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 星期後"
        },
        "past": {
          "other": "{0} 星期前"
        }
      }
    },
    "day": {
      "displayName": "日",
      "relative": {
        "0": "今日",
        "1": "明日",
        "2": "後日",
        "-2": "前日",
        "-1": "昨日"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 日後"
        },
        "past": {
          "other": "{0} 日前"
        }
      }
    },
    "day-short": {
      "displayName": "日",
      "relative": {
        "0": "今日",
        "1": "明日",
        "2": "後日",
        "-2": "前日",
        "-1": "昨日"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 日後"
        },
        "past": {
          "other": "{0} 日前"
        }
      }
    },
    "hour": {
      "displayName": "小時",
      "relative": {
        "0": "這個小時"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 小時後"
        },
        "past": {
          "other": "{0} 小時前"
        }
      }
    },
    "hour-short": {
      "displayName": "小時",
      "relative": {
        "0": "這個小時"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 小時後"
        },
        "past": {
          "other": "{0} 小時前"
        }
      }
    },
    "minute": {
      "displayName": "分鐘",
      "relative": {
        "0": "這分鐘"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 分鐘後"
        },
        "past": {
          "other": "{0} 分鐘前"
        }
      }
    },
    "minute-short": {
      "displayName": "分鐘",
      "relative": {
        "0": "這分鐘"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 分鐘後"
        },
        "past": {
          "other": "{0} 分鐘前"
        }
      }
    },
    "second": {
      "displayName": "秒",
      "relative": {
        "0": "現在"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 秒後"
        },
        "past": {
          "other": "{0} 秒前"
        }
      }
    },
    "second-short": {
      "displayName": "秒",
      "relative": {
        "0": "現在"
      },
      "relativeTime": {
        "future": {
          "other": "{0} 秒後"
        },
        "past": {
          "other": "{0} 秒前"
        }
      }
    }
  }
});
addLocaleData({
  locale: "zh-HK",
  parentLocale: "zh-Hant-HK"
});
addLocaleData({
  locale: "zh-Hant-MO",
  parentLocale: "zh-Hant-HK"
});
addLocaleData({
  locale: "zh-MO",
  parentLocale: "zh-Hant-HK"
});
addLocaleData({
  locale: "zh-SG",
  parentLocale: "zh-Hans-SG"
});
addLocaleData({
  locale: "zh-TW",
  parentLocale: "zh-Hant"
});