untrusted comment: verify with openbsd-76-base.pub
RWTkuwn4mbq8osIGVKDiTDP6iM4Z5npu542R/hhw4k2S1WpKthbQRYHPoGlBDryrIwR9lzFA/fY4hlrugvxWVoZBkDPLIioRmQo=

OpenBSD 7.6 errata 003, October 29, 2024:

mlkem768x25519-sha256 byte order bug on big-endian machines.

Apply by doing:
    signify -Vep /etc/signify/openbsd-76-base.pub -x 003_ssh.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install OpenSSH:
    cd /usr/src/usr.bin/ssh
    make obj
    make
    make install

Index: usr.bin/ssh/kexmlkem768x25519.c
===================================================================
RCS file: /cvs/src/usr.bin/ssh/kexmlkem768x25519.c,v
diff -u -p -r1.1 kexmlkem768x25519.c
--- usr.bin/ssh/kexmlkem768x25519.c	2 Sep 2024 12:13:56 -0000	1.1
+++ usr.bin/ssh/kexmlkem768x25519.c	28 Oct 2024 12:45:13 -0000
@@ -30,6 +30,7 @@
 #include <stdbool.h>
 #include <string.h>
 #include <signal.h>
+#include <endian.h>
 
 #include "sshkey.h"
 #include "kex.h"
Index: usr.bin/ssh/libcrux_mlkem768_sha3.h
===================================================================
RCS file: /cvs/src/usr.bin/ssh/libcrux_mlkem768_sha3.h,v
diff -u -p -r1.1 libcrux_mlkem768_sha3.h
--- usr.bin/ssh/libcrux_mlkem768_sha3.h	2 Sep 2024 12:13:56 -0000	1.1
+++ usr.bin/ssh/libcrux_mlkem768_sha3.h	28 Oct 2024 12:45:14 -0000
@@ -160,18 +160,19 @@ static inline void Eurydice_slice_to_arr
 // CORE STUFF (conversions, endianness, ...)
 
 static inline void core_num__u64_9__to_le_bytes(uint64_t v, uint8_t buf[8]) {
+  v = htole64(v);
   memcpy(buf, &v, sizeof(v));
 }
 static inline uint64_t core_num__u64_9__from_le_bytes(uint8_t buf[8]) {
   uint64_t v;
   memcpy(&v, buf, sizeof(v));
-  return v;
+  return le64toh(v);
 }
 
 static inline uint32_t core_num__u32_8__from_le_bytes(uint8_t buf[4]) {
   uint32_t v;
   memcpy(&v, buf, sizeof(v));
-  return v;
+  return le32toh(v);
 }
 
 static inline uint32_t core_num__u8_6__count_ones(uint8_t x0) {
